# Bash shell commands to define IDL environment variables and aliases.
#
# This script can be used by IDL users who use Bash as their interactive shell
# to define the environment variables and aliases required by IDL
# related commands (idl, idlde, idlhelp, idldemo) if the symbolic links to
# the default directory (/usr/local/itt/idl) are not being used.
#
# Bash users should run idl_setup from their .profile file 
# using the following command:
#
#    . /sware/com/idl-7.0/idl70/bin/idl_setup.bash
#
ITT_DIR=/sware/com/idl-7.0
IDL_DIR=/sware/com/idl-7.0/idl70
export IDL_DIR ITT_DIR
alias ittlicense=$IDL_DIR/bin/ittlicense
alias idl=$IDL_DIR/bin/idl
alias idlde=$IDL_DIR/bin/idlde
alias idlhelp=$IDL_DIR/bin/idlhelp
alias idlman=$IDL_DIR/bin/idlman
alias idlrpc=$IDL_DIR/bin/idlrpc
alias idldemo=$IDL_DIR/bin/idldemo
