;+
;   ===========================  xop_ifc   =========================
;
;   xop_ifc is a generic widget based graphical interface.
;   It allows to include xop-like interfaces in xop at run time.
;   It reads the inputs from a file <application>.ifc which must be
;   sitting in the $XOP_IFC directory or alternatively (is $XOP_IFC
;   is undefined) in $XOP_HOME/ifc directory.
;
;   See the file $XOP_HOME/ifc/mlayer.ifc as an example of how to write
;   these files.
;
;	srio@esrf.fr 97-04-07
;       Modification history:
;	97-09-12 srio@esrf.fr makes no_block keyword. Adds the option
;	  state.ifc.run='<none>' to avoid spawning (to be used in 
;	  applications fully written in IDL). Uses $XOP_IFC as a 
;	  directory from where the *.ifc file is read. If $XOP_IFC
;	  is not set, uses $XOP_HOME/ifc. xop_ifc_run accepts
;	  now 21 (a0,...,a20) generic variables... Use of sdep.pro
;	  for getting system dependencies.
;	97-11-07 srio@esrf.fr ifc files are in $XOP_HOME/ifc and not
;	  longer in $XOP_HOME/data.
;	97-11-07 srio@esrf.fr fixes a bug when loading/writing files. 
;	98-11-04 srio@esrf.fr uses Catch.
;	98-11-24 srio@esrf.fr changes to new input file system (xop2.0)
;	00-07-17 srio@esrf.fr the tags nrows and ncol in the ifc
;		structure are now optional. One of them must be set.
;	02-05-23 srio@esrf.fr bug fixed: writes to a file the correct 
;		version (not 1.0). Added optional input ifc to xop_ifc_run
;	14-01-27 dejus@aps.anl.gov corrected typo on line message,/info,'Defaults from file: '+file
;		removed trailing single quote
;
;-
;
;========================================================================
;
function xop_ifcfile,file_root
;returns the full file name

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,$
	'XOP_IFCFILE: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return,''
endif
ifcdir = Xop_GetEnv('XOP_IFC')
if ifcdir EQ '' then ifcdir = Xop_GetEnv('XOP_HOME')+sdep(/DS)+'ifc'+sdep(/DS) $
    else ifcdir = ifcdir+sdep(/DS)
ifcfile=ifcdir+file_root+'.ifc'
return,ifcfile
end ;xop_ifcfile
;
;========================================================================
;
function xop_ifc_read,file,kw

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,'XOP_IFC_READ: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return,''
endif
a=fileposition(file,'<start>'+kw)
b=fileposition(file,'<end>'+kw)
if a eq -1 or b eq -1 then begin
  itmp = Dialog_message(/error,'Keyword: '+kw+' not found in file: '+file)
  return,''
endif
tmp=''
openr,unit,file,/get_lun
for i=1,a do readf,unit,tmp
text=strarr(b-a-1)
readf,unit,text
free_lun,unit
return,text
end
;
;========================================================================
;
PRO XOP_IFC_RUN,par,commands,ifc
;
; execute commands in a file, giving "par" as input structure and
; using a1 to a20 as temporary variables.
;
;
;

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,$
	'XOP_IFC_RUN: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return
endif
a0 = 0 & a1=0 & a2=0 & a3=0 & a4=0 & a5=0 
a6 = 0 & a7=0 & a8=0 & a9=0 & a10=0 
a11=0 & a12=0 & a13=0 & a14=0 & a15=0 
a16 = 0 & a17=0 & a18=0 & a19=0 & a20=0 
  
for myIndexSrio=0,n_elements(commands)-1 do begin
  ;print,'***********  ',commands(myIndexSrio)
  iTmpSrio=execute(commands(myIndexSrio))
  if iTmpSrio NE 1 then begin
	 iTmpSrio=Dialog_message(/info,$
	'Error executing: '+commands(myIndexSrio))
	return
  endif
endfor
END
;
;=======================================================================
;
PRO XOP_IFC_EVENT,event

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,$
	'XOP_IFC_EVENT: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   goto,out
endif
;
; register the events
;
stateid = Widget_Info(event.handler,/Child)
Widget_control, stateid,  Get_uvalue=state,/No_copy

WIDGET_CONTROL, event.id, GET_UVALUE=eventuval

;
; register the events
;
CASE eventuval OF
	'FILEINPUT': BEGIN
		action=''
		Widget_Control,event.id, Get_Value=action
		CASE action OF
		'Load from file...': BEGIN
		  ;if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
		  filter='*.xop'
		  str_par = Xop_Input_Load(Title=$
		    'Select BM input file...',$
		    /NoConf,Filter=filter,Group=event.top)
		  IF Type(str_par) EQ 8 THEN BEGIN
		    tmp = state.par
		    Copy_Structure,str_par,tmp,/OnlyFirstField,Group=event.top
		    state.par = tmp
		  ENDIF
		  END
		'Save to file...': BEGIN
		  str_par = state.par
		  comment="; xop/xop_ifc,'"+state.file_root+$
		    "'(v"+state.ifc.version+") input file on "+SysTime()
		  Xop_Input_Save,str_par,File=state.file_root+'.xop',$
		    /Write, Group=event.top, Comment=comment
		  END
		'Save as default': BEGIN
		  str_par = state.par
		  comment="; xop/xop_ifc,'"+state.file_root+$
		    "'(v"+state.ifc.version+") input file on "+SysTime()
		  Xop_Input_Save,str_par,Group=event.top, $
		    Default=state.file_root+'.xop',Comment=comment
		  END
		ENDCASE
		END
	'QUIT': BEGIN
		if state.ifc.run NE '<none>' then begin
		  ;case sdep() of
		  ;  'WINDOWS': command='rm ' 
		  ;  'UNIX': command='/bin/rm -f '
		  ;  else: command=' '
		  ;endcase
		  ;command = command+state.ifc.rm
		  ;message,/info,'Executing: '+command
		  ;SPAWN,command
		  Delete_Files,state.ifc.rm,Group=event.top
		endif
		WIDGET_CONTROL,event.top,/DESTROY
		Return
		END
	'SETDEF': BEGIN
		itmp = Dialog_message(DIALOG_PARENT=event.top,$
		/Question,['This option initializes the',$
		state.ifc.title+' parameters to their default values.',$
		'Then you must click Set_parameters to run the program.',$
		'Do you really want that?'],title=state.ifc.title)
		if itmp eq 'No' then goto,out
		state.par=state.par_default
		END
	'SETPAR': BEGIN
		inp = state.par
		ds = SDep(/DS)
		helpcmd = "xdisplayfile1,'"+Xop_GetEnv('XOP_HOME')+ds+"doc"+ds+"txt"+$
		ds+state.ifc.application+"_par.txt'"
		IF Tag_Exist(state.ifc,'nrows') THEN $
		  nRows = state.ifc.nrows ELSE nRows=0
		IF Tag_Exist(state.ifc,'ncol') THEN $
		  nCol = state.ifc.ncol ELSE nCol=0
		Xscrmenu,inp,GROUP=group,ACTION=action,$
		  TITLES=state.ifc.titles, FLAGS=state.ifc.flags, $
		  /NOTYPE,/INTERP,WTITLE=state.ifc.title+' input parameters',$
		  Ncol=ncol,NRow=nrows,HELP=helpcmd

		IF (action EQ 'DONT') THEN GoTo,out
		widget_control,/hourglass

		if state.ifc.run NE '<none>' then begin
		  ;
		  ; write input file
		  ;
                  commands = xop_ifc_read(xop_ifcfile(state.file_root),$
		    'write_inp')
                  XOP_IFC_RUN,inp,commands
		  ;
		  ; executes program
		  ;
		  command = state.ifc.run
		  Xop_Spawn,command,Group=event.top, $
			SetWindowsHome=state.ifc.setWindowsHome
		endif
		state.par = inp
		END
        'HELP_XOP_IFC': Xhelp,'xop_ifc',GROUP=event.top
	else: BEGIN
		widget_control,event.id,get_uvalue=uvalue
		par = state.par
		ifc = state.ifc
                commands = xop_ifc_read(xop_ifcfile(state.file_root),uvalue)
	        XOP_IFC_RUN,par,commands,ifc
		END
  ENDCASE
out:
If Type(stateid) EQ 3 THEN $
  IF Widget_Info(stateid,/Valid_Id) EQ 1 THEN $
  Widget_Control, stateid, Set_Uvalue=state,/No_Copy
END
;
;==============================================================================
;
PRO XOP_IFC, file_root, GROUP=group, NO_BLOCK=no_block, $
  InputFile=inputFile

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,'XOP_IFC: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return
endif

IF N_Elements(no_block) EQ 0 THEN no_block=1

if n_params() EQ 0 then begin
  message,/info,'Usage: xop_ifc,ifc-file'
  return
endif

par_txt = xop_ifc_read(xop_ifcfile(file_root),'parameters')
ifc_txt = xop_ifc_read(xop_ifcfile(file_root),'interface')
if par_txt(0) EQ '' or ifc_txt(0) EQ '' then message,'Error from xop_ifcfile'
par =  make_str(par_txt)
ifc = make_str(ifc_txt)
tags = tag_names(par)

;
; Overwrite data with values from default files
; (same code as in xop_defaults.pro)
;

; from default directories
sep = sdep(/ds)
filedir = [Xop_GetEnv('XOP_HOME')+sep+'defaults']
filedir = [filedir]
IF Xop_GetEnv('XOP_DEFAULTS_DIR') NE '' THEN $
 filedir = [filedir,Xop_GetEnv('XOP_DEFAULTS_DIR')]
nfiles = n_elements(filedir)
if nfiles EQ 1 then filedir = [filedir]
tmp=0
for i=0,nfiles-1 do begin
  file = filedir[i]+sep+StrLowCase(file_root)+'.xop'
  tmp = checkfile(file)
  if tmp EQ 1 then begin
    str_par = Xop_Input_Load(inputFile=file)
    tmp = par
    Copy_Structure,str_par, tmp, Group=group
      par = tmp
    message,/info,'Defaults from file: '+file
  endif
endfor
par_default = par

; if inputFile selected
IF Keyword_Set(inputFile) THEN BEGIN
  str_par = Xop_Input_Load(InputFile=inputFile)
  IF Type(str_par) EQ 8 THEN BEGIN
    tmp = par
    Copy_Structure,str_par, tmp, Group=group
    par = tmp
  ENDIF
ENDIF

state = { par:par, par_default:par_default, ifc:ifc, file_root:file_root}
;
; create the base widget
;
wtmp=0L
wtmp0=0L
w=lonarr(100)
wbase=WIDGET_BASE(/COLUMN,TITLE=state.ifc.title+' '+state.ifc.version,$
  MBAR=wtmp)
w(0)=wtmp
wtmp = widget_base(wbase,/Column) ; also to store state
commands = xop_ifc_read(xop_ifcfile(file_root), 'menu')
for myindex=0,n_elements(commands)-1 do begin
  itmp=execute(commands(myindex))
  if itmp NE 1 then itmp=Dialog_message(/info,$
        'Error executing: '+commands(myindex))
endfor

Widget_control,Widget_Info(wbase,/CHILD),set_uvalue=state,/No_copy
Widget_control,wbase,/REALIZE
if keyword_set(no_block) then $
  XMANAGER,'xop_ifc',wbase,GROUP_LEADER=group,/no_block else $
  XMANAGER,'xop_ifc',wbase,GROUP_LEADER=group 
end
