
;
;
;



FUNCTION smoothkernel,m,z,seed=seed,normalized=normalized
;
;
; 
;
; seed: The kernel of zeroth iteration. Examples:
;       [-1,2,-1] second derivative (default)
;       [-1,1,0] first derivative
;       [0,1,0] nothing (identity operation)
;
; calculates the Mariscotti's kernel (See Fig 2.)
; m is related to the window width w=2*m+1
; z is the "iteration number"
;
; kall could be supressed

;
; If no smooth, returns the kernel for the secon derivative
;


;+
; NAME:
;	SMOOTHKERNEL
; PURPOSE:
;	This function returns a smooth kernel. A multiple smooth 
;       can be sone as a simple convolution with this kernel. 
; CATEGORY:
;	General
; CALLING SEQUENCE:
;	a= smoothKernel(m,z)
; INPUTS:
;	m: the number of neighbours in the smooth (smooth window=2*m+1) 
;          m is related to the window width: w=2*m+1
;	z: the number of smooth iterations
;
; KEYWORD PARAMETERS
;       seed: The kernel for the zeroth iteration. Examples:
;             [-1,2,-1] second derivative (default)
;             [-1,1,0] first derivative
;             [0,1,0] nothing (identity operation)
;	normalized: Used the normalization factor calculated
;		from the smooth window and iterations.
;
; OUTPUTS:
;	An array with the kernel.
;
; PROCEDURE:
;	The motivation of the use of convolution for multiple smoothing
;       has been taken from this reference:
;       1) M.A. Mariscotti, Nucl. Instrum. Meth. 50 (1967) 309-320
;
;
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble September 2007
;	07-06-12 srio@esrf.fr rewrites using histogram() Added METHOD
;		keyword.
;-

IF N_Elements(seed) EQ 0 THEN ki = [1,-2,1] ELSE ki=seed
IF N_Elements(ki) NE 3 THEN Message,'Staring seed-kernel must have dimension=3'

;
; not smooth
;
npoints=N_Elements(ki)
IF z EQ 0 THEN RETURN,ki
IF m EQ 0 THEN RETURN,ki

;
;
;
npoints = 2*(m*z+1)+1
k0 = lonarr(npoints)
kall = lonarr(z+1,npoints)

k0[m*z  ]=ki[0]
k0[m*z+1]=ki[1]
k0[m*z+2]=ki[2]
kall[0,*]=k0


;
; iterative part (Eq. 9 in Ref.1)
;
FOR zi=1,z DO BEGIN
  IF zi EQ 1 THEN kprevious=k0 ELSE kprevious=ki
  ki=k0*0
  FOR i=-m,m,1 DO BEGIN
    ki = ki + shift(kprevious,i)
  ENDFOR
  kall[zi,*]=ki
ENDFOR

IF Keyword_Set(normalized) THEN ki=ki*(1.0/(m*2+1))^z

RETURN,ki

END

