FUNCTION image_illusions, ii, size=s1, title=title
;+
; NAME:
;	IMAGE_ILLUSIONS
;
; PURPOSE:
;	This function returns an image with an optical illusion
;
; CATEGORY:
;	Fun.
;
; CALLING SEQUENCE:
;	result = imageillusions(index)
;
; INPUTS:
;	index:	 The index of the imageillusion (from 0 to 8)
;
; KEYWORD PARAMETERS:
;
; INPUTS: 
;	SIZE:	The size of the image in pixels (recommended > 600). 
;               The image is a square. 
;
; OUTPUTS:
;	title: a title with the optical illusion message
;
; REFERENCE:
;      Some ideas are taken from the book:
;      Daniel Picon, Illusions d'Optique, Mango Jeunesse, 2004       
;      ISBN 2-7404-1845-0
;     
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio, srio@esrf.fr
;	27 June 2008  
;-


IF N_Elements(s1) EQ 0 THEN s1=2048L
a=fltarr(s1,s1)

IF N_Elements(ii) EQ 0 THEN ii = 8

CASE ii OF
  ;
  ; gradient illusion
  ;
  0: BEGIN
     title='Gradient illusion (central rectangle is not graded!)'
     x = (findgen(s1)) # Replicate(1.0,s1)
     x[ s1/10:9*s1/10, 4*s1/10:6*s1/10] = max(x)/2
     a=x
     END
     ;
     ; dark spots
     ;
  1: BEGIN
     title='dark sopts: look at one spot and the others blink to black'
     x = (findgen(s1)) # Replicate(1.0,s1)
     y = Replicate(1.0,s1) # (findgen(s1))
     a = x*0
     thick = s1/50
     period = s1/4
     a[where(x mod period LE thick)] = 10000
     a[where(y mod period LE thick)] = 10000
     n = s1/period
     FOR i=0L,n DO BEGIN
       FOR j=0L,n DO BEGIN
         pX = i*period+thick/2
         pY = j*period+thick/2
         dd = sqrt( (x-pX)^2 + (y-pY)^2)
         a[where(dd LE thick)]=20000
       ENDFOR
     ENDFOR
       
     END
  2: BEGIN  ; circle illusion
     title='Circle illusion (both central circles are identical)'
     x = (findgen(s1)) # Replicate(1.0,s1)
     y = Replicate(1.0,s1) # (findgen(s1))
     a = x*0

     peakX = 0.3*s1 & peakY = 0.5*s1 & radius = 0.03*s1
     dd = sqrt( (x-peakX)^2 + (y-peakY)^2)
     a[where(dd LE radius)]=1000
     n = 6
     FOR i=0,n-1 DO BEGIN
       ii = float(i)
       px = peakX+5.0*radius*cos(ii/n*2*!pi)
       py = peakY+5.0*radius*sin(ii/n*2*!pi)
       dd = sqrt( (x-pX)^2 + (y-pY)^2)
       a[where(dd LE radius*2)]=1000
     ENDFOR

     peakX = 0.75*s1 & peakY = 0.5*s1 
     dd = sqrt( (x-peakX)^2 + (y-peakY)^2)
     a[where(dd LE radius)]=1000
     FOR i=0,n-1 DO BEGIN
       ii = float(i)
       px = peakX+3.0*radius*cos(ii/n*2*!pi)
       py = peakY+3.0*radius*sin(ii/n*2*!pi)
       dd = sqrt( (x-pX)^2 + (y-pY)^2)
       a[where(dd LE radius/2)]=1000
     ENDFOR
     END

  3: BEGIN
     title='Crazy lines: All horizontal are straight parallel lines'
     x = (findgen(s1)) # Replicate(1.0,s1)
     y = Replicate(1.0,s1) # (findgen(s1))
     a = x*0+1000
     ;thick = 30
     ;period = 400
     thick = 10
     period = 200.0
     thick = s1/205
     period = s1/11
     ;;a[where(x mod period LE thick)] = 10000
     ;a[where(y mod period LE thick)] = 100
     semiperiod=period/2
     n = s1/semiperiod
     FOR i=1L,n,2 DO BEGIN
       FOR j=0L,n,2 DO BEGIN
         ss = 1.3*semiperiod*sin(2.0*!pi*j/n+!pi/3)
         pX = i*period ; +thick/2
         pY = j*semiperiod+thick ; +thick/2
         a[ (px+ss-semiperiod)>0<(s1-1):(px+ss+semiperiod)>0<(s1-1), $
            (py-semiperiod)>0<(s1-1):(py+semiperiod)>0<(s1-1) ] =200
         a[ (px+ss-0.85*semiperiod)>0<(s1-1):(px+ss+0.85*semiperiod)>0<(s1-1), $
            (py-0.95*semiperiod)>0<(s1-1):(py+0.95*semiperiod)>0<(s1-1) ] =0
         a[ *, $
            (py-1.05*semiperiod)>0<(s1-1):(py-0.95*semiperiod)>0<(s1-1) ] =200
       ENDFOR
     ENDFOR
     END
       

  4: BEGIN  
     title='Are the straight-lines lengths different? No'
     x = (findgen(s1)) # Replicate(1.0,s1)
     y = Replicate(1.0,s1) # (findgen(s1))
     a = x*0

     
     diameter = 0.2*s1
     thick = s1/205
     x1 = s1/2.-diameter
     x2 = s1/2.+diameter
     a[x1:x2,3./4*s1-(thick/2):3./4*s1+(thick/2)]=-100
     a[x1:x2,1./4*s1-(thick/2):1./4*s1+(thick/2)]=-100

     xC = [x1-diameter/2,x2+diameter/2,x1+diameter/2,x2-diameter/2]
     yC = [3.,3.,1.,1.]/4*s1
     FOR j=0,N_Elements(xC)-1 DO BEGIN
       FOR i=0,360 DO BEGIN
         ii = xC[j]+(diameter/2)*sin(i*!pi/180)
         jj = yC[j]+(diameter/2)*cos(i*!pi/180)
         a[ii-(thick/2):ii+(thick/2),jj-(thick/2):jj+(thick/2)]=100
       ENDFOR
     ENDFOR
     END

  5: BEGIN  ; filled squares
     title='Are the squares different? No'
     x = (findgen(s1)) # Replicate(1.0,s1)
     y = Replicate(1.0,s1) # (findgen(s1))
     a = x*0

     ll = s1*0.17 ; semilengh of the square
     xx1 = s1*(3./4)+[-ll,ll,ll,-ll]
     yy1 = s1*(1./2)+[ll,ll,-ll,-ll]
     itmp = polyfillv(xx1,yy1,s1,s1)
     a[itmp]=-100
     xx1 = s1*(1./4)+[0,sqrt(2),0,-sqrt(2)]*ll
     yy1 = s1*(1./2)+[sqrt(2),0,-sqrt(2),0]*ll
     itmp = polyfillv(xx1,yy1,s1,s1)
     a[itmp]=-100
     a[*,0:s1/5]=1000
     a[*,s1*(1.0-1./5):(s1-1)]=1000
     END

  6: BEGIN  ; Hering's illusion
     x = (findgen(s1)) # Replicate(1.0,s1)
     y = Replicate(1.0,s1) # (findgen(s1))
     a = x*0

     xC = s1/2
     yC = s1/2
     thick = 10
     n = 20
     epsilon = 0.4/180*!pi
     radius = s1*0.4
     FOR i=0,n-1 DO BEGIN
       ii = float(i)
       px1 = xC+radius*cos(ii/n*!pi-epsilon)
       py1 = yC+radius*sin(ii/n*!pi-epsilon)
       px2 = xC+radius*cos(ii/n*!pi+epsilon)
       py2 = xC+radius*sin(ii/n*!pi+epsilon)
       px3 = xC+radius*cos(ii/n*!pi+!pi-epsilon)
       py3 = xC+radius*sin(ii/n*!pi+!pi-epsilon)
       px4 = xC+radius*cos(ii/n*!pi+!pi+epsilon)
       py4 = xC+radius*sin(ii/n*!pi+!pi+epsilon)

       itmp = polyfillv([px1,px2,px3,px4],[py1,py2,py3,py4],s1,s1)
       a[itmp]=1000
     ENDFOR

     a[s1*(1./8):s1*(7./8),s1*(3./8)-thick:s1*(3./8)+thick]=-100
     a[s1*(1./8):s1*(7./8),s1*(5./8)-thick:s1*(5./8)+thick]=-100

     END

  7: BEGIN  ; circle illusion
     title='Which semicircle is larger? They are the equal.'
     x = (findgen(s1)) # Replicate(1.0,s1)
     y = Replicate(1.0,s1) # (findgen(s1))
     a = x*0

     radius = s1*0.4
     n = 181
     xx1 = fltarr(n)
     yy1 = fltarr(n)
     xx2 = fltarr(n)
     yy2 = fltarr(n)

     FOR i=0,n-1 DO BEGIN
       ii = float(i)
       px = radius*cos(ii*!pi/180)
       py = -radius*sin(ii*!pi/180)
       xx1[i] = s1/2 + px
       yy1[i] = s1 + py
       xx2[i] = s1/2 + px
       yy2[i] = s1/2 + py
     ENDFOR
     itmp = polyfillv(xx1,yy1,s1,s1)
     a[itmp]=1000
     itmp = polyfillv(xx2,yy2,s1,s1)
     a[itmp]=-100

     END


  8: BEGIN  
     title='Are the square and circle deformed?'

     x = (findgen(s1)) # Replicate(1.0,s1)
     y = Replicate(1.0,s1) # (findgen(s1))
     a = x*0

     a[s1*(1./8):s1*3./8,s1*3./8:s1*5./8]=-100
     xx1 = fltarr(361)
     yy1 = fltarr(361)
     FOR i=0,360 DO BEGIN
       xx1[i] = s1*(6./8)+s1*(1./8)*cos(i*!pi/180)
       yy1[i] = s1*(4./8)+s1*(1./8)*sin(i*!pi/180)
     ENDFOR
     itmp = polyfillv(xx1,yy1,s1,s1)
     a[itmp]=-200


     xC = s1/2
     yC = s1/2
     thick = s1/205
     n = 20
     epsilon = 0.4/180*!pi
     radius = s1*0.48
     FOR i=0,n-1 DO BEGIN
       ii = float(i)
       px1 = xC+radius*cos(ii/n*!pi-epsilon)
       py1 = yC+radius*sin(ii/n*!pi-epsilon)
       px2 = xC+radius*cos(ii/n*!pi+epsilon)
       py2 = xC+radius*sin(ii/n*!pi+epsilon)
       px3 = xC+radius*cos(ii/n*!pi+!pi-epsilon)
       py3 = xC+radius*sin(ii/n*!pi+!pi-epsilon)
       px4 = xC+radius*cos(ii/n*!pi+!pi+epsilon)
       py4 = xC+radius*sin(ii/n*!pi+!pi+epsilon)

       itmp = polyfillv([px1,px2,px3,px4],[py1,py2,py3,py4],s1,s1)
       a[itmp]=1000
     ENDFOR
     END
  else:
ENDCASE


return,a

END
