PRO gleplot,v0,vH,H,axisH=axisH,axisV=axisV,spawn=dospawn,fileroot=fileroot

; 
; European Synchrotron Radiation Facility (ESRF)
;+
; NAME:
;       GLEPLOT
;
; PURPOSE:
;	creates a graphical file for gle http://glx.sourceforge.net/
;     
; CATEGORY:
;       X-Ray optics.
;
; CALLING SEQUENCE:
;	gleplot,v0,vH,H,axisH=axisH,axisV=axisV,spawn=dospawn,fileroot=fileroot
; OPTIONAL INPUTS:
;	v0,vH,H: vectors: incident, diffracted directions and reciprocal lattice
;	
; KEYWORDS: 
;	axisH = axis number to be displayed in horizontal  (default=2)
;	axisV = axis number to be displayed in horizontal  (default=1)
;       spawn = set to 1 to spawn "gle" and "okular"
;       fileroot = A string with the fileroot (.gle added) (default=bentcrystal)
;
; OUTPUT:
;	a file
;
; MODIFICATION HISTORY:
;       2013 srio@esrf.eu, written
;
;-

on_error,2

if n_elements(axisH) eq 0 then axisH = 2 ; Xianbo
if n_elements(axisV) eq 0 then axisV = 1 ; Xianbo
if n_elements(dospawn) eq 0 then dospawn = 0
if n_elements(fileroot) eq 0 then fileroot = "bentcrystal"
if n_elements(v0) eq 0 then v0=[0.5,0.5,0]
if n_elements(vh) eq 0 then vh=[-0.5,-0.5,0]
if n_elements(h) eq 0 then h=[-0.25,-0.25,0]


myv0 =  [ v0[axisH-1],v0[axisV-1] ]
myvh =  [ vH[axisH-1],vH[axisV-1] ]
myH =   [ H[axisH-1],H[axisV-1] ]

print,'my v0: ',myv0
print,'my vH: ',myvH
print,'my H: ',myH
print,'my axisH: ',axisH
print,'my axisV: ',axisV


openw,unit,fileroot+".gle",/get_lun
printf,unit, '!'
printf,unit, '! gle code for creating crystal diagram'
printf,unit, '!'
printf,unit, '! written by ...'
printf,unit, ''
printf,unit, 'v0_h = ',myv0[0]
printf,unit, 'v0_v = ',myv0[1]
printf,unit, 'vH_h = ',myvh[0]
printf,unit, 'vH_v = ',myvh[1]
printf,unit, 'H_h = ',myH[0]
printf,unit, 'H_v = ',myH[1]
printf,unit, 'H$ = "$x_'+strcompress(axisH,/remove_all)+'$"'
printf,unit, 'V$ = "$x_'+strcompress(axisV,/remove_all)+'$"'
printf,unit, 'hshift = 0.2'
printf,unit, 'vshift = 0.0'
printf,unit, ''
printf,unit, 'size 3 3'
printf,unit, ''
printf,unit, '! draw axes'
printf,unit, 'set color black'
printf,unit, 'set lwidth 0.01'
printf,unit, 'amove 1 1'
printf,unit, 'rline 0 2 arrow end'
printf,unit, 'tex V$'
printf,unit, 'amove 1 1'
printf,unit, 'rline 2 0 arrow end'
printf,unit, 'tex H$'
printf,unit, 'set lwidth 0'
printf,unit, ''
printf,unit, ''
printf,unit, '! draw vectors'
printf,unit, 'set color red'
printf,unit, 'amove v0_h*(-1)+1  v0_v*(-1)+1'
printf,unit, 'tex "$\vec{k_0}$"'
printf,unit, 'rline v0_h v0_v arrow end '
printf,unit, 'rmove hshift vshift'
printf,unit, ''
printf,unit, 'amove 1 1 '
printf,unit, 'rline vH_h vH_v  arrow end'
printf,unit, 'rmove hshift vshift'
printf,unit, 'tex "$\vec{k_H}$"'
printf,unit, ''
printf,unit, 'set color blue'
printf,unit, 'amove 1 1 '
printf,unit, 'rline H_h H_v arrow end'
printf,unit, 'rmove hshift vshift'
printf,unit, 'tex "$\vec{H}$"'
printf,unit, ''
printf,unit, 'set color green'
printf,unit, 'amove 1 1 '
printf,unit, 'rline -H_v*1.5 H_h*1.5 '
printf,unit, 'amove 1 1 '
printf,unit, 'rline  H_v*1.5 -H_h*1.5 '
printf,unit, ''
printf,unit, '!draw crystal'
printf,unit, 'set color black'
printf,unit, 'amove 2 1'
printf,unit, 'box -2 -0.1'
printf,unit, ''
free_lun,unit
print,"File written to disk: ",fileroot+".gle"

if dospawn eq 1 then begin
  spawn,'gle '+fileroot+".gle"
  spawn,'okular '+fileroot+".eps"
endif
end
