;+
;
;
;	NAME:
;		Xlegend
;	PURPOSE:
;		to create labels by using LEGEND1 from 
;		 F K Knight (knight@ll.mit.edu)
;	CALLING SEQUENCE:
;		Xlegend 
;	OPTIONAL INPUT PARAMETERS:
;	KEYWORD PARAMETERS:
;		GROUP = The widget ID of the widget that calls Xplot.
;		When this ID is specified, a death of the caller results 
;		in a death of Xplot.
;		WINDOW = The id of the window where the labels have to
;		be placed.
;		COMMAND = returning variable (string) containing the 
;		  saved LEGEND1 command.
;	OUTPUTS:
;		Writes saved command in the COMMAND keyword
;	COMMON BLOCKS:
;		None
;	SIDE EFFECTS:
;	RESTRICTIONS:
;	PROCEDURE:
;		Uses the LEGEND1 routine for producing legends.
;	EXAMPLE:
;		plot,[1,4,1,4]   ;plot again
;		Xlegend,command=command
;		; make and save a legend		
;		;to reproduce the plot with legend do:
;		   plot,[1,4,1,4]   ;plot again
;		   tmp = execute(command)
;
;	MODIFICATION HISTORY:
;       by  Manuel Sanchez del Rio. ESRF. September 1995
;
;
;-
;
;=========================================================================
;
pro xlegend_event,event

widget_control,event.top,GET_UVALUE=state
widget_control,event.id,GET_UVALUE=uval

wset,state.Window

IF keyword_set(uval) then BEGIN
  case uval of
    'Quit': begin
      widget_control,/HOURGLASS
      tv,state.tvrd
      widget_control,state.wBaseBuffer,set_uvalue=''
      widget_control,event.top,/DESTROY
      return
      end
    'SoftQuit': begin
      ;widget_control,/HOURGLASS
      ;tv,state.tvrd
      widget_control,state.wCommand,get_value=command
      widget_control,state.wBaseBuffer,set_uvalue=command
      widget_control,event.top,/DESTROY
      return
      end
    'Help': begin
      widget_control,/HOURGLASS
      doc_library,'legend1', PRINT='cat > legend1.hlp'
      XDISPLAYFILE1,'legend1.hlp',GROUP=event.top, $
	 HEIGHT = 48, /REMOVE
      end
    'Command': begin
	widget_control,state.wCommand,get_value=command
        print,command
	widget_control,/HOURGLASS
        tv,state.tvrd
	tmp = execute(command(0))
      end
    'Examples': begin
	command = state.Examples(event.index)
        print,command
	if Command NE 'None' then begin
	  widget_control,/HOURGLASS
	  widget_control,state.wCommand,set_value = Command
          tv,state.tvrd
	  tmp = execute(command(0))
	endif else begin
	  widget_control,/HOURGLASS
	  widget_control,state.wCommand,set_value = ''
          tv,state.tvrd
        endelse
      end
    else:
  endcase
ENDIF

out:
widget_control,event.top,SET_UVALUE=state,/NO_COPY

end
;
;======================================================================
;
pro xlegend,COMMAND=command, GROUP=group,WINDOW=window
;
on_error,2

wBaseBuffer = Widget_base() ; to store the command to be returned

wWin = Widget_base(TITLE='Xlegend')
wBase = Widget_Base(wWin,/Column)

wBase0 = Widget_Base(wBase,/Row)
wQuit = widget_Button(wBase0,VALUE='Quit and discard LEGEND1',UVALUE='Quit')
wQuit = widget_Button(wBase0,VALUE='Quit and keep LEGEND1',UVALUE='SoftQuit')
wHelp = widget_Button(wBase0,VALUE='Help Legend1',UVALUE='Help')

wDoc = widget_text(wBase,XSIZE=80,YSIZE=4,VALUE= $
  ['This option permits to write legends on IDL plots.',$
   ' ',$
   'It uses the LEGEND1 procedure of  F K Knight (knight@ll.mit.edu).',$
   ' ',$
   'You must create the LEGEND1 call, and the example options can help'+$
   'you in this job.'])
wtmp = widget_label(wBase,VALUE='Legend1 command:',/ALIGN_LEFT)
wCommand = widget_text(wBase,VALUE='',/ALIGN_LEFT,/EDIT,XSIZE=120, $
   UVALUE='Command')

wtmp = widget_label(wBase,VALUE='Legend1 examples:',/ALIGN_LEFT)

Examples = ['None', $
  "legend1,['Plus sign','Asterisk','Period'],psym=[1,2,3]", $
  "legend1,['diamond','asterisk','square'],psym=[4,2,6]", $
  "legend1,['solid','dotted','DASHED'],linestyle=[0,1,2]", $
  "legend1,['diamond','asterisk','square'],psym=[4,2,6],/horiz,chars=1.5", $
  "legend1,['1','2','3','4','5','6'],psym=[4,2,6,0,0,0],linestyle=[0,0,0,0,1,2],box=0", $
  "legend1,['diamond','asterisk','square'],psym=[4,2,6],margin=1,spacing=2,char=2,delimiter='='", $
  "legend1,['solid','dotted','DASHED'],linestyle=[0,1,2],pos=[.3,.5],char=3,number=4", $
  "legend1,['diamond','asterisk','square'],psym=-[4,2,6],number=2,linestyle=[0,1,2]", $
   "legend1,['c1','c2','c3','c4','c5','c6'],/fill,psym=[8,8,8,8,8,8],colors=[10,30,50,70,90,110],char=2", $
   "legend1,['c1','c2','c3','a1','a2','a3'],/fill,psym=[8,8,8,0,0,0],line=[0,0,0,0,1,2],colors=[10,30,50,70,90,110],char=2", $
   "legend1,['A','B','C','D'],vector=['ab!9r!3','!9nu!3','!9Wf!3','!9cN!20K!3'],charsize=2,pos=[.1,.5],psp=3"]
   



  
wExamples = widget_droplist(wBase, VALUE= Examples,UVALUE='Examples')




tmp = size(Window)
if tmp(1) EQ 0 then Window=!d.Window
if Window LT 0 then begin
  tmp = widget_message('Display not set',/ERROR)
  return
endif

widget_control,/HOURGLASS
state = { wCommand:wCommand, Window:Window, tvrd:tvrd(), $
  wExamples:wExamples, Examples:Examples, $
  wBaseBuffer:wBaseBuffer}

widget_control,wWin,/REALIZE,SET_UVALUE=state,/NO_COPY
xmanager, 'xlegend', wWin, GROUP_LEADER=group,/MODAL

widget_control,wBaseBuffer,get_uvalue=command
print,command
command = command(0)

end



