PRO Xop_Input_Save,str_par,_Extra=extra,Group=group,Comment=comment,$
  Default=default,tags=tags, noFlagsTitles=noFlagsTitles

;+
; NAME:
;       XOP_INPUT_SAVE
;
; PURPOSE:
;       This procedure writes in a file the XOP application's parameters
;	stored in an IDL structure.
;
; CATEGORY:
;       XOP
;
; CALLING SEQUENCE:
;       Xop_Input_Save,str
;
; INPUTS:
;	str: the IDL structure with the XOP's application parameters.
;       
; KEYWORD PARAMETERS:
;       GROUP:  The widget ID of the group leader of the widget.  If this
;               keyword is specified, the death of the group leader results i n
;               the death of widgets created by XOP_WD.
;	Comment: a string array containg comments to be added to the 
;		file. 
;	_Extra: any other keyword to be passed to Dialog_PickFile
;		(If inputFile is not selected, starts the file browser).
;	Default: a string with the default file name to be displayed in
;		the file browser.
;	TAGS: Set this keyword to indicate that the output file contains
;		tags, for allowing files with multiple structures. 
;	NoFlagsTitles: Set this keyword to avoid writing tags ended
;		in *_Flags or *_Titles, used in XOP for menu-labels
;
; OUTPUTS:
;       
;
; SIDE EFFECTS:
;	Write a file.
;
; PROCEDURE:
;       Uses the syntaxis defined in Make_Str and Write_Str functions.
;
; USE:
;       This procedure is to be used by any XOP application to write a
;	  file to store the input parameters. The first line, included
;	  in the comment, contains the application name and version.
;
; EXAMPLE:
;       str = (xop_defaults('xwiggler')).parameters
;	Xop_Input_Save,str_par,File='xwiggler.xop',$
;          /Write, Comment='; xop/xwiggler(v2.3) input file on '+SysTime()
;
;
; MODIFICATION HISTORY:
;       Written by:     Manuel Sanchez del Rio (srio@esrf.fr) 98/11/05
;	99-01-11 srio@esrf.fr better error managing.
;	2007-03-08 srio@esrf.fr added TAGS keyword.
;	2007-12-17 srio@esrf.eu fixes small bug 
;-
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/W) THEN itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'XOP_INPUT_SAVE: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return
endif

back:

IF NOT(Keyword_Set(default)) THEN BEGIN
  ffile = Dialog_Pickfile(Group=group,_Extra=extra)
  if strcompress(ffile,/rem) EQ '' then Return
  IF CheckFile(ffile) THEN BEGIN
    itmp = Dialog_Message(Dialog_parent=group,/Question,/Cancel,$
      ['File '+ffile+' exists.','Overwrite it?'])
    IF itmp EQ 'Cancel' THEN RETURN
    IF itmp EQ 'No' THEN GoTo,back
  ENDIF
ENDIF ELSE BEGIN
  dire = Xop_GetEnv('XOP_DEFAULTS_DIR')
  IF StrCompress(dire,/Rem) EQ '' THEN  BEGIN
    itmp = Dialog_message(/Error,Dialog_Parent=group,$
	['XOP_INPUT_SAVE: Failed to find user directory to save defaults',$
	 'It must be defined in the XOP_DEFAULTS_DIR environment variable'])
    RETURN
  ENDIF
  sd = SDep(/DS)
  ffile = dire + sd+default
  ierr=0
  Catch,/Cancel
  OpenW,unit,ffile,/Delete,/Get_Lun,Error=ierr
  IF ierr NE 0 THEN BEGIN
    itmp = Dialog_message(/Error,Dialog_Parent=group,$
	['XOP_INPUT_SAVE: Failed to open file: ',$
	 '  '+ffile,$
	 ' ','Please check that:',$
	 '      1) the directory "'+dire+'" exists.',$
	 '      2) you have write permission to write on it.'])
    RETURN
  ENDIF
  Catch, error_status
  Free_Lun,unit
ENDELSE

IF Keyword_Set(tags) THEN BEGIN
  openw,unit,ffile,/get_lun
  IF Keyword_Set(comment) THEN printf,unit,comment

  names = tag_names(str_par)
  FOR i=0,N_TAGS(str_par)-1 DO BEGIN
     tmp = str_par.(i)
     iwrite = 1
     IF Keyword_Set(NOFLAGSTITLES) THEN BEGIN
       IF StrMatch(names[i],'*_TITLES') THEN iwrite=0
       IF StrMatch(names[i],'*_FLAGS') THEN iwrite=0
     ENDIF
     IF iwrite THEN BEGIN
       CASE type(tmp) OF
         type({a:0}): BEGIN
	    printf,unit,'<startstr>'+names[i]
	    txt1 = write_str(tmp)
	    FOR ii=0L,N_Elements(txt1)-1 DO printf,unit,txt1[ii]
	    printf,unit,'<endstr>'+names[i]
	    END
         type(''): BEGIN
	    printf,unit,'<starttext>'+names[i]
	    FOR j=0L,N_Elements(tmp)-1 DO printf,unit,tmp[j]
	    printf,unit,'<endtext>'+names[i]
	      END
         ELSE:
       ENDCASE
     ENDIF
  ENDFOR
  free_lun,unit
ENDIF ELSE BEGIN
  tmp=Write_Str(str_par,File=ffile,Group=group,Comment=comment)
ENDELSE

;IF Type(tmp) NE 7 THEN Message,'Error from WRITE_STR'

IF KeyWord_Set(defaults) THEN BEGIN
  text=['Application input saved to file (in defaults directory):',ffile,'',$
   '(This file can be edited or shortened. The customizable numerical',$
   ' values are in the third column. Do not change variable names.)']
ENDIF ELSE BEGIN
  text=['Application input saved to file:',ffile,'',$
   '(This file can be edited or shortened. The customizable numerical',$
   ' values are in the third column. Do not change variable names.)']
ENDELSE

itmp = Dialog_Message(/Info,Dialog_parent=group,text)

END
