;+
; 
; NAME: 
;	XMLEXCEL_WORKBOOK,Unit,Open=Open,Close=Close
;	XMLEXCEL_WORKSHEET,Unit,Open=Open,Close=Close,Name=name
;	XMLEXCEL_PUTLINE,Unit,line
;
; PURPOSE:
;	Creates XML-EXCEL files that can be loaded in Microsoft Excel
;
; CATEGORY:
;	Util
;
; CALLING SEQUENCE:
;	See Example
;
; INPUTS:
;     Unit: The file logical unit
;     line: an array (string or numeric) with the elements of a line.
;
; KEYWORD PARAMETERS:
;     Open: Set this keyword to open the corresponding workbook/worksheet
;     Close: Set this keyword to close the corresponding workbook/worksheet
;     Name: name of the worksheet
;     _Extra: other keywords to be passed from XMLEXCELL_PUTLINE to STRING()
;
; OUTPUTS:
;	It writes into an open file 
;
;
; PROCEDURE:
;	See http://blogs.msdn.com/brian_jones/archive/2005/06/27/433152.aspx
;
; EXAMPLE:
;
;	openw,unit,'test.xls',/get_lun
;	  xmlexcel_workbook,unit,/open
;	    xmlexcel_worksheet,unit,/open
;	      xmlexcel_putline,unit,['X','Y']
;	      xmlexcel_putline,unit,[1,4.5]
;	      xmlexcel_putline,unit,[2,3.2]
;	    xmlexcel_worksheet,unit,/close
;	  xmlexcel_workbook,unit,/close
;	free_lun,unit
;
; MODIFICATION HISTORY:
;	Written By Manuel Sanchez del Rio (srio@esrf.fr), April 2006
;	2006-04-13 srio@esrf.fr documented
;
;-
;
;----------------------------------------------------------------------------
;
PRO xmlexcel_worksheet,unit,open=open,close=close,name=name
IF N_Elements(name) EQ 0 THEN name='Sheet'
b2o=[$
    '    <ss:Worksheet ss:Name="'+name+'">',$
    '        <ss:Table>',$
    '            <ss:Column ss:Width="80"/>']
b2c=[$
        '    </ss:Table>',$
        '</ss:Worksheet>']
IF Keyword_Set(open) THEN printf,unit,b2o ELSE printf,unit,b2c
END
;
;----------------------------------------------------------------------------
;
PRO xmlexcel_putline,unit,line,_Extra=extra
tline = type(line)
IF tline EQ 7 THEN itype='String' ELSE itype='Number'
	printf,unit,['            <ss:Row>']
	FOR i=0,N_Elements(line)-1 DO BEGIN
	item = line[i]
	IF tline NE 7 THEN item=StrCompress(item,/Rem)
	printf,unit,[$
    '                <ss:Cell>',$
    '                    <ss:Data ss:Type="'+itype+'">'+$
	String(item,_Extra=extra)+'</ss:Data>',$
	;item+'</ss:Data>',$
    '                </ss:Cell>']
	ENDFOR
    	printf,unit,'            </ss:Row>'
END

;
;----------------------------------------------------------------------------
;
PRO xmlexcel_workbook,unit,open=open,close=close
b1o=[$
    '<?xml version="1.0"?>',$
    '<ss:Workbook xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">']
b1c=[$
    '</ss:Workbook>']
IF Keyword_Set(open) THEN printf,unit,b1o ELSE printf,unit,b1c
END
