PRO plothisto,x1,y1,y2,fill=fill,extend=extend,swap=swap, $
    xrange=xrange,yrange=yrange,xlog=xlog,ylog=ylog, $
    over=over, nEvents=nEvents, _Extra=extra

forward_function histoerror
;+
; NAME:
;	PLOTHISTO
; PURPOSE:
;	Plots a histogram. It receives the histogram as calculated by
;	histogram(), where the abscissas indicate the left corner of
;	each bin. Note that PLOT,PSYM=10 makes a similar plot, but 
;	considering the abscissas as the center of the bins, which 
;	is incompatible with the results of histogram().
; CATEGORY:
;	General
; CALLING SEQUENCE:
;	plothisto,x,y,[y2]
; INPUTS:
;	x,y the abscissas and ordinates arrays
;	y2 (optional) the squared function values used for computing
;          error bars (graph displays +/- one-sigma)
; KEYWORD PARAMETERS:
;	FILL : Set this keyword to fill the histogram
;	EXTEND : Set this keyword to plot also the last bin 
;		(default=1)
;	SWAP: Set this keyword to swap X and Y axes
;	XRANGE: The abscissas range (as in plot)
;	YRANGE: The ordinates range (as in plot)
;	XLOG: Set this keyword for log scale in X
;	YLOG: Set this keyword for log scale in Y
;	OVER: Set this keyword for overplotting the
;	      currento plot.
;	N_EVENTS: the number of events used for calculating the histogram.
;                (only used if y2 is set). If undefined, it uses total(y)
;	_Extra: Any other keyword is passed to plot,..
;
;	
;	EXAMPLES
;	Create a random set in [0,1)
;	r = randomu (seed, 1000)
;
;	Make histogram: 
;	y = histogram(r, min=0, binsize=0.2, location=x)
;	IDL> print,x,y
;	      0.00000     0.200000     0.400000     0.600000     0.800000
;	         204         207         171         214         204
;	
;	Note that the last point indicate 204 events in [0.8,1)
;	
;	Therefore, plot,x,y,PSYM=10 makes a wrong plot!!!
;
;	The correct plot is:
;	
;	plothisto,x,y
;	
;	Note also that we have entered the MIN and BINSIZE keywords as they
;	are the primary parameters used for HISTOGRAM() calculation (see doc).
;	
;	The same histogram should be obtained using: 
;	
;
;	y = histogram(r, min=0, max=1, nbins =6, loc = x)
;	IDL> print,x,y
;	   0.00000  0.200000  0.400000  0.600000  0.800000  1.00000
;	   204      207       171       214       204       0
;
;	Where nbins is the number of bins plus one (see the wrong definition
;	in the doc of HISTOGRAM (as in IDL 6.3)). The last point means the 
;	number of events in [1,1.2) and, of course, is zero. If you plot 
;	"plot,x,y,PSYM=10" you will see another aberration. On the contrary, 
;	"plothisto,x,y" gives the correct answer.
;
;
; REFERENCE
;	
;	See also the discussion in: 
; http://groups.google.com/group/comp.lang.idl-pvwave/browse_frm/thread/f870a6ddeca7aa11/6d29f66a2459b47f?lnk=st&q=&rnum=2#6d29f66a2459b47f
;
;
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble June 2007
;	2007-09-28 Bug fixed: changed from Flt to Dbl the histogram arrays
;	2011-04-13 srio@esrf.eu adds error bars. 
;
;
;-


on_error,2

;- Create plot arrays


x = Reform(x1)
y = Reform(y1)

; chech is array with squares is defined to calculate errors
IF N_Elements(y2) GT 0 THEN flag_sigmas=1 ELSE flag_sigmas=0
IF flag_sigmas THEN BEGIN
  ysigma=histoerror(y,y2,nEvents)
  ;ysigma=histoerror(y)
  ;ysquare = Reform(y2)
  ;IF N_Elements(nEvents) EQ 0 THEN nEvents=Total(y)
  ;ysigma = (ySquare/nEvents) - (y/nEvents)^2 
  ;ysigma = sqrt(ysigma/nEvents)
  ;ysigma = nEvents*ysigma ; this is  because in Shadow histograms are not normalized.
ENDIF

nx = N_Elements(x)
ny = N_Elements(y)

IF nx LT 2 THEN Message,'Error: Needed at least two points.'

;IF y[ny-1] NE 0 THEN extend = 1 ELSE extend=0
IF N_Elements(extend) EQ 0 THEN extend = 1 ; add always last bin

IF extend THEN BEGIN
  yy = [y,0]
  xx = [x,x[nx-1]+(x[1]-x[0])]
  IF flag_sigmas THEN ysigma = [ysigma,0]
ENDIF ELSE BEGIN
  xx = x
  yy = y
ENDELSE

;print,'hplot: ',xx,yy


nx = N_Elements(xx)
ny = N_Elements(yy)

hx = DblArr(2 * nx)
hx[2 * lindgen(nx)] = xx
hx[2 * lindgen(nx) + 1] = xx
hy = DblArr(2 * ny)
hy[2 * lindgen(ny)] = yy
hy[2 * lindgen(ny) + 1] = yy
hy = shift(hy, 1)

; remove first and last points 
;help,hx,hy
hx = hx[1:N_Elements(hx)-2]
hy = hy[1:N_Elements(hy)-2]


;- Plot the histogram
;print,'plotting: ',hx,hy

IF Keyword_Set(swap) THEN BEGIN
  IF Keyword_Set(over) THEN BEGIN
     oplot, hy, hx, _extra=extra
  ENDIF ELSE BEGIN
     plot, hy, hx, xrange=yrange, yrange=xrange, xlog=ylog, ylog=xlog, _extra=extra
  ENDELSE
  if keyword_set(fill) then polyfill, [hy, hy[0]], [hx, hx[0]] 
ENDIF ELSE BEGIN
  IF Keyword_Set(over) THEN BEGIN
    oplot, hx, hy, _extra=extra
  ENDIF ELSE BEGIN
    plot, hx, hy, xrange=xrange, yrange=yrange, xlog=xlog, ylog=ylog, _extra=extra
    IF flag_sigmas THEN BEGIN
     halfstep=(x1[1]-x1[0])/2.0
     errplot,x1+halfstep,y1+(ysigma),y1-(ysigma)
     icenter = n_elements(y1)/2
     print,'% PLOTHISTO: center bin: y,sigma,%error',y1[icenter],ysigma[icenter],100*ysigma[icenter]/y1[icenter]
     ;for i=0,n_elements(y1)-1 do begin
     ;  print,x1[i]+halfstep,y1[i],ysigma[i],sqrt(y1[i]-((y1[i])^2)/nEvents)/nEvents
     ;endfor
    ENDIF
  ENDELSE
  if keyword_set(fill) then polyfill, [hx, hx[0]], [hy, hy[0]] 
ENDELSE


END

