PRO cs_plot,ca,ca2,nlevels=nlevels,camin=camin1, zeroplot=zeroplot, $
  xrange=xrange, yrange=yrange, xyrange=xyrange

;+
;
; NAME:
;	CS_PLOT
;
; PURPOSE:
;	This procedure helps in plotting the resulting synchronous
;       and asynchronous maps from Noda's theory for 2-dimensional 
;       correlation spectroscopy 
;
; CATEGORY:
;	Mathematics.
;
; CALLING SEQUENCE:
;	CS_PLOT,cs,ca
;
; INPUTS:
;	cs: the synchronous map (see cs_synchro)
;	ca: the synchronous map (see cs_asynchro)
;
; KEYWORD PARAMETERS: 
;
;        nlevels: number of contour levels (default=5)
;        camin: 2d array with the range values for the contours
;               (default: minimum and maximum of input data)
;        zeroplot:  set this keyword to plot the contour for zero value
;        xrange: xrange for the plot
;        yrange: yrange for the plot
;        xyrange: sets both xrange and yrange
;
; REFERENCE:
;       Isao Noda and Yukuihiro Ozaki
;       Two-dimensional correlation spectroscopy
;       Applications in Vibrational and Optical Spectroscopy
;       John Wiley (2004) 
;       ISBN 0-471-62391-1
;
; PROCEDURE:
;       loads colour table from tek_color
;       plots in blue negative values and positive values in red.
;
; MODIFICATION HISTORY:
;
;	Written by Amalia Fernandez-Pa~nella. ESRF 2009
;
;	2009-05-28 srio@esrf.eu added doc, cleaned for being used in xplot.
;
;-

on_error,2

IF strupcase(!d.name) NE 'PS' THEN BEGIN
  device,decomposed=0
  tek_color
ENDIF

np = n_params()
iexit=0

p_old = !p.multi
IF np EQ 2 THEN BEGIN
  !p.multi=[0,2,1]
ENDIF ELSE BEGIN
  !p.multi=[0,1,1]
ENDELSE
  

IF N_Elements(nlevels) EQ 0 THEN nlevels=5
 
IF N_Elements(xrange) NE 2 THEN xrange=[0,n_elements(ca[0,*])]

IF N_Elements(yrange) NE 2 THEN yrange=[0,n_elements(ca[*,0])]

IF N_Elements(xyrange) EQ 2 THEN BEGIN
  xrange=xyrange
  yrange=xyrange
ENDIF

print,'xrange: ',xrange

AQUI:

IF Not(Keyword_set(camin1)) THEN camin=max(abs([max(ca),min(ca)])) ELSE camin=camin1
levels1 = makearray1(nlevels,0,camin)
levels2 = makearray1(nlevels,-camin,0)

!p.multi[0]=iexit
contour,ca,min_value=0+camin*1e-6,max_value=camin,color=2,levels=levels1, xrange=xrange,yrange=yrange, xstyle=1, ystyle=1, title='variation interval' +string(camin)
!p.multi[0]=iexit
contour,ca,min_value=-camin,max_value=0-camin*1e-6,color=5,levels=levels2,/noerase,xrange=xrange,yrange=yrange, xstyle=1, ystyle=1
!p.multi[0]=iexit
IF Keyword_Set(zeroplot) THEN contour,ca,color=6,levels=[0],/noerase,xrange=xrange,yrange=yrange, xstyle=1, ystyle=1
!p.multi[0]=iexit
contour,ca,/noerase,xrange=xrange,yrange=yrange, xstyle=1, ystyle=1, /nodata



IF ((np EQ 2) AND (iexit EQ 0)) THEN BEGIN
  ca=ca2
  iexit=1
  goto,AQUI
END

!p.multi=p_old

END
