function cs_interval, bin, nintervals = nintervals, Dialog_Parent=dialog_parent

;+
;
; NAME:
;	CS_INTERVAL
;
; PURPOSE:
;       This is an auxiliary function that used xplot for defining the 
;       cutting interval(s) before applying 2d correlation (Noda)
;
; CATEGORY:
;	Mathematics.
;
; CALLING SEQUENCE:
;	Result = CS_INTERVAL(matrixIn)
;
; INPUTS:
;	matrixIn: the matrix with the input spectra
;
; KEYWORD_PARAMETERS:
;       nintervals: the number of intervals to be selected: valid values
;                   are 1 (default) or 2. 
;       dialog_parent: the parent widget id for dialog_message()
;
; REFERENCE:
;       Isao Noda and Yukuihiro Ozaki
;       Two-dimensional correlation spectroscopy
;       Applications in Vibrational and Optical Spectroscopy
;       John Wiley (2004) 
;       ISBN 0-471-62391-1
;
;
; MODIFICATION HISTORY:
;
;	Written by Amalia Fernandez-Pa~nella. ESRF 2009
;
;	2009-05-28 srio@esrf.eu added doc, cleaned for being used in xplot.
;
;-

on_error,2


IF N_Elements(nintervals) EQ 0 then stmp=1 ELSE stmp=Fix(nIntervals)

ncf=size(bin)
nf=ncf[2]
nff=nf-1

b=bin



If stmp eq 1 then tmptxt = '2' else tmptxt='4'

itmp = Dialog_Message(/Cancel,Dialog_parent=dialog_parent, $
     ['You have selected to cut data to select part of the spectra',$
     '','Please select (click) in the window that is going to appear ',$
         tmpTxt+' points to define the interval(s)'] )

IF itmp EQ 'Cancel' THEN RETURN,bIn

window,/free, xsize=750, ysize=600
dwindow=!d.window
plot,b[1,*],xcharsize=1.2,xticks=15,yticks=10, xminor=10,xrange=[0,nf],xstyle=1

If stmp eq 1 then begin
     wait,0.3
     print,'click a point'
     cursor,mi,tmp,/data
     print,'First point is: ',mi,tmp
 
     wait,0.3
     print,'click another point'
     cursor,ma,tmp,/data
     print,'Second point is: ',ma,tmp
 
     b=b[*,(mi>0<nff):(ma>0<nff)]

endif else begin wait,0.3
     print,'click a point'
     cursor,p1,tmp,/data
     print,'First point is: ',p1,tmp
 
     wait,0.3
     print,'click another point'
     cursor,p2,tmp,/data
     print,'Second point is: ',p2,tmp
 
     wait,0.3
     print,'click another point'
     cursor,p3,tmp,/data
     print,'Third point is: ',p3,tmp
     
     wait,0.3
     print,'click another point'
     cursor,p4,tmp,/data
     print,'Fourth point is: ',p4,tmp
     goodi=indgen(nf-1)
     goodi[(p1>0<nff):(p2>0<nff)]=-2
     goodi[(p3>0<nff):(p4>0<nff)]=-2
     goodi=where(goodi eq -2)
     b=b[*,goodi]
endelse

itmp = Dialog_Message(/Cancel,Dialog_parent=dialog_parent, $
     ['Selected points are: ',vect2string(Long([p1,p2,p3,p4]))] )
IF itmp EQ 'Cancel' THEN RETURN,bIn

wdelete,dwindow

RETURN,b

END
 
