;+
;
; NAME:
;       MCA2SCAN
;
; PURPOSE:
;       Converts MCA signals from several files (spec with mca scans)
;	into spec standard scan file with coulmns:
;	channel, calibrated, mca signal
;
;	The uses must supply the list of files and the output
;	file name. 
;
; CATEGORY:
;       SPEC utilities. 
;
; CALLING SEQUENCE:
;       MCA2SCAN [,files, keywords]
;
; INPUTS (OPTIONAL):
;       files   = File name or array with file names. 
;		(if undefined and RELOAD keyword is not used, then 
;		a dialog window is started to load it/them). 
;
; KEYWORD PARAMETERS:
;	INPUT KEYWORDS: 
;	reload: set this keyword to reload the last file list used by
;		mca2scan. 
;	outFile: The name of file for output. 
;		(if undefined and RELOAD keyword is not used, then 
;		a dialog window is started to load it). 
;	group: ID of parent widget for positioning dialog windows. 
;	info: set a named variable to receive a structure with information:
;		info.outFile: the selected output file
;		info.list: the selected input file list
;		info.pathout: dir for output file
;
;	Examples: 
;	1) mca2scan
;
; MODIFICATION HISTORY:
;       Written by:     Manuel Sanchez del Rio (srio@esrf.fr) March 27 2003
;
;-



PRO mca2scan,file, outFile=outFile, Group=group, reload=reload, info=info

COMMON directory_selection,dir_root_in,filter,file1_in,dir_root_out,file1_out

catch, error_status
if error_status ne 0 then begin
  message,/info,'error caught: '+!err_string
  itmp=Dialog_Message(/Error,Dialog_Parent=group, $
    'MCA2SCAN: error caught: '+!err_string)
  catch, /cancel
  RETURN
endif


IF N_Elements(filter) EQ 0 THEN filter='*'
IF Keyword_Set(reload) THEN BEGIN
  file=file1_in
  outfile=file1_out
ENDIF

IF N_Elements(file) EQ 0 THEN BEGIN
  Title='Select one or multiple (Ctrl+Click) files'
  file = Dialog_Pickfile(/Must_Exist,Filter=filter,Dialog_Parent=group,  $
  Title=title,/Multiple_Files, Get_Path=path,Path=dir_root_in)
  IF file[0] EQ '' THEN RETURN
  dir_root_in=path
  ; 
  ; update filter
  ; 
  tmp = StrPos(file[0],'.',/Reverse_Search)
  IF tmp NE -1 THEN BEGIN
    ext = StrMid(file[0],tmp)
    filter = '*'+ext
  ENDIF
ENDIF
file1_in=file

IF N_Elements(dir_root_out) EQ 0 THEN dir_root_out=dir_root_in
IF Not(Keyword_Set(outfile)) THEN BEGIN
  Title='Select one file for output'
  outFile = Dialog_Pickfile(Dialog_Parent=group,  $
  Title=title,Get_Path=path,Path=dir_root_out,File='mca2scan.spec')
  IF outFile EQ '' THEN RETURN
  dir_root_out=path
ENDIF
file1_out = outFile



;
; get the file list 
;
nfiles=N_Elements(file)
list = file
file = list[0]
filewild = file

info = {outFile:outFile,list:list, pathout:dir_root_out}

list2 = list  ; file names without path
FOR i=0,N_Elements(list)-1 DO BEGIN
  tmp1 = StrPos(list[i],SDep(/ds),/Reverse_Search)
  list2[i] = StrMid(list[i],tmp1+1)
ENDFOR

IF CheckFile(outFile) EQ 1 THEN BEGIN
  itmp = Dialog_Message(/Info,/Cancel,['File '+outfile, $
	'already exists.',' ','Overwrite it?'], Dialog_Parent=group)
  IF itmp EQ 'Cancel' THEN RETURN
ENDIF
Openw,unit,outFile,/Get_Lun

printf,unit,'#F '+outFile
printf,unit,'#D '+sysTime()
printf,unit,'#UINFO File written by xop/mca2spec containing the mca data from:'
FOR i=0,nfiles-1 DO BEGIN
   printf,unit,'#UINFO      '+list[i]
ENDFOR


scanCount = 0L
FOR i=0,nfiles-1 DO BEGIN
  n = spec_access(h,list[i],/mcdata)
  FOR j=1,n DO BEGIN
     ; write header
     header = spec_headers(h,j,/Index)
     scanCount = scanCount + 1
     printf,unit,'#S '+StrCompress(scanCount,/Rem)+' '+ $
	list2[i]+' '+Spec_Name(h,j,/Index)
     printf,unit,'#U_OLD '+header[0]
     FOR k=1,N_Elements(header)-1 DO printf,unit,header[k]
     printf,unit,'#N  3'
     printf,unit,'#L channel  calibrated  mca'
     ; write data
     data = spec_data(h,j,/index,/mc,channels=channels,calibrated=energy)
     FOR k=1,N_Elements(data)-1 DO printf,unit, $
	String([channels[k],energy[k],data[k]],Format='(3G13.6)')
  ENDFOR

ENDFOR
Free_Lun,unit
Print,'MCA2SCAN: File written to disk: '+outFile



END ;-----------------------------------------------------
