;+
;
; NAME:
;       MCA2MESH
;
; PURPOSE:
;       Converts MCA signals from several files (spec with one mca scan)
;	into an array of dimension (5,nfiles*nchannels) with coulmns:
;	channel, energy [calibrated], file index, scan variable, mca signal
;
;
;	The uses must supply (or select) the first file of the series. 
;	CONVENTIONS ASSUMED:
;	    i) The series of files are names as:
;		<file_root>_<index>.<ext> 
;		(for example mca1_000.dat, mca1_002.dat,...mca1_020.dat).
;		The input file must be one file of the series. 
;	    ii) The individual files are of SPEC type with a single MCA scan.
;	    iii) All of them have the same scan name, which is processed
;		by the program to abtain the varible name and scanned values. 
;		(e.g.: #S 1  ascan  samh 3.44965 3.94965  20 2 , means
;			21 points in the [3.44965,3.94965] interval and
;			the variable is called samh)
;
;
; CATEGORY:
;       SPEC utilities. 
;
; CALLING SEQUENCE:
;       MCA2MESH [,inputs ,keywords]
;
; INPUTS (OPTIONAL):
;       file   = File name. 
;		(if undefined and RELOAD keyword is not used, then 
;		a dialog window is started to load it). 
;
; KEYWORD PARAMETERS:
;	INPUT KEYWORDS: 
;	plot_flag: flag to select the type of graph/output:
;		0: no plor
;		1: xplot/mesh (default) 
;	reload: set this keyword to reload the last file used by
;		mca2mesh.
;	full_select: set this keyword when user defines individual 
;		files to load.  By default, the user selects one 
;		file from the list, and the application creates 
;		the list. 
;	outFlag: 0: displays output in xplot.
;		 1: creates an output file. 
;	group: the id pf the parent widget for centering dialog windows. 
;
;	OUTPUT KEYWORDS: 
;
;	FOR outFlag=0:
;	out: set this keyword to a named variable to receive the 
;		array with the result. 
;	coltitles: set this keyword to a named variable to receive the 
;		column titles. 
;
;	FOR outFlag=1:
;
;	Examples: 
;	1) mca2mesh
;
; MODIFICATION HISTORY:
;       Written by:     Manuel Sanchez del Rio (srio@esrf.fr) March 20 2003
;
;-



;
; NOTE: common code in mca_roi_plot and mca2mesh. Modify both if needed !!!!!
;

PRO mca2mesh,file, group=group,  $
  plot_flag=plot_flag,reload=reload,  $
  out=out,colTitles=colTitles,full_select=full_select, outFlag=outFlag

;COMMON mca2mesh,dir_root,filter,file1
COMMON directory_selection,dir_root_in,filter,file1_in,dir_root_out,file1_out

catch, error_status
if error_status ne 0 then begin
  message,/info,'error caught: '+!err_string
  itmp=Dialog_Message(/Error,$
    'MCA2MESH: error caught: '+!err_string)
  catch, /cancel
  RETURN
endif


IF N_Elements(filter) EQ 0 THEN filter='*'
IF Keyword_Set(reload) THEN file=file1_in
IF N_Elements(file) EQ 0 THEN BEGIN
  IF Keyword_Set(full_select) THEN BEGIN
    Title='Select one or multiple (Ctrl+Click) files'
    Multiple_Files=1
  ENDIF ELSE BEGIN
    Title='Select one file from the series'
    Multiple_Files=0
  ENDELSE
  file = Dialog_Pickfile(/Must_Exist,Filter=filter,Dialog_Parent=group,  $
  Title=title,Multiple_Files=multiple_files, Get_Path=path,Path=dir_root_in)
  IF file[0] EQ '' THEN RETURN
  dir_root_in=path
  ; 
  ; update filter
  ; 
  tmp = StrPos(file[0],'.',/Reverse_Search)
  IF tmp NE -1 THEN BEGIN
    ext = StrMid(file[0],tmp)
    filter = '*'+ext
  ENDIF
ENDIF
file1_in=file

;
; get the file list 
;
IF Keyword_Set(full_select) THEN BEGIN
  nfiles=N_Elements(file)
  list = file
  file = list[0]
  filewild = file
ENDIF ELSE BEGIN
  tmp1 = StrPos(file,'_',/Reverse_Search)
  tmp2 = StrPos(file,'.',/Reverse_Search)
  ext = StrMid(file,tmp1,tmp2-tmp1+1)
  filewild = StrSubstitute(file,ext,'_*.')
  list = FindFile(filewild)
  nfiles = N_Elements(list)
ENDELSE

list2 = list
FOR i=0,N_Elements(list)-1 DO BEGIN
  tmp1 = StrPos(list[i],SDep(/ds),/Reverse_Search)
  list2[i] = StrMid(list[i],tmp1+1)
ENDFOR

; 
; extract the scanning variable from first file
;
sclist = spec_access(h0,file,/mcdata,/list)
IF Keyword_Set(full_select) THEN BEGIN
  scan_var_name = 'File index'
  scan_var = FindGen(nfiles)
  scanname = Vect2String(list2)
  filewild=scanname
ENDIF ELSE BEGIN
  scanname = spec_name(h0,1)
  tmp = StrSplit(scanname,' ',/Extract)
  scan_var_name = tmp[1]
  scan_var = MakeArray1(1+Long(tmp[4]),Double(tmp[2]),Double(tmp[3]))
  IF N_Elements(scan_var) NE nfiles THEN  BEGIN
    itmp = Dialog_Message(/Info,Dialog_Parent=group, $
    ['Different values of number of points ('+ $
            StrCompress(N_Elements(scan_var))+ $
            ') and number of files ('+$
            StrCompress(nfiles,/Rem)+')', $
            'Take the minimum and continue?'], /Cancel)
    IF itmp EQ 'Cancel' THEN RETURN
    tmp = Min([N_Elements(scan_var),nfiles])
    nfiles = tmp
    scan_var=scan_var[0:tmp-1]
  ENDIF
ENDELSE

;
; plot rois
;
IF N_Elements(outFlag) EQ 0 THEN outFlag=0

  FOR j=0,nfiles-1 DO BEGIN
    tmp = spec_access(hi,list[j],/mc)
    data = spec_data(hi,1,/index,/mc,channels=channels,calibrated=energy)
    IF j EQ 0 THEN BEGIN 
       ndata = N_Elements(data)
       out = FltArr(5,Long(nfiles)*ndata)
    ENDIF
    ifrom=ndata*j
    ito = ndata*j+(ndata-1)
    out[0,ifrom:ito] = channels
    out[1,ifrom:ito] = energy
    out[2,ifrom:ito] = scan_var[j]
    out[3,ifrom:ito] = j
    out[4,ifrom:ito] = data
  ENDFOR
  coltitles = ['channel','energy','scan_value','file_index','mca_signal']
  
CASE outFlag OF
0: BEGIN
    xplot,out,parent=p,/no_block,coltitles= coltitles,xtitle='-1'
    xplot_mesh,p,flag=1,col=3
    END
1: BEGIN
  IF N_Elements(dir_root_out) EQ 0 THEN dir_root_out=dir_root_in
  IF Not(Keyword_Set(outfile)) THEN BEGIN
    Title='Select one file for output'
    outFile = Dialog_Pickfile(Dialog_Parent=group,  $
    Title=title,Get_Path=path,Path=dir_root_out,File='mca2mesh.spec')
    IF outFile EQ '' THEN RETURN
    dir_root_out=path
  ENDIF
  file1_out = outFile
  IF CheckFile(outFile) EQ 1 THEN BEGIN
    itmp = Dialog_Message(/Info,/Cancel,['File '+outfile, $
        'already exists.',' ','Overwrite it?'], Dialog_Parent=group)
    IF itmp EQ 'Cancel' THEN RETURN
  ENDIF
  Openw,unit,outFile,/Get_Lun

  printf,unit,'#F '+outFile
  printf,unit,'#D '+sysTime()
  printf,unit,'#UINFO File written by xop/mca2mesh containing the mca data from:'
  FOR i=0,nfiles-1 DO BEGIN
     printf,unit,'#UINFO      '+list[i]
  ENDFOR


  printf,unit,'#S  1 mesh from mca data'
  printf,unit,'#N  5'
  printf,unit,'#L channel  energy  scan_value  file_index  mca_signal'
  FOR k=1,N_Elements(out[0,*])-1 DO printf,unit, $
          String(out[*,k],Format='(5G13.6)')
  Free_Lun,unit
  Print,'MCA2MESH: File written to disk: '+outFile
 END
ENDCASE


END ;-----------------------------------------------------
