; INTERNAL FUNCTIONS AND PROCEDURES
;___________________________________
;
; This function returns an array loaded with the tokens found in the input
; string `oldline'. Tokens are separated by a 1 or 2 white spaces according
; to the parameter `nspaces'. The function returns an error if the numbers
; of tokens found is less than `imin' or greater than `imax'. This feature
; can be cancelled by setting `imin' and/or `imax' to zero.
function __linesplit, oldline, nspaces, imin, imax
   case nspaces of
      1: begin
         line = strtrim(strcompress(' ' + oldline))
         pos = where(byte(line) eq 32b)
      end

      2: begin
         line = '  ' + strtrim(oldline, 2)
         aux0 = byte(line)
         aux = aux0 eq 32b
         pos = where(aux and [aux(1:*), 0b] and     $
                     not [0b, aux(0:n_elements(aux)-2)])
         aux0(pos) = 1B
         line = strcompress(string(aux0))
         pos = where(byte(line) eq 1B)
      end

      else: return, ''
   endcase

   n = n_elements(pos)
   if n eq 1 then begin
      list = strmid(line, nspaces, strlen(line) - nspaces)
   endif else begin
      length = [pos(1:*), strlen(line)] - pos - nspaces
      pos = pos + nspaces
      list = strarr(n)
      for i = 0, n-1 do list[i] = strmid(line, pos(i), length(i))
   endelse

   if imin gt 0 and n_elements(list) lt imin then      $
      message, 'Too few fields in <'+oldline+'>' 
   if imax gt 0 and n_elements(list) gt imax then      $
      message, 'Too many fields in <'+oldline+'>' 

   return, list
end
