PRO xpowder_calcunitcell,atoms,sym,out,aux=aux, $
    verbose=verbose,group=group

;
;+
; PRO xpowder_calcunitcell,atoms,sym,out
; 
; Applies symmetry operations to atoms in asymmetry unit
;
;
; Modified:
;
;  2007-03-20 srio@esrf.fr added auxiliary variable
;
;-


Catch, error_status
IF error_status NE 0 THEN BEGIN
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XPOWDER_CALCUNITCELL: error caught: '+!err_string)
   Message,/Info,'error caught: '+!err_string
   Catch, /Cancel
   On_Error,2
   out=0
   RETURN
ENDIF
IF N_Elements(verbose) EQ 0 THEN verbose=0
IF N_Elements(aux) EQ 0 THEN aux='s=0.0'

;
; coordinates and labels of prototypycal atoms
;
labels=atoms[5,*]
;coor = Double(atoms[0:4,*])



nsym = N_Elements(sym)
sym1 = Reform(sym)
oper = StrArr(3,nsym)
FOR i=0,nsym-1 DO BEGIN
   line = sym1[i]
   IF (StrPos(line,'.'))[0] EQ -1 THEN line = StrSubstitute(line,'/','./')
   tmp1 = StrSplit(line,',',/Extract)
   oper[*,i]=tmp1
ENDFOR

;
; dimensionate output
ncoor = N_Elements(atoms[0,*])
noper = N_Elements(oper[0,*])
coor2 = FltArr(6,ncoor*noper)

atomsNum = FltArr(6,ncoor)

txt = ['','',' Calculation of usint cell from asymmetry unit ','',$
       '>>>>>>> Inputs: ',$
       ' ','Atomic positions: ',$
       String(['index','Z','Occ','x','y','z','label'],Format='(7A10)')]
FOR i=0,N_Elements(atoms[0,*])-1 DO BEGIN
       txt = [txt,String(i,atoms[*,i],Format='(I10,6A10)')]
ENDFOR
txt = [txt,'','Auxiliary variable: '+aux]

;txt = [txt,' ','Symmetry Operations: ','          '+Reform(sym), $

txt = [txt,' ','Symmetry Operations: ',$
       String('index','operation',Format='(A10,A20)')]
FOR i=0,N_Elements(oper[0,*])-1 DO BEGIN
       txt = [txt,String(i,oper[0,i]+',',oper[1,i]+',',oper[2,i],Format='(I10,3A10)')]
ENDFOR

;
; perform matrix operation on coordinates
; (do not consider coordinates outside unit cell, i.e.,  coord>1)
;
IF Keyword_Set(verbose) THEN txt = [txt,' ','>>>>>>> Debugging: ' ] 
k=-1L
FOR j=0L,ncoor-1 DO BEGIN
FOR i=0L,noper-1 DO BEGIN
    x1=-1000.
    y1=-1000.
    z1=-1000.
    ;zz = coor[0,j]
    ;f = coor[1,j]
    ;x = coor[2,j]
    ;y = coor[3,j]
    ;z = coor[4,j]


    cmd = [ aux,$
            'zz='+atoms[0,j], $
            'f='+atoms[1,j], $
            'x='+atoms[2,j], $
            'x1='+oper[0,i], $
            'y='+atoms[3,j], $
            'y1='+oper[1,i], $
            'z='+atoms[4,j], $
            'z1='+oper[2,i] ]

    FOR ik=0L,N_Elements(cmd)-1 DO BEGIN
      itmp = Execute(cmd[ik])
      IF itmp NE 1 THEN Message,'Error with: '+cmd[ik]
    ENDFOR

    IF Keyword_Set(verbose) THEN BEGIN
	txt = [txt,'',' (Z='+StrCompress(zz)+')']
        txt = [txt,cmd]
    ENDIF

    IF itmp NE 1 THEN Message,'Error with: '+'z1='+oper[2,i]
    IF x1 LT 0 THEN x1=x1+1
    IF y1 LT 0 THEN y1=y1+1
    IF z1 LT 0 THEN z1=z1+1
    IF x1 GE 1 THEN x1=x1-1  ; watch the "E"!!!
    IF y1 GE 1 THEN y1=y1-1
    IF z1 GE 1 THEN z1=z1-1
    k=k+1
    coor2[*,k]=[zz,f,x1,y1,z1,j]
    IF i EQ 0 THEN atomsNum[*,j]=[zz,f,x1,y1,z1,j]
  ENDFOR
ENDFOR
;
coor2=coor2[*,0:k]

;
; eliminate duplicated coordinates
; and compute position multiplicity
;

posMultiplicity = Replicate(0.,N_Elements(atoms[0,*]))
;
FOR i=0L,k DO BEGIN
   ;tmp = coor2[2:5,i]
   tmp = coor2[2:4,i]
   IF tmp[0] NE -1000 THEN BEGIN
     FOR j=i+1,k DO BEGIN
       ;IF Total(Abs(coor2[2:5,j]-tmp)) LE 1E-6 THEN BEGIN
       IF (Total(Abs(coor2[2:4,j]-tmp)) LE 1E-6) AND (coor2[5,i] EQ coor2[5,j] )   THEN BEGIN
          coor2[2:4,j]=-1000
          posMultiplicity[coor2[5,j]]=posMultiplicity[coor2[5,j]]+1
       ENDIF
       ;================================================================
       ; 
       ; ADDED AD HOC  CENTROSYMMETRY??
       ;
       ;IF (Total(Abs(coor2[2:4,j]-(-tmp+1))) LE 1E-6) AND (coor2[5,i] EQ coor2[5,j] )   THEN BEGIN
       ;   coor2[2:4,j]=-1000
       ;   posMultiplicity[coor2[5,j]]=posMultiplicity[coor2[5,j]]+1
       ;ENDIF
       ;================================================================
     ENDFOR
   ENDIF
ENDFOR
posMultiplicity = Float(noper) - posMultiplicity
igood = Where(coor2[2,*] NE -1000)
coor2 = coor2(*,igood)

;
; Numerical values of atomic positions
;
txt = [txt,'','','Atomic positions (numeric): ',' ']
txt = [txt, $
String('Z','Occ','x','y','z','index',Format='(A5,4A10,A6)')]
FOR i=0,N_Elements(atomsNum[0,*])-1 DO BEGIN
  txt = [txt,String(atomsNum[0:5,i],Format='(I5,4G10.3,I6)')]
ENDFOR


txt = [txt,' ','>>>>>>> Outputs: ' ] 
txt = [txt,'','From a total of '+StrCompress(Long(ncoor)*noper)+ $
  ' position, there are '+StrCompress(N_Elements(coor2[0,*]))+$
  ' different (non-redundant) ones','']

;
; chemical formula
;
igood = uniq(labels,sort(labels))
txt = [txt, $
String('Label','Chemical formula','site multiplicity',Format='(3A20)') , $
String('','(per u cell)','',Format='(3A20)')]
molwt = 0.0
IF (size(coor2))[0] EQ 1 THEN BEGIN ; only one position
    molwt = total(coor2[1]*coor2[0])
    kkk = coor2[1]
    txt = [txt,String(labels[0],kkk,posMultiplicity[0],Format='(A20,2G20.4)')]
ENDIF ELSE BEGIN
  FOR i=0,N_Elements(igood)-1 DO BEGIN
    i2 = igood[i]
    jgood = Where(labels EQ labels[i2])
    kkk = 0.0
    FOR j=0,N_Elements(jgood)-1 DO BEGIN
     j2 = jgood[j]
     itmp = Where(coor2[5,*] EQ j2)
     kkk = kkk+total(coor2[1,itmp])
     molwt = molwt + total(coor2[1,itmp]*Atomic_Constants(coor2[0,itmp],Ret=2))
    ENDFOR
    txt = [txt,String(labels[i2],kkk,posMultiplicity[i2],Format='(A20,2G20.4)')]
  ENDFOR
ENDELSE
txt = [txt, ' ','Molecular weight:   '+StrCompress(molwt), $
      ' ' ,' ','  Positions in the unit cell: '] 


; 
; display results
;
txt = [txt,String('Index','Z','Occ','x','y','z','Label',Format='(7A10)')]
out = StrArr(6,N_Elements(coor2[0,*]))
FOR i=0,N_Elements(coor2[0,*])-1 DO BEGIN
  line = [String(coor2[0:4,i]),labels[coor2[5,i]]]
  out[*,i]= line
  txt = [txt,String(i,coor2[0:4,i],labels[coor2[5,i]],Format='(2I10,4G10.4,A10)')]
ENDFOR
;
;; 
;; write ucell file
;; 
;file='sym_sepiolite_BraunerPreisinger.ucell'
;openw,unit,file,/Get_Lun
;printf,unit,'13.4 26.78 5.28 90 90 90'
;FOR i=0L,N_Elements(coor2[0,*])-1 DO printf,unit,coor2[0:4,i],Format='(I3,4G15.5)'
;free_lun,unit
XDisplayFile1,text=txt,Title='Xpowder: Unic Cell'
;
END
