PRO xop_wd,GROUP=group,default=default,setDir=setDir,_Extra=extra
;+
; NAME:
;	XOP_WD
;
; PURPOSE:
;	Changes XOP working directory. XOP working directry is where
;	XOP writes temporary files. 
;
; CATEGORY:
;	XOP
;
; CALLING SEQUENCE:
;	XOP_WD
; INPUTS:
;	None
;
; KEYWORD PARAMETERS:
;       GROUP:  The widget ID of the group leader of the widget.  If this 
;               keyword is specified, the death of the group leader results in
;               the death of widgets created by XOP_WD.
;	DEFAULT: When this keyword is set, XOP_WD changes directory to
;		the default XOP Working Directory. This directory is
;		specified in the XOP_WD environment variable. If the
;		XOP_WD environment variable is not set, the XOP Working
;		Directory is  %XOP_HOME%\tmp under WINDOWS and .
;		(dot=current directory) under UNIX.
;		If this keyword is not set, a dialog_pickfile window 
;		appears to select interactively the Working Directory.
;       SETDIR: Name of the directory. If undefined, the application 
;               launches a browser. 
;
; OUTPUTS:
;	None
;
; SIDE EFFECTS:
;	Changes directory using the IDL's cd command.
;
; PROCEDURE:
;	Straightforward.
;
; USE:
;	This procedure is to be used by XOP_INI when starting XOP.
; EXAMPLES:
;	xop_wd
;	xop_wd,/defaults
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio (srio@esrf.fr) 97/10/02
;	98/11/04 srio@esrf.fr adds Catch. Use of /Dir kw in Dialog_Pickfile().
;	99/01/12 srio@esrf.fr fixed doc.
;       2007/10/23 srio@esrf.eu sets the XOP_WD environment variable.
;		Added SetDir keyword. 
;-

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(/Error,'XOP_WD: error caught: '+!error_state.msg)
   catch, /cancel
   on_error,2
   Return
endif

if keyword_set(default) then begin
  wd = Xop_GetEnv('XOP_WD')
  if wd eq '' then begin
    case sdep() of
    'WINDOWS': wd=Xop_GetEnv('XOP_HOME')+'\tmp'
    'UNIX': wd='.'
    else:
    endcase
  endif 
  cd,wd
  cd,current=wd
  XOP_Setenv,'XOP_WD='+wd
  message,/info,'XOP working directory is '+wd
endif else begin
  IF Keyword_Set(setDir) THEN BEGIN
    wd=setDir
    tmp=setDir
  ENDIF ELSE BEGIN
    wd=''
    cd,current=wdold
    tmp = Dialog_Pickfile(path=wdold,get_path=wd,group=group,$
    title='Select XOP working directory',/Dir)
  ENDELSE
  if tmp NE '' then begin
   cd,wd
   XOP_Setenv,'XOP_WD='+wd
   message,/info,'XOP working directory is '+wd
   itmp = Dialog_Message(/Info,Dialog_Parent=group,$
     ['XOP working directory is: ',wd])
  endif
endelse

end ; xop_wd
