
;+
; NAME:
;	XPICKFILE
;
; PURPOSE:
;	This routine provides a graphical interface that allows to 
;	define a file.
;
; CATEGORY:
;	Widgets.
;
; CALLING SEQUENCE:
;	XPICKFILE
;
; INPUT PARAMETERS:
;
; KEYWORD PARAMETERS:
;	GROUP:	The widget ID of the widget that calls XPEAKFILE.  When this
;		keyword is specified, the death of the caller results in the
;		death of XPEAKFILE.
;
;	WTitle: The title of the main window (Default=XPickFile)
;	Title: The title (text) close to the file name (default="File to write:"
;	File: On input, the file name to be presented. On output, the 
;		modified (loaded) file name. 
;	Action: Returns a string with "DO" or "DONT" depending if the
;		Accept or Cancel button is pressed, respectively.
;	
;
; SIDE EFFECTS:
;	The XMANAGER is initiated if it is not already running.
;
;
; PROCEDURE:
;	Uses the CW_PickFile compound widget.
;
; MODIFICATION HISTORY:
;
;	Writtem by M. Sanchez del Rio (ESRF) 99/03/18 
;-
Pro XPickFile_Event, event

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   if sdep(/w) then itmp = Dialog_Message(/Error,$
	'XPICKFILE_EVENT: error caught: '+!error_state.msg)
   catch, /cancel
   GoTo,out
endif

Widget_Control, event.id, get_UValue=eventUValue
if not(keyword_set(eventUValue)) then eventUValue=''

stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy

Case eventUValue OF
  'ACCEPT': Begin
    file=''
    Widget_Control,state.wids.file,Get_value=file
    *(state.ptrAction)='DO'
    *(state.ptrFile)=file
    Widget_Control, event.top, /destroy
    Return
  End
  'CANCEL': Begin
    Widget_Control, event.top, /destroy
    Return
  End
  else:
ENDCASE

out:
IF Type(state) EQ 8 THEN $
  IF Widget_Info(stateid,/Valid_Id) THEN $
  Widget_Control, stateid, Set_UValue=state, /No_Copy

END ; XPickFile_Event

;
;==============================================================================
;
Pro XPickFile,WTitle=wtitle,Title=title,Group=group,File=file,$
  Action=action,XSize=xSize

IF Not(keyword_Set(wTitle)) THEN wTitle='XPickFile'
IF Not(keyword_Set(title)) THEN title='File to write: '
IF Not(keyword_Set(file)) THEN file=''

IF Keyword_Set(group) THEN BEGIN
  tlb=Widget_Base(/Col,Title=wTitle,/Modal,Group=group)
ENDIF ELSE BEGIN
  tlb=Widget_Base(/Col,Title=wTitle)
ENDELSE
wtmp=Widget_Base(tlb) ; to store state

wtmpb=Widget_Base(tlb, /Row)
  wtmp = Widget_Button(wtmpb,Value='Accept',UValue='ACCEPT')
  wtmp = Widget_Button(wtmpb,Value='Cancel',UValue='CANCEL')
; the important part:
wfile = CW_PickFile(tlb,Title=title,/Frame,XSize=xSize,Value=file)

action='DONT'
ptrFile=Ptr_New(file)
ptrAction=Ptr_New(action)
wids={file:wfile}
state = {wids:wids, ptrFile:ptrFile, ptrAction:ptrAction}

Widget_Control,Widget_Info(tlb,/Child),Set_UValue=state
Widget_Control,tlb,/Realize


IF Not(Keyword_Set(group)) THEN modal=1 ELSE modal=0
XManager, 'xpickfile', tlb, Modal=modal

IF *ptrAction EQ 'DO' THEN BEGIN
  action=*ptrAction
  file=*ptrFile
ENDIF

IF Ptr_Valid(ptrFile) THEN Ptr_Free,ptrFile
IF Ptr_Valid(ptrAction) THEN Ptr_Free,ptrAction

END ; XPickFile
