
FUNCTION strsubstitute,s_in,s_from,s_to,nocase=nocase,noglobal=noglobal

;+
; NAME:
;	STRSUBSTITUTE
; PURPOSE:
;	Substitutes a string text by another one in a string line.
; CATEGORY:
;	String Processing
; CALLING SEQUENCE:
;	Result = STRSUBSTITUTE( LINE, STRING_FROM, STRING_TO)
; INPUTS:
;    LINE
;	Character string.
;    STRING_FROM
;	Character string.  Text to be changed.
;    STRING_TO
;	Character string.  Text for replacement.
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;	NOGLOBAL: When set, substitutes only the first occurrence.
;	NOCASE: When set, ignore case folding.
; OUTPUTS:
;	A string whith the corresponding text replaced.
; OPTIONAL OUTPUT PARAMETERS:
;	None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward.
; EXAMPLE:
;	print,strsubstitute('Give me five dollars!','five','ten')
;	You get: Give me ten dollars!
; MODIFICATION HISTORY:
;	Created 29-MAY-1996 by M. Sanchez del Rio (srio@esrf.fr)
;	96-9-19 MSR corrects a bug when multiple substitutions.
;-

; 
; substitutes sstring s_from to s_to im s_in
;

;find the number of occurrences

i=0
cnt=0
pos = -1
if keyword_set(nocase) then begin
  ss_in = strupcase(s_in)
  ss_from = strupcase(s_from)
endif else begin
  ss_in = s_in
  ss_from = s_from
endelse
while (i ne -1) do begin
  i = strpos(ss_in,ss_from,i)
  if (i ne -1) then begin 
    cnt = cnt+1
    i = i + 1
    if n_elements(pos) EQ 1 then begin
       if (pos EQ -1) then pos = i-1 else pos=[pos,i-1]
    ; srio corrects bug : endif else  pos=[pos,i]
    endif else  pos=[pos,i-1]
  endif
endwhile 
;; print, 'Found : ',cnt
if cnt EQ 0 then return,s_in

;
;help,pos(0)-1
;; print,poS
s_out = strmid(s_in,0,pos(0))
;; print,'s_out (start): ***'+s_out+'***'
if keyword_set(noglobal) then cnt=1
for  i=0,cnt-1 do begin
  istart = pos(i)+strlen(s_from)
  if i EQ cnt-1 then ilen = 100000 else ilen=pos(i+1)-istart
  ;; print,'>>',istart,ilen
  s_out=s_out+s_to+strmid(s_in,istart,ilen)
  ;; print,'s_out (i): ***'+s_out+'***',i
endfor

return,s_out
end


