
;+
;
; NAME:
;	CS_ASYNCHRO
;
; PURPOSE:
;	This function returns the asynchronous map as defined by 
;       the Noda's theory for 2-dimensional correlation spectroscopy 
;
; CATEGORY:
;	Mathematics.
;
; CALLING SEQUENCE:
;	Result = CS_ASYNCHRO(x)
;
; INPUTS:
;	x: the matrix with the input spectra
;
; REFERENCE:
;       Isao Noda and Yukuihiro Ozaki
;       Two-dimensional correlation spectroscopy
;       Applications in Vibrational and Optical Spectroscopy
;       John Wiley (2004) 
;       ISBN 0-471-62391-1
;
; PROCEDURE:
;       See formula 3.6 in pag 40 of the cited reference.	
;       The matrix in formula 3.7 is calculated using the 
;       auxiliary function cs_matrix()
;
; MODIFICATION HISTORY:
;	Written by Amalia Fernandez-Pa~nella. ESRF 2009
;
;	2009-05-28 srio@esrf.eu added doc, cleaned for being used in xplot.
;
;-


;
; auxiliary function cs_matrix
;
function cs_matrix,m
on_error,2
bn=fltarr(m,m)
; rellenar la matriz N
for j=0,m-1 do begin
for k=0,m-1 do begin
    if (k eq j) then bn[j,k]=0  else bn[j,k]=1.0/(j-k)
endfor
endfor
return, bn
end

;
; MAIN function cs_asynchro
;

function cs_asynchro, x

on_error,2

; Obtener numero de columnas
n=size(x)

m=n[1]

; matriz asincrona

bn=cs_matrix(m)
g=bn#x
m1=n[2]
ca= (1.0D/m1-1.0D)*x##transpose(g)
ca=-1.0D*ca
return, ca

END
