
;+
; 
; NAME: 
;	SPEC2EXCEL
;
; PURPOSE:
;	This procedure creates an XML-EXCEL file from a SPEC file
;
; CATEGORY:
;	Util
;
; CALLING SEQUENCE:
;	spec2excel, infile, outfile
;
; INPUTS:
;     infile: The SPEC input file
;
; OPTIONAL INPUTS:
;     outfile: the EXCEL output file. If this input is not defined, 
;		the output name has the same name of the input file
;		with the .xls extension. 
;
; KEYWORD PARAMETERS:
;     NoHeader: Set this keyword to avoid writing header information. 
;     OutFile: in output, the EXCEL file name
;     _Extra: other keywords to be passed to Dialog_Message and 
;		XDisplayFile1
;     Open: Set this keyword to ask for opening the file (only windows). 
;
; OUTPUTS:
;	A disk file. 
;
;
; PROCEDURE:
;	It uses xmlexcel_workbook
;
;
; MODIFICATION HISTORY:
;	Written By Manuel Sanchez del Rio (srio@esrf.fr), April 2006
;	2006-04-13 srio@esrf.fr documented
;
;-
PRO spec2excel, infile, outfile, noheader=noheader,outfile=outfile1,$
   open=open, _Extra=extra

IF N_Elements(outfile) EQ 0 THEN BEGIN
  itmp = strpos(infile,'.',/Reverse_search)
  IF itmp GT 0 THEN BEGIN
    outfile=strmid(infile,0,itmp)+'.xls'
  ENDIF ELSE BEGIN
    outfile=infile+'.xls'
  ENDELSE
ENDIF

nlist=spec_access(h,infile,/list)
iaddindices = 0
IF N_ELEMENTS(uniq(nlist,sort(nlist))) NE N_ELEMENTS(nlist) THEN iaddindices=1

openw,unit,outfile,/Get_Lun
xmlexcel_workbook,unit,/Open
FOR i=1,n_elements(nlist) DO BEGIN
  IF iaddindices THEN tmp='('+StrCompress(i,/Rem)+')' ELSE tmp=''
  xmlexcel_worksheet,unit,/Open,Name=StrCompress(nlist[i-1],/Rem)+tmp
    IF NOT(Keyword_Set(noheader)) THEN BEGIN
      IF i EQ 1 THEN all=1 ELSE all=0
      header=spec_headers(h,i,/index,all=all)
      FOR j=0,N_Elements(header)-1 DO xmlexcel_putline,unit,header[j]
    ENDIF
    labels=spec_labels(h,i,/index)
    xmlexcel_putline,unit,labels
    nlines = spec_points(h,i,/index)
    IF nlines GT 0 THEN BEGIN
      data=spec_data(h,i,/index)
      FOR j=0,nlines-1 DO xmlexcel_putline,unit,Reform(data[*,j])
    ENDIF
  xmlexcel_worksheet,unit,/Close
ENDFOR
xmlexcel_workbook,unit,/Close
Free_Lun,unit
outfile1=outfile
print,'File '+outfile1+' written to file.'

IF Keyword_Set(open) THEN BEGIN
  IF SDep() EQ 'WINDOWS' THEN BEGIN
    itmp = Dialog_Message(_Extra=extra,/Question,$
       ['File written to disk: ',outfile1,$
        ' ','Do you want to open it? '])
    IF itmp EQ 'Yes' THEN BEGIN
        itmp = strpos(outfile1,'\',/reverse_search)
	IF itmp[0] NE -1 THEN BEGIN
	  f1=StrMid(outfile1,0,itmp)
	  f2=StrMid(outfile1,itmp+1)
	  xop_spawn,['cd '+f1,'start '+f2],/noPath
	ENDIF ELSE BEGIN
	  spawn,'start '+outfile1 
	ENDELSE
    ENDIF
  ENDIF ELSE BEGIN
    itmp = Dialog_Message(_Extra=extra,$
       ['File written to disk: ',outfile1])
  ENDELSE
ENDIF

END
