FUNCTION bragg_lorentz,theta,return=ireturn

;+
; NAME:
;       BRAGG_LORENTZ
;
; PURPOSE:
;	This function returns the Lorentz factor, polarization factor
;	(unpolarized beam), geometric factor, or a combination of them.
;	
; CATEGORY:
;       X-Ray optics. DABAX data base.
;
; CALLING SEQUENCE:
;	out = bragg_lorentz(bragg_angle)
; INPUTS:
;	bragg_angle: the Bragg angle in degrees
;
;	
; KEYWORDS:
;	return: A flag indicating the returned variable:
;               0: (default) PolFac*lorentzFac
;               1: PolFac
;               2: lorentzFac
;               3: geomFac
;
;
; OUTPUT:
;	out: the value of the selected parameter
;
;
; MODIFICATION HISTORY:
;       2007-01 Written by M. Sanchez del Rio (srio@esrf.fr)
;-

on_error,2
 tr = theta*!dpi/180


 ; Formula copied from MAMON, it does not look to be correct.
 ; theta is the Bragg angle in degrees
 ;
 ;lorentzNum = 1D0+cos(tr*2)^2
 ;lorentzDen = 2D0*cos(tr)*(sin(tr))^2
 ;lorentzFac = lorentzNum/lorentzDen

 ;
 ; See Warren, X-ray diffraction, Dover, pag 44
 ;
 PolFac = 0.5D0*(1D0+(cos(2D*tr))^2)
 lorentzFac = 1D/sin(2D*tr)
 geomFac = 1D*cos(tr)/sin(2D*tr)

 IF N_Elements(ireturn) EQ 0 THEN ireturn=0

 CASE ireturn OF
   0: out=PolFac*lorentzFac
   1: out=PolFac
   2: out=lorentzFac
   3: out=geomFac
   4: out=PolFac*lorentzFac*geomFac
   else: out=0
 ENDCASE


 RETURN,out
END
