
;+
; NAME:
;	STEP_ATAN 
; PURPOSE:
;	Returns the value of a step function (arc tan)
; CATEGORY:
;	Mathematics.
; CALLING SEQUENCE:
;	Result = step_atan(x,p)
; INPUTS:
;	x: the argument for the function (number or array)
;	p: array with the function coefficients:
;		p[0] Amplitud
;		p[1] Center
;		p[2] Full Width at Half Maximum (of the derivative)
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Easy: y = p[0]*( (1.0D0/!dpi) * atan ( (x-p[1])/(p[2]/2.0D0) ) + 0.5D0 )
; MODOFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble December 2001
;
;-
FUNCTION step_atan,x,p
  y = p[0]*( (1.0D0/!dpi) * atan ( (x-p[1])/(p[2]/2.0D0) )  + 0.5D0 )
  RETURN,y
END
