FUNCTION fit2d2xplot2d,xIn,pixel=p0,verbose=iverbose

;+
; NAME:
;	fit2d2xplot2d
;
; PURPOSE:
;	this function converts the CCD coordinate system used in fit2d
;		to the XOP/XPLOT2D one.
; CATEGORY:
;
; CALLING SEQUENCE:
;    out = fit2d2xplot2d(input, pixel=p0,verbose=1
;
; INPUTS:
;	input:  input=[x0,y0,distance_mm,rotation_angle_deg,tilt_deg]
;
; OUTPUTS
;      out=[x0,y0,xs,ys,zs]
;
; KEYWORD PARAMETERS:
;	pixel: the pixel size in microns
;	verbose: set this keyword to 1 for printing the results on the screen
;
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio. ESRF. Grenoble, Februaty 2011
;	2011-02-25 srio@esrf.eu Documented
;-	
;+
;
; FUNCTION fit2d2xplot2d,[x0,y0,distance_mm,rotation_angle_deg,tilt_deg], pixel=p0
;
;    Usage:  out = fit2d2xplot2d([x0,y0,distance_mm,rotation_angle_deg,tilt_deg], pixel=p0,verbose=1
;      with out=[x0,y0,xs,ys,zs]
;
;
; Written srio@esrf.eu, 2011-02-11
; 
;-

IF N_ELEMENTS(xIn) NE 5 THEN  BEGIN
 print,'Usage:  out = fit2d2xplot2d([x0,y0,distance_mm,rotation_angle_deg,tilt_deg], pixel=p0,verbose=1'
 print,'   with out=[x0,y0,xs,ys,zs]'
 RETURN,0
ENDIF

IF N_Elements(p0) EQ 0 THEN p0=77.28
IF N_Elements(iverbose) EQ 0 THEN iverbose=0
x0=xIn[0]
y0=xIn[1]
DD0=xIn[2]
rotit=xIn[3]
tilt=xIn[4]

p = p0*1d-3 ; in mm
DD=DD0/p    ; in pixels
Zs2 = DD^2/(1.0+tan(tilt*!pi/180.0)^2)
r = DD*abs(tan(tilt*!pi/180.0))/sqrt(1.0+tan(tilt*!pi/180.0)^2)


deltaX=r*abs(cos(rotit*!pi/180))
deltaY=r*abs(sin(rotit*!pi/180))
Zs = sqrt(zs2)

; get quadrant
qq=1
IF ((rotit GE 0) AND (tilt LE 0)) THEN qq = 1
IF ((rotit LE 0) AND (tilt GE 0)) THEN qq = 2
IF ((rotit GE 0) AND (tilt GE 0)) THEN qq = 3
IF ((rotit LE 0) AND (tilt LE 0)) THEN qq = 4

case qq OF
 1: BEGIN
      Xs = X0+DeltaX
      Ys = Y0+DeltaY
    END
 2: BEGIN
      Xs = X0-DeltaX
      Ys = Y0+DeltaY
    END
 3: BEGIN
      Xs = X0-DeltaX
      Ys = Y0-DeltaY
    END
 4: BEGIN
      Xs = X0+DeltaX
      Ys = Y0-DeltaY
    END
endcase


IF (iVerbose EQ 1) THEN BEGIN
print,' '
print,'---------- inputs -----------------'
print,'x0=',x0
print,'y0=',y0
print,'D[mm]=',DD0
print,'pixel[microns]=',p0
print,'---------- outputs ----------------'
print,'quadrant= ',qq
print,'r2= ',r^2
print,'DeltaX= ',deltaX
print,'DeltaY= ',deltaY
print,'x0=',x0
print,'y0=',y0
print,'Xs=',Xs
print,'Ys=',Ys
print,'Zs ',sqrt(zs2)
print,'-----------------------------------'
ENDIF


return,[x0,y0,xs,ys,zs]
end

