;
;=====================================================================
;
FUNCTION edf_extract,input,range=range, header=header, block=block
;+
;
; FUNCTION edf_extract,input,range=range, header=header, block=block
; extracts a subset of a file defined in the range keyword (bytes)
; accepts as input the file name (i.e. 'Image.dat') or its info
; structure generated by edf_analyzer.pro
; keywords (by priority order)
;   range, header, block
; note : for header = 0 (global header) type header='0' otherwise
; IDL does not take into account the keyword
;
;   2008/07/31 srio@esrf.eu adapted for compressed files
;-
on_error,2
;
input_type = (size(input))((size(input))(0)+1)
if input_type eq 7 then edf_analyzer,input,str
if input_type eq 8 then str = input
;
; select the range
;
if not(keyword_set(range)) then begin
  range = [0L,str.size]
  if keyword_set(header) then begin
    header = fix(header)
    range=[str.headerpos(0,header),str.headerpos(1,header)]
  endif
  ;
  if keyword_set(block) then begin
    block = fix(block)
    range=[str.blockpos(0,block),str.blockpos(1,block)]
  endif
endif
;
openr,Unit,str.name,/get_lun,compress=str.compress
dumpfile = assoc(Unit,bytarr(str.size))
point_lun,Unit,range(0)
result = dumpfile(range(0):range(1),0)
free_lun,Unit
return,result
end
