;
;==============================================================================
;
FUNCTION bytetotext,datain,list = list
;
; similar to STRING but it creates an array of strings. Each element
; of the string goes until the NL ascii delimiter
;
input = byte(datain)    ; converts to byte
input = [input,byte(10)] ; add the last NL
linepos=where(input eq 10)  ; maps the NL (New Line, ascii(decimal)=10
;print,linepos
nlines = n_elements(linepos)
output = strarr(nlines)
;print,'nlines = ',nlines
;print,linepos
;
output(0) = string( input(0:linepos(0)) )
for i=1,nlines-1 do begin
output(i) = string( input(linepos(i-1)+1:linepos(i)) )
endfor
;
if keyword_set(list) then begin
  for i=0,nlines-1 do begin
    nchar = strlen(output(i)) -1              ; NL not considered
    fmt = '(A'+strcompress(nchar,/rem)+')'    ; format to avoir double NL
    print,output(i),format=fmt
  endfor
endif
;

return,output
end
