FUNCTION atomic_names,z

; 
; European Synchrotron Radiation Facility (ESRF)
;+
; NAME:
;       ATOMIC_NAMES
;
; PURPOSE:
;	Returns an array with the atomic names.
;	
; CATEGORY:
;       X-Ray optics. DABAX data base.
;
; CALLING SEQUENCE:
;	out = atomic_names( [zetas] )
; OPTIONAL INPUTS:
;	zetas: an integer (or array of integers) with the z value of 
;		the desired symbol(s). If undefined returns an array 
;		with all (118) elements + vacuum (Z=0!!)
;	
; OUTPUT:
;	out: a string array with the names. 
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLES:
;	IDL> print,atomic_names(14) (returns 'Silicon')
;
; MODIFICATION HISTORY:
;       2007-10-23 srio@esrf.eu Created.
;-
;
on_error,2
out=[ 'Vacuum',$
'Hydrogen','Helium','Lithium','Beryllium','Boron',$
'Carbon','Nitrogen','Oxygen','Fluorine','Neon',$
'Sodium','Magnesium','Aluminum','Silicon','Phosphorus',$
'Sulfur','Chlorine','Argon','Potassium','Calcium',$
'Scandium','Titanium','Vanadium','Chromium','Manganese',$
'Iron','Cobalt','Nickel','Copper','Zinc',$
'Gallium','Germanium','Arsenic','Selenium','Bromine',$
'Krypton','Rubidium','Strontium','Yttrium','Zirconium',$
'Niobium','Molybdenum','Technetium','Ruthenium','Rhodium',$
'Palladium','Silver','Cadmium','Indium','Tin',$
'Antimony','Tellurium','Iodine','Xenon','Cesium',$
'Barium','Lanthanum','Cerium','Praseodymium','Neodymium',$
'Promethium','Samarium','Europium','Gadolinium','Terbium',$
'Dysprosium','Holmium','Erbium','Thulium','Ytterbium',$
'Lutetium','Hafnium','Tantalum','Tungsten','Rhenium',$
'Osmium','Iridium','Platinum','Gold','Mercury',$
'Thallium','Lead','Bismuth','Polonium','Astatine',$
'Radon','Francium','Radium','Actinium','Thorium',$
'Protactinium','Uranium','Neptunium','Plutonium','Americium',$
'Curium','Berkelium','Californium','Einsteinium','Fermium',$
'Mendelevium','Nobelium','Lawrencium','Rutherfordium','Dubnium',$
'Seaborgium','Bohrium','Hassium','Meitnerium','Darmstadtium',$
'Roentgenium','Ununbium','Ununtrium','Ununquadium','Ununpentium',$
'Ununhexium','Ununseptium','Ununoctium']

IF N_Elements(z) EQ 0 THEN Return,out ELSE Return,out[z]
END
