
;
;+ 
;
; main:
; PRO XPLOT2D_ROI_EDIT,wXplot2d,Parent=wBase
; auxiliar:
; PRO xplot2d_roi_edit_updatepanels,wbase
; PRO XPLOT2D_ROI_EDIT_Set_Tab_Current, wiD,current
; PRO XPLOT2D_ROI_EDIT_EVENT, event
;
; procedures for managing rois
;
; for internal use of xplot2d.pro
;
; released: 
; 2007-12-19 srio@esrf.eu for xplot2d 2.00
;
; modified: 
; 
;-
;
;===============================================================================
;
PRO xplot2d_roi_edit_updatestr,wbase

widget_control,wbase,get_uvalue=info

itab=Widget_Info(info.wids.tab,/Tab_Current)
;help,itab

wXplot2d=info.wids.Xplot2d
IF Not(Widget_Info(wXplot2d,/Valid_Id))  THEN RETURN
Widget_Control,wxplot2d,Get_UValue=infoXplot2d

CASE itab OF
  0: BEGIN ; conic
     Widget_Control,info.wids.conic.Xcent,Get_Value=Xcent
     Widget_Control,info.wids.conic.Ycent,Get_Value=Ycent
     Widget_Control,info.wids.conic.axis1,Get_Value=axis1
     Widget_Control,info.wids.conic.axis2,Get_Value=axis2
     IF Double(axis2) LE 0 THEN axis2=axis1 ; circle
     Widget_Control,info.wids.conic.phi,Get_Value=phi
     roi_text = 'conic,'+Xcent+','+Ycent+','+axis1+','+axis2+','+phi
     infoXplot2d.str.roi.last = roi_text
     END
  1: BEGIN ; cake
     Widget_Control,info.wids.cake.Xcent,Get_Value=Xcent
     Widget_Control,info.wids.cake.Ycent,Get_Value=Ycent
     Widget_Control,info.wids.cake.axis1,Get_Value=axis1
     Widget_Control,info.wids.cake.axis2,Get_Value=axis2
     Widget_Control,info.wids.cake.phi1,Get_Value=phi1
     Widget_Control,info.wids.cake.phi2,Get_Value=phi2
     roi_text = 'cake,'+Xcent+','+Ycent+','+axis1+','+axis2+','+$
                phi1+','+phi2
     infoXplot2d.str.roi.last = roi_text
     END
  2: BEGIN ; polygon
     Widget_Control,info.wids.polygon,Get_Value=table
     roi_text = 'polygon,'+Vect2String([Reform(table[0,*]),table[0,0]])$
                      +','+Vect2String([Reform(table[1,*]),table[1,0]])
     infoXplot2d.str.roi.last = roi_text
     END
  3: BEGIN ; annulus
     Widget_Control,info.wids.annulus,Get_Value=annulus
     infoXplot2d.str.roi.annulus=Double(annulus)
     END
  else:
ENDCASE


widget_control,wXplot2d,set_uvalue=infoXplot2d

END ; xplot2d_roi_updatestr
;
;===============================================================================
;
PRO xplot2d_roi_edit_updatepanels,wbase

widget_control,wbase,get_uvalue=info
wXplot2d=info.wids.xplot2d
IF Not(Widget_Info(wXplot2d,/Valid_Id))  THEN RETURN

widget_control,wXplot2d,get_uvalue=infoXplot2d

annulus = infoXplot2d.str.roi.annulus
Widget_Control,info.wids.annulus,Set_Value=StrCompress(annulus,/Rem)

roi_text = infoXplot2d.str.roi.last
IF STrCompress(roi_text,/Rem) NE '' THEN BEGIN

nn = StrParse(roi_text,',',list)
CASE StrCompress(list[0],/Rem) OF 
   'conic': BEGIN
      Xcent=StrCompress(List[1])
      Ycent=StrCompress(List[2])
      axis1=StrCompress(List[3])
      IF nn GE 4 THEN axis2=StrCompress(List[4]) ELSE axis2=axis1
      IF nn GE 5 THEN phi=StrCompress(List[5]) ELSE phi='0.0'
      Widget_Control,info.wids.conic.Xcent,Set_Value=Xcent
      Widget_Control,info.wids.conic.Ycent,Set_Value=Ycent
      Widget_Control,info.wids.conic.axis1,Set_Value=axis1
      Widget_Control,info.wids.conic.axis2,Set_Value=axis2
      Widget_Control,info.wids.conic.phi,Set_Value=phi
      END
   'cake': BEGIN
      Xcent=StrCompress(List[1])
      Ycent=StrCompress(List[2])
      axis1=StrCompress(List[3])
      axis2=StrCompress(List[4])
      phi1=StrCompress(List[5])
      phi2=StrCompress(List[6])
      Widget_Control,info.wids.cake.Xcent,Set_Value=Xcent
      Widget_Control,info.wids.cake.Ycent,Set_Value=Ycent
      Widget_Control,info.wids.cake.axis1,Set_Value=axis1
      Widget_Control,info.wids.cake.axis2,Set_Value=axis2
      Widget_Control,info.wids.cake.phi1,Set_Value=phi1
      Widget_Control,info.wids.cake.phi2,Set_Value=phi2
      END
   'polygon': BEGIN
      cmd = StrSubstitute(roi_text,'polygon,','table=[')
      cmd = cmd+']'
      itmp=Execute(cmd)
      IF itmp NE 1 THEN BEGIN
        tmp=Dialog_Message(/Error,['xplot2d_roi_edit_updatepanels:',$
           'Error executing: ',cmd])
        RETURN
      ENDIF
      table=transpose(table)
      ; remove last point (redundant)
      nn = N_Elements(table[0,*])
      table=table[*,0:nn-2]
      Widget_Control,info.wids.tableN,Set_Value=StrCompress(nn-1,/Rem)
      Widget_Control,info.wids.polygon,Table_YSize=nn-1, $
        Set_Value=table
      END
ENDCASE
ENDIF

END ; xplot2d_roi_edit_updatepanels
;
;===============================================================================
;
PRO XPLOT2D_ROI_EDIT_Set_Tab_Current, wiD,current
IF N_Elements(current) EQ 0 THEN BEGIN
  Widget_Control,wId,Get_UValue=info
  IF Widget_Info(info.wids.xplot2d,/Valid_Id) THEN BEGIN
    Widget_Control,info.wids.xplot2d,Get_UValue=infoXplot2d
    roi_text=infoXplot2d.str.roi.last
    n=strparse(roi_text,',',list)
    IF n GE 0 THEN BEGIN
      CASE list[0] OF
       'conic': current=0
       'cake': current=1
       'polygon': current=2
      ENDCASE
    ENDIF ELSE current=0
  ENDIF ELSE current=0
ENDIF
Widget_Control,wid,Get_UValue=info
Widget_Control,info.wids.tab,Set_Tab_Current=current
END


;
;===============================================================================
;
PRO XPLOT2D_ROI_EDIT_EVENT, event

Widget_Control,event.top,Get_UValue=info
Widget_Control,event.id,Get_UValue=uval

CASE uVal OF
  'CLOSE': BEGIN
     Widget_Control,event.top,/destroy
     END
  'REFRESH': BEGIN
     id = info.wids.Xplot2d
     IF Widget_Info(id,/Valid_Id) THEN xplot2d_refresh,id
     END
  'HELP': BEGIN
     END
  'TAB': BEGIN
     END
  'CONIC': BEGIN
     Widget_Control,event.id,Get_Value=Val
     CASE val OF
     'Get...': BEGIN
          tmp = {sel:['0',$
          'circle: 2 points: center, radius', $
          'circle: 3 points on the circle', $
          'ellipse: 3 points: center,a,b', $
          'ellipse: 4 points on the unrotated ellipse', $
          'ellipse: 5 points on the ellipse']}
          XscrMenu,tmp,titles=['Get with mouse'], Action=action, $
              /NoType,/Interp, WTitle='circle/ellipse',$
              dialog_Parent=event.top ; ,FieldLen=40
          IF action EQ 'DONT' THEN RETURN
          CASE Fix((tmp.sel)[0]) OF
            0: xplot2d_roi_mouse,info.wids.xplot2d,iFlag=2
            1: xplot2d_roi_mouse,info.wids.xplot2d,iFlag=3
            2: xplot2d_roi_mouse,info.wids.xplot2d,iFlag=13
            3: xplot2d_roi_mouse,info.wids.xplot2d,iFlag=14
            4: xplot2d_roi_mouse,info.wids.xplot2d,iFlag=15
          ENDCASE
          END
     else: BEGIN
       xplot2d_roi_edit_updatestr,event.top
       xplot2d_roi_plot,info.wids.xplot2d
       END
     ENDCASE
     END

  'CAKE': BEGIN
     Widget_Control,event.id,Get_Value=Val
     CASE val OF
     'Get': BEGIN
       xplot2d_roi_mouse,info.wids.xplot2d,iFlag=23
       END
     else: BEGIN
       xplot2d_roi_edit_updatestr,event.top
       xplot2d_roi_plot,info.wids.xplot2d
       END
     ENDCASE
     END

  'TABLEY': BEGIN ; update table length when changing # vertices
      Widget_Control,event.id,Get_Value=nn
      ; BUG BUG BUG 
      ; THIS DOES NOT WORK...
      Widget_Control,info.wids.tableN,Table_YSize=Long(nn[0])+1
     END


  'POLYGON': BEGIN
     Widget_Control,event.id,Get_Value=Val
     CASE String(val[0]) OF
     'Get Rectangle': xplot2d_roi_mouse,info.wids.xplot2d,iFlag=31
     'Get Polygon': xplot2d_roi_mouse,info.wids.xplot2d,iFlag=30
     else: BEGIN
       xplot2d_roi_edit_updatestr,event.top
       xplot2d_roi_plot,info.wids.xplot2d
       END
     ENDCASE
     END

  'CROP': BEGIN
     xplot2d_crop,info.wids.xplot2d
     END

  'ANNULUS': BEGIN
     Widget_Control,event.id,Get_Value=Val
     CASE val OF
     'Plot': BEGIN
       xplot2d_roi_edit_updatestr,event.top
       xplot2d_annulus,info.wids.xplot2d
       END
     else: BEGIN
       xplot2d_roi_edit_updatestr,event.top
       END
     ENDCASE
     END

  else:
ENDCASE

END

;
;===============================================================================
;
PRO XPLOT2D_ROI_EDIT,wXplot2d,Parent=wBase

IF N_Elements(wXplot2d) EQ 0 THEN wXplot2d=0L

; inputs
  Xcent='1000.0'
  Ycent='1000.0'
  Axis1='100.0'
  Axis2='400.0'
  Phi='10.0'
  Phi2='190.0'
  Annulus=30.0

wbase=widget_base(/col,title='ROI edit ')

wtmp0 = widget_base(wbase,/Row) ; Main Buttons
  wtmp = widget_button(wtmp0,Value='Close',UValue='CLOSE')
  wtmp = widget_button(wtmp0,Value='Refresh',UValue='REFRESH')
  wtmp = widget_button(wtmp0,Value='Help',UValue='HELP')

;
; different bases
;
wTab=Widget_Tab(wbase,UVal='TAB')
  wConic=Widget_Base(wTab,Title='Conic(circle/ellipse)', Column=1)
  wCake=Widget_Base(wTab, Title='Cake', Column=1)
  wPolygon=Widget_Base(wTab, Title='Polygon', Column=1)
  wAnnulus=Widget_Base(wTab, Title='Annulus', Column=1)
  ;wList=Widget_Base(wTab, Title='List', Column=1)

;
; conic inputs
;
w1 = Widget_Base(wConic,/col,Frame=0)


wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value='Xcenter[pixel]: ')
  wXcent = Widget_Text(wtmp0,Value=Xcent,/edit,xsize=15,UVal='CONIC')
  wtmp = Widget_Label(wtmp0,Value='Ycenter[pixel]:          ')
  wYcent = Widget_Text(wtmp0,Value=Ycent,/edit,xsize=15,UVal='CONIC')
wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value='Radius/axis1:   ')
  wAxis1 = Widget_Text(wtmp0,Value=axis1,/edit,xsize=15,UVal='CONIC')
  wtmp = Widget_Label(wtmp0,Value='Axis2 (set 0 for circle):')
  wAxis2 = Widget_Text(wtmp0,Value=axis2,/edit,xsize=15,UVal='CONIC')
wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value='Phi[deg]:       ')
  wPhi = Widget_Text(wtmp0,Value=phi,/edit,xsize=15,UVal='CONIC')

wtmp0 = Widget_Base(w1,/row)
  wTMp = Widget_Button(wtmp0,Value='Plot',UValue='CONIC')
  wTMp = Widget_Button(wtmp0,Value='Get...',UValue='CONIC')

wConic={XCent:wXcent,Ycent:wYcent, axis1:wAxis1,axis2:waxis2,phi:wPhi}

;
; cake inputs
;
w1 = Widget_Base(wCake,/col,Frame=0)


wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value='Xcenter[pixel]: ')
  wXcent = Widget_Text(wtmp0,Value=Xcent,/edit,xsize=15,UVal='CAKE')
  wtmp = Widget_Label(wtmp0,Value='Ycenter[pixel]: ')
  wYcent = Widget_Text(wtmp0,Value=Ycent,/edit,xsize=15,UVal='CAKE')
wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value='Lower radius:   ')
  wAxis1 = Widget_Text(wtmp0,Value=axis1,/edit,xsize=15,UVal='CAKE')
  wtmp = Widget_Label(wtmp0,Value='Upper radius:   ')
  wAxis2 = Widget_Text(wtmp0,Value=axis2,/edit,xsize=15,UVal='CAKE')
wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value='Internal angle [deg]:       ')
  wPhi1 = Widget_Text(wtmp0,Value=phi,/edit,xsize=15,UVal='CAKE')
  wtmp = Widget_Label(wtmp0,Value='External angle [deg]:       ')
  wPhi2 = Widget_Text(wtmp0,Value=phi2,/edit,xsize=15,UVal='CAKE')

wtmp0 = Widget_Base(w1,/row)
  wTMp = Widget_Button(wtmp0,Value='Plot',UValue='CAKE')
  wTMp = Widget_Button(wtmp0,Value='Get',UValue='CAKE')

wCake={XCent:wXcent,Ycent:wYcent, axis1:wAxis1,axis2:waxis2, $
       phi1:wPhi1,phi2:wPhi2}


;
; polygon inputs
;
w1 = Widget_Base(wPolygon,/col,Frame=0)

wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value=' Number of polygon vertices: ',$
	UValue='TABLEY')
  wTableN = Widget_Text(wtmp0,Value=StrCompress(3,/Rem), $
	/edit,xsize=15,UValue='TABLEY')
tmp = Make_Set([100.0,300,200],[100,100,300])
wPolygon = Widget_Table (w1, xsize=2, ysize=10, $
           value=tmp, /Editable, All_Events=0, /Scroll, $
           column_labels=['X','Y'], UValue='POLYGON'  $
           ;,scr_xsize=80, scr_ysize=200)
           )
wtmp0 = Widget_Base(w1,/row)
  wTMp = Widget_Button(wtmp0,Value='Plot',UValue='POLYGON')
  wTMp = Widget_Button(wtmp0,Value='Get Rectangle',UValue='POLYGON')
  wTMp = Widget_Button(wtmp0,Value='Get Polygon',UValue='POLYGON')
  wTMp = Widget_Button(wtmp0,Value='Crop Image',UValue='CROP')


;
; annulus inputs
;
w1 = Widget_Base(wAnnulus,/col,Frame=0)

  wtmp = Widget_Label(w1,Value=' This option defines an annulus around a conic or polygonal ',/Align_Left)
  wtmp = Widget_Label(w1,Value=' Selection. Make first a conic or polygonal selection, and ',/Align_Left)
  wtmp = Widget_Label(w1,Value=' define here the annulus width in pixels',/Align_Left)
  wtmp = Widget_Label(w1,Value=' (hit <return> to apply)',/Align_Left)

wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value='Annulus width [pixels]:       ')
  wAnnulus = Widget_Text(wtmp0,Value=StrCompress(annulus,/Rem),/edit,xsize=15,UVal='ANNULUS')

wtmp0 = Widget_Base(w1,/row)
  wTMp = Widget_Button(wtmp0,Value='Plot',UValue='ANNULUS')


wids={xplot2d:wXplot2d, Tab: wTab, $
     conic:wConic,cake:wCake, tableN:wTableN, polygon:wPolygon, annulus:wAnnulus}

info={wids:wids}

Widget_Control,wBase,set_uvalue=info,/Realize

xplot2d_roi_edit_updatepanels,wbase

xmanager, 'XPLOT2D_ROI_EDIT',wbase,GROUP=wXplot2D,/NO_BLOCK 

END

