PRO Xop_PrintEnv

;+
; NAME:
;       XOP_PRINTENV
;
; PURPOSE:
;       Prints all keys (variable names) stored in the "silo" buffer for MacOS.
;       Not implemented on other platforms.
;
; CATEGORY:
;       XOP
;
; CALLING SEQUENCE:
;       Xop_PrintEnv
;
; INPUTS:
;
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;       Prints all keys (variable names) stored in the "silo" buffer.
;
; SIDE EFFECTS:
;
; PROCEDURE:
;       Uses a common block to store the object reference.
;       The "silo" buffer uses keys (variable names) that are case insensitive.
;       The stored data (values) are case sensitive.
;
; COMMON BLOCKS
;       COMMON xop_env, silo
;
; EXAMPLES:
;       Xop_PrintEnv
;
; MODIFICATION HISTORY:
;       Written by: Roger J. Dejus (dejus@aps.anl.gov) 01/29/99.
;       Uses a "silo" buffer: An object data storage mechanism written by
;       Robert.Mallozzi@msfc.nasa.gov
;-

COMMON xop_env, silo

IF SDep() NE 'MACOS' THEN BEGIN
  Message, /Continue, 'Routine not implemented for ' +SDep()
  RETURN
ENDIF

IF Obj_Valid(silo) THEN silo->Print ELSE Message, /Continue, 'SILO buffer not defined'
  
RETURN
END
