FUNCTION voigt1,x,a1,area=area
;+
; NAME:
;	VOIGT1 
; PURPOSE:
;	Returns the value of a pseudo-voigt function (a combination of
;	lorentzian and gaussian functions)
; CATEGORY:
;	Mathematics.
; CALLING SEQUENCE:
;	Result = voigt1(x,a)
; INPUTS:
;	x: the argument for the function (number or array)
;	a: array with the function coefficients:
;		a[0] Amplitud
;		a[1] Center
;		a[2] Full Width at Half Maximum
;		a[3] Ratio between lorentzian and Gaussisan (1=Pure
;			lorentzian, 0=Pure Gaussian, 0.5=half each)
;
; KEYWORD PARAMETERS
;	area: set this keyword to make pseudovoigt as sum of Gaussian
;       and Lorentzian with equal area. The pseudovoight area is a[0]. By
;       default (area=0) the Gaussian and Lorentzians have the same amplitude. 
;
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Easy (see source).
; MODOFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble 26 May 1996
;	97/10/20 srio@esrf.fr corrects a bug in Gaussian width.
;	2007-03-07 srio@esrf.fr makes all calculations in double. Adds
;		Area keyword.
;
;-

; a(0) amplittud
; a(1) center
; a(2) FWHM
; a(3) ratio lorentian/gaussian

a=Double(a1)

xx = Double(x)-a[1]
;
; gaussian and lorentzian normalized to 1 in amplitude
;
lor = 1.0D + (xx/(0.5D0*a[2]))^2
gau = exp( - (xx*2.0D0*sqrt(alog(2.0D0))/a[2])^2 )

IF Keyword_Set(area) THEN BEGIN
  res = (a[3]/lor/!dpi*2+(1D0-a[3])* gau * sqrt(4D*alog(2D0)/!dpi) )*a[0]/a[2]
ENDIF ELSE BEGIN
  res = (a[3]/lor + (1D0 - a[3])* gau )*a[0]
ENDELSE
return,res
end

