function HISTOGRAMW,arr1,wei,binsize=p_binsize,max=p_max,min=p_min, $
  input=hinput,omax=omax,omin=omin,xval=xval, nbins=nbins, $
  method=method,_Extra=extra

;+
; NAME:
;	HISTOGRAMW
; PURPOSE:
;	Same as HISTOGRAM, but weighted by wei array
; CATEGORY:
;	General
; CALLING SEQUENCE:
;	a= HISTOGRAMW(arr,wei,keywords)
; INPUTS:
;	ARR name of the array with data
; OPTIONAL INPUT PARAMETERS:
;	WEI name of the array with weigths 
;	None.
; KEYWORD PARAMETERS:
;	BINSIZE
;	The size of the bin to use. If this keyword is not specified, a bin size
;	of 1 is used.
;	
;	MAX
;	is the maximum value to consider. If this keyword is not specified,
;	Array is searched for its largest value.
;	
;	MIN
;	is the minimum value to consider. If this keyword is not specified,
;	and Array is of type byte, 0 is used. If this keyword is not specified
;	and Array is not of byte type, Array is searched for its smallest value.
;	
;	OMAX
;	A named variable that, upon exit, contains the maximum data value used
;	in constructing the histogram.
;	
;	OMIN
;	A named variable that, upon exit, contains the minimum data value used
;	in constructing the histogram.
;	
;	INPUT
;	Set this keyword to a named variable that contains an array to be added
;	to the output of HISTOGRAM. The density function of Array is added to
;	the existing contents of INPUT and returned as the result. The array is
;	converted to longword type if necessary and must have at least as many
;	elements as are required to form the histogram.
;	Multiple histograms can be efficiently accumulated by specifying partial
;	sums via this keyword.
;
;	XVAL 
;	Set this keyword to a named variable that contains an array with the
;	x(abscissas) values for the histogram
;
;	NBINS 
;	Set this keyword to a number of bins  desired for the plot. If
;	this keyword is set, the binsize kw is irrelevant.
;
;       METHOD
;	Calculation method: 0 (default) it uses histogramw
;			    1 (old) old method. It should be avoided. Kept
;				for testing and debugging purposes only.
;
; OUTPUTS:
;	Density function of ARR (see HISTOGRAM, IDL Users' Guide B-49)
; OPTIONAL OUTPUT PARAMETERS:
;	Same as HISTOGRAM.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward.
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble May 1991
;	94-09-27 MSR change keyword_set by n_elements when checking the
;		existence of the min and max keywords. This allows the
;		program when for example min=0, otherwise takes the
;		0 as keyword not defined and recalculates the value.
;	95-02-14 MSR Puts wei as OPTIONAL input parameter
;	96-05-13 MSR speeds it up. Adds O[MIN,MAX], INPUT, NBINS and XVAL 
;		keywords.
;	06-02-21 srio@esrf.fr calculations in double
;	07-06-12 srio@esrf.fr rewrites using histogram() Added METHOD
;		keyword.
;	08-09-09 srio@esrf.eu Bug fixed: arr was changed if cut.
;-
on_error,2
IF N_Elements(method) EQ 0 THEN method = 0

arr=arr1
if n_params() EQ 1 then wei=replicate(1.D0,n_elements(arr)) 

; new data considering limits
icut = 0
if (n_elements(p_max) ne 0) then begin
  nmax = double(p_max) 
  icut = 1
endif else nmax = max (arr)
if (n_elements(p_min) ne 0) then begin
  nmin = double(p_min) 
  icut = 1
endif else nmin = min (arr)
if icut then begin
  flg =  where( (arr GE nmin) AND (arr LE nmax) )
  IF flg[0] NE -1 THEN arr = arr( flg )
  IF flg[0] NE -1 THEN wei = wei( flg )
endif


nelem = n_elements(arr)


;help,method
CASE method OF

   0: BEGIN ; using IDL built-in Histogram
      hy = histogram(arr,omax=omax,omin=omin, $
           min=p_min,max=p_max, Location=xval, $
           binsize=p_binsize, nbins=nbins, Reverse_Indices=ri )
      ; apply weights
      if n_params() EQ 2 then begin
        hy = Double(hy)
        FOR i=0L,N_Elements(hy)-1 DO BEGIN
           IF ri[i] NE ri[i+1] THEN igood = ri[ ri[i]:ri[i+1]-1 ] ELSE $
	       continue
           hy[i] = Total(wei[igood])
        ENDFOR
      endif
      ; added to input veriable
      IF N_Elements(hinput) NE 0 THEN BEGIN
         IF N_Elements(hinput) NE N_Elements(hy) THEN $
            Message,'Incompatible number of elements of INPUT keyword and HISTOGRAM'
         hy = hinput+hy
      ENDIF

      END
   1: BEGIN ; using OLD method
      if keyword_set(p_binsize) then binsize = p_binsize else binsize = 1
      if keyword_set(nbins) then  begin
        binsize =   Double( (nmax - nmin) /nbins )
      endif else begin
        nbins = Double ( round( (nmax - nmin) /binsize) )
      endelse


      if ((n_elements(omax) NE 0) OR (n_elements(omin) NE 0)) then $
	  omax=max(arr,min=omin)
      if n_elements(hinput) EQ 0 then begin
         hy = dblarr (nbins)  ; if not input set
      endif else begin
         hy = hinput
      endelse
      ;if n_elements(xval) NE 0 then $
	xval = nmin + dindgen(nbins)/(nbins-1)*(nmax-nmin)

      hwarr = long( (arr-nmin)/binsize ) < (nbins-1)
      for ii=0L,nelem-1 do begin
        hw = hwarr(ii) 
        hy(hw) = hy(hw) + wei(ii)
      endfor

      END
   else: Message, 'Method not correctly defined'
ENDCASE

;print,'----In histogramw: '
;help,xval,hy
;print,'----'
return, hy
end
