;
; This file contains code used internally by xurgent.pro
; MSR 99-03-16
;
FORWARD_FUNCTION sdep


;
;=======================================================================
;
FUNCTION XUrgent_Description
;
; give description of the input structure
;
On_Error,2
;
res = [ ' Title:  ' 			$
;
  ,'Energy (GeV)'	$
  ,'Current (A)'		$
  ,'RMS beam size (mm)  Horiz (X):'	$
  ,'Vert (Y)'	$
  ,'RMS divergences (mrad) Horiz (X)'	$
  ,'Vert (Y)'	$
;
  ,'Undulator type'		$
  ,'magnet period (m)'		$
  ,'number of periods'		$
  ,'Horizontal K'			$
  ,'Vertical K'			$
  ,'Phase (deg)'		$
;
  ,'From energy (eV)'	$
  ,'To energy (eV)'		$
  ,'number of points'		$
;
  ,'Undul-screen distance [0=Angle] (m)'	$
  ,'Observation position H [XPC]: '	$	
  ,'V [YPC]'	$
  ,'Acceptance H [XPS] '	$
  ,'V [YPS] '	$
  ,'Mesh grid. Number of points Horiz:'	$
  ,'Vert: '	$
;
  ,'MODE'			$	
  ,'ICALC'			$
  ,'IHARM' 		$
;
  ,'NPHI -   (see help)'			$
  ,'NSIG -   (see help)'			$
  ,'NALPHA - (see help)'			$
  ,'DALPHA - (see help)'			$
  ,'NOMEGA - (see help)'			$
  ,'DOMEGA - (see help)']

RETURN,res
END ;  XUrgent_Description
;
;===========================================================================
;
FUNCTION XUrgent_UpdateStr,strinp,wids,Group=group
;
on_error,2
str=strinp
tnames = Tag_Names(str)
ntags = N_Tags(str)

tmp=''
FOR i=0,ntags-1 DO BEGIN
  IF Widget_Info(wids.(i),/Valid_Id) THEN BEGIN
    Widget_Control,wids.(i),Get_Value=tmp
    CASE StrUpcase(tnames[i]) OF
      'ITYPE':  BEGIN
	str.itype = Fix(tmp[0])+1
	END
      'MODE':  BEGIN
	str.mode = Fix(tmp[0])+1
	IF str.mode EQ 7 THEN str.mode=-6
	END
       else: BEGIN
	tmp1 = str.(i)
	tmp1 = tmp[0]
	str.(i) = tmp1
	END
    ENDCASE
  ENDIF
ENDFOR
RETURN,str
END ; XUrgent_UpdateStr

;
;===========================================================================
;
PRO XUrgent_MapPanels,str,wids,Group=group
;
On_Error,2
;
; ITYPE
;
; und - cross undul
tmp=''
Widget_Control,wids.itype,Get_Value=tmp
CASE StrCompress(tmp[0],/Rem) OF
 '0': BEGIN
 	;Widget_Control,wids.kx,Map=0
 	Widget_Control,wids.phase,Map=0
	END
 '1': BEGIN
 	;Widget_Control,wids.kx,Map=1
 	Widget_Control,wids.phase,Map=1
	END
ENDCASE

;
; D
;
Widget_Control,wids.d,Get_Value=tmp
IF tmp[0] EQ 0 THEN BEGIN
  Widget_Control,wids.units1,Set_Value='(mrad)' 
  Widget_Control,wids.units2,Set_Value='(mrad)' 
ENDIF ELSE BEGIN
  Widget_Control,wids.units1,Set_Value=' (mm) ' 
  Widget_Control,wids.units2,Set_Value=' (mm) ' 
ENDELSE


;
; MODE, ICALC, IHARM
;
Widget_Control,wids.mode,Get_Value=tmp
Widget_Control,wids.emax,Map=1
Widget_Control,wids.emax,Map=1
Widget_Control,wids.nenergy,Map=1
;
Widget_Control,wids.xps,Map=1
Widget_Control,wids.yps,Map=1
Widget_Control,wids.nxp,Map=1
Widget_Control,wids.nyp,Map=1
;
Widget_Control,wids.d,Map=1
Widget_Control,wids.xpc,Map=1
Widget_Control,wids.ypc,Map=1

icalc14=['ICALC=1 non-zero emittance, finite N;  ICALC=2 non-zero emittance, infinite N',$
	'ICALC=3 zero emittance, finite N']

;
;icalc
icalc=0
Widget_Control,wids.icalc,Get_Value=icalc
Widget_Control,wids.iharm,Map=1


CASE StrCompress(tmp[0],/Rem) OF
  '0': BEGIN ; MODE=1
	mode=1
	h1=$
	'MODE=1 angular/spatial flux density distribution at photon energy EMIN'
	h1=[h1,icalc14]
 	Widget_Control,wids.emax,Map=0
 	Widget_Control,wids.nenergy,Map=0
	END
  '1': BEGIN ; MODE=2
	mode=2
	h1=$
	'MODE=2 spectrum of angular/spatial flux density at position XPC, YPC'
	h1=[h1,icalc14]
	Widget_Control,wids.xps,Map=0
	Widget_Control,wids.yps,Map=0
	Widget_Control,wids.nxp,Map=0
	Widget_Control,wids.nyp,Map=0
	END
  '2': BEGIN ; MODE=3
	mode=3
	h1=$
	'MODE=3 spectrum of on-axis brightness.'
	h1=[h1,icalc14]
	Widget_Control,wids.d,Map=0
	Widget_Control,wids.xpc,Map=0
	Widget_Control,wids.ypc,Map=0
	Widget_Control,wids.xps,Map=0
	Widget_Control,wids.yps,Map=0
	Widget_Control,wids.nxp,Map=0
	Widget_Control,wids.nyp,Map=0
	END
  '3': BEGIN ; MODE=4
	mode=4
	h1=$
	'MODE=4 spectrum of flux integrated over the defined range of acceptance.'
	h1=[h1,icalc14]
	END
  '4': BEGIN ; MODE=5
	mode=5
	h1=[$
	'MODE=5 spectrum of flux integrated over all angles',$
	'ICALC=1 finite N; ICALC=2 infinite N']
	Widget_Control,wids.d,Map=0
	Widget_Control,wids.xpc,Map=0
	Widget_Control,wids.ypc,Map=0
	Widget_Control,wids.xps,Map=0
	Widget_Control,wids.yps,Map=0
	Widget_Control,wids.nxp,Map=0
	Widget_Control,wids.nyp,Map=0
 	Widget_Control,wids.help1,Set_Value=h1
	END
  '5': BEGIN ; MODE=6
	mode=6
	h1=[$
	'MODE=-6 angular/spatial distribution of power density in a given harmonic or range of ', $
	'harmonics; central power density and integrated power over the range of acceptance, listed',$
	'for each harmonic ',$
	'ICALC=1 non-zero emittance ICALC=2 zero emittance']
	Widget_Control,wids.emin,Map=0
	Widget_Control,wids.emin,Map=0
	Widget_Control,wids.emax,Map=0
	Widget_Control,wids.nenergy,Map=0
	END
  '6': BEGIN ; MODE=-6
	mode=-6
	h1=[$
	'MODE=-6 angular/spatial distribution of power density in a given harmonic or range of ', $
	'harmonics; central power density and integrated power over the range of acceptance, listed',$
	'for each harmonic ',$
	'ICALC=1 non-zero emittance ICALC=2 zero emittance']
	Widget_Control,wids.emin,Map=0
	Widget_Control,wids.emax,Map=0
	Widget_Control,wids.nenergy,Map=0
	END
  else:
ENDCASE


h2=''
IF icalc LE 2 AND mode GE 1 AND mode LE 5 THEN BEGIN
   h2=[$     
	'IHARM=-1 include all harmonics contributing at a given point and given photon energy',$
	'IHARM=0 use only the lowest order contributing harmonic',$
	'IHARM=i use only the i-th harmonic']
ENDIF

IF icalc EQ 3 AND mode GE 1 AND mode LE 4 THEN BEGIN
  Widget_Control,wids.iharm,Map=0
ENDIF

IF mode EQ 6 THEN BEGIN
  h2=[$
	'IHARM=i  angular/spatial distribution of power density for harmonic i',$
	'IHARM=-i include all harmonics from 1 to i',$
	'  angular/spatial distribution of power density for sum of harmonics',$
	'+ central power density and integrated power for each i',$
	'IHARM=0  include harmonics up to some limit determined by the program',$
	'  angular/spatial distribution of power density for sum of harmonics',$
	'+ central power density and integrated power for each i']

ENDIF

IF mode EQ -6 THEN BEGIN
  h2=[$
	'IHARM=i  angular/spatial distribution of power density for harmonic i',$
	'IHARM=-i include all harmonics from 1 to i',$
	'  angular/spatial distribution of power density for each harmonic',$
	'+ angular/spatial distribution of power density for sum of harmonics',$
	'+ central power density and integrated power for each i',$
	'IHARM=0  include harmonics up to some limit determined by the program',$
	'  angular/spatial distribution of power density for each harmonic',$
	'+ angular/spatial distribution of power density for sum of harmonics',$
	'+ central power density and integrated power for each i']
ENDIF


Widget_Control,wids.help1,Set_Value=[h1,h2]

END ; XUrgent_MapPanels

;
;===============================================================================
;
PRO XUrgent_Set_Event, event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
     'XURGENT_SET_EVENT: error caught: '+!error_state.msg)
   Catch, /Cancel
   On_Error,2
   GoTo,out
   RETURN
ENDIF


Widget_Control, event.id, get_UValue=eventUValue
Widget_Control, event.id, get_Value=Value
 
if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''
 
stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy
 
Case eventUValue OF
    'ACCEPT': BEGIN
	*(state.ptrAction)='ACCEPT'
	tmp = XUrgent_UpdateStr(*(state.ptrStr),state.wids,Group=event.top)
	*(state.ptrStr)=tmp
	Widget_Control,event.handler,/destroy
	END
    'CANCEL': BEGIN
	Widget_Control,event.handler,/destroy
	END
    'HELP': BEGIN
	ds = SDep(/DS)
	XDisplayFile1,Xop_GetEnv('XOP_HOME')+ds+$
	  "doc"+ds+"txt"+ds+"urgent_par.txt"
	END
    'UPDATE': BEGIN
	str = *(state.ptrStr)
	wids = state.wids
	XUrgent_MapPanels,str,wids,Group=event.top
	END
    'ADVANCED': BEGIN
	str = *(state.ptrStr)
	tmp = {nphi:str.nphi,nsig:str.nsig,$
	  nalpha:str.nalpha,dalpha:str.dalpha,$
	  nomega:str.nomega,domega:str.domega}
	ds = SDep(/ds)
	helpcmd = "xdisplayfile1,'"+Xop_GetEnv('XOP_HOME')+ds+$
	  "doc"+ds+"xurgent2.par',group=event.top,/NoMenuBar"
	action=''
	XScrMenu,tmp,Action=action, /NoType,Help=helpcmd,$
	  Wtitle='Urgent advanced setting',NCol=3
	IF (action EQ 'DONT') THEN GoTo,out
	Copy_Structure,tmp,str
	*(state.ptrStr)=str
	END
    'JOB': BEGIN
	tmp = event.value
	*(state.ptrJob)=tmp
	END

    else: message,/info,'Case not found: '+eventUValue
EndCase

out:
IF Type(stateid) EQ 3 THEN $
  IF Widget_Info(stateid,/Valid_ID) THEN $
  Widget_Control, stateid, Set_UValue=state, /No_Copy

END ; XURGENT_SET_EVENT

;
;===============================================================================
;
PRO XUrgent_Set, str, Action=action, Group=group, Job=job

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XURGENT_SET: error caught: '+!error_state.msg)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

IF N_Elements(str) EQ 0 THEN str = Xop_Defaults('xurgent')
tnames = Tag_names(str)
ntnames = N_elements(tnames)

;
; create wids structure
;
tmp = '0L'
;FOR i=1,ntnames-1 DO tmp = tmp +',0L'
FOR i=1,ntnames+2 DO tmp = tmp +',0L'
wids=0
cmd = "wids = Create_Struct([tnames,'help1','units1','units2'],"+tmp+")"
itmp = Execute(cmd)

;
; create tts (titles) structure
;
tmp = "''"
FOR i=1,ntnames-1 DO tmp = tmp +",''"
tts=0
cmd = 'tts = Create_Struct(tnames,'+tmp+')'
itmp = Execute(cmd)
tmp = XUrgent_Description()
For i=0,ntnames-1 DO tts.(i)=tmp[i]

IF N_Elements(group) NE 0 THEN BEGIN
  wBase=Widget_Base(/Col,Title='XURGENT input parameters',/Modal,$
        Group_Leader=group,/Floating,TLB_Frame_attr=9)
ENDIF ELSE BEGIN
  Text = ['Unless you are calling XURGENT_SET from the command line, the',$
   'GROUP keyword MUST be used for modal operation.',$
   'Please modify your code if neccesary.']
  itmp = Dialog_Message(Dialog_Parent=group,text)
  wBase=Widget_Base(/Col,Title='XURGENT input parameters')
ENDELSE

wtmp = widget_base(wbase) ; to store state

fsize=10
isize=4

;  Control buttons
wtmpb = Widget_Base(wBase, /Row)
wtmp  = Widget_Button(wtmpb, Value='Accept', UValue='ACCEPT')
wtmp  = Widget_Button(wtmpb, Value='Cancel', UValue='CANCEL')
wtmp  = Widget_Button(wtmpb, Value='Help', UValue='HELP')

;  Title information
wtmpb = Widget_Base(wBase, Row=1, /Frame)
  wids.title = CW_Field(wtmpb, TITLE=tts.title, VALUE=str.title, /Row, XSize=80)

;  Machine Parameters
wtmpb = Widget_Base(wBase, /Col, /Frame)
  wtmp = Widget_Label(wtmpb, Value='** Electron beam (Machine Parameters)',$
	/Align_Left)
  wtmp1 = Widget_Base(wtmpb, /Row)
    wids.energy = CW_Field(wtmp1, Title=tts.energy, Value=str.energy, /Float,$
	XSize=fsize)
    wids.cur    = CW_Field(wtmp1, Title='Current (A)', Value=str.cur, /Float,$
	XSize=fsize)
  wtmp1 = Widget_Base(wtmpb, /Row)
    wids.sigx  = CW_Field(wtmp1, Title=tts.sigx, Value=str.sigx, /Float,$
	XSize=fsize)
    wids.sigy  = CW_Field(wtmp1, Title=tts.sigy, Value=str.sigy, /Float,$
	XSize=fsize)
  wtmp1 = Widget_Base(wtmpb, /Row)
    wids.sigx1  = CW_Field(wtmp1, Title=tts.sigx1, Value=str.sigx1, /Float,$
	XSize=fsize)
    wids.sigy1  = CW_Field(wtmp1, Title=tts.sigy1, Value=str.sigy1, /Float,$
	XSize=fsize)

;  Undulator Parameters
wtmpb = Widget_Base(wBase, /Col, /Frame)
  wtmp = Widget_Label(wtmpb, Value='** Undulator Parameters  ',/Align_Left)
  wtmp1 = Widget_Base(wtmpb, /Row)
    wtmp  = Widget_label(wtmp1, Value=tts.itype, /Align_Left)
    tmp = [StrCompress(str.itype-1,/Rem),'Plane/helical/elliptical','Crossed']
    wids.itype  = CW_DropList(wtmp1, Value=tmp,UValue='UPDATE')
    wids.period  = CW_Field(wtmp1, Title=tts.period, Value=str.period, /Float,$
	XSize=fsize)
    wids.N  = CW_Field(wtmp1, Title=tts.N, Value=str.N, /Int,$
	XSize=isize)
  wtmp1 = Widget_Base(wtmpb, /Row)
    wids.kx  = CW_Field(wtmp1, Title=tts.kx, Value=str.kx, /Float,$
	XSize=fsize)
    wids.ky  = CW_Field(wtmp1, Title=tts.ky, Value=str.ky, /Float,$
	XSize=fsize)
    wids.phase  = CW_Field(wtmp1, Title=tts.phase, Value=str.phase, /Float,$
	XSize=fsize)

;  Scan Parameters
wtmpb = Widget_Base(wBase, /Col, /Frame)
  wtmp = Widget_Label(wtmpb, Value='** Scan Parameters  ',/Align_Left)
  wtmp1 = Widget_Base(wtmpb, /Row)
    wids.emin  = CW_Field(wtmp1, Title=tts.emin, Value=str.emin, /Float,$
	XSize=fsize)
    wids.emax  = CW_Field(wtmp1, Title=tts.emax, Value=str.emax, /Float,$
	XSize=fsize)
    wids.nenergy  = CW_Field(wtmp1, Title=tts.nenergy, Value=str.nenergy,$
	/Int,XSize=isize)

;  Observation Parameters
wtmpb = Widget_Base(wBase, /Col, /Frame)
  wtmp = Widget_Label(wtmpb, Value='** Observation slit/screen  ',/Align_Left)
  wtmp1 = Widget_Base(wtmpb, /Row)
    wids.d  = CW_Field(wtmp1, Title=tts.d, Value=str.d, /Float,$
	XSize=fsize,/All_Events,UValue='UPDATE')
    wids.nxp  = CW_Field(wtmp1, Title=tts.nxp, Value=str.nxp, /Int,$
	XSize=isize)
    wids.nyp  = CW_Field(wtmp1, Title=tts.nyp, Value=str.nyp, /Int,$
	XSize=isize)
  wtmp1 = Widget_Base(wtmpb, /Row)
    wtmp = Widget_Label(wtmp1, Value=tts.xpc,/Align_Left)
    wids.units1 = Widget_Label(wtmp1, Value='(mrad)',/Align_Left)
    wids.xpc  = CW_Field(wtmp1, Title=' ', Value=str.xpc, /Float,$
	XSize=fsize)
    wtmp = Widget_Label(wtmp1, Value=tts.ypc,/Align_Left)
    wids.ypc  = CW_Field(wtmp1, Title=' ', Value=str.ypc, /Float,$
	XSize=fsize)
  wtmp1 = Widget_Base(wtmpb, /Row)
    wtmp = Widget_Label(wtmp1, Value=tts.xps,/Align_Left)
    wids.units2 = Widget_Label(wtmp1, Value='(mrad)',/Align_Left)
    wids.xps  = CW_Field(wtmp1, Title=' ', Value=str.xps, /Float,$
	XSize=fsize)
    wtmp = Widget_Label(wtmp1, Value=tts.yps,/Align_Left)
    wids.yps  = CW_Field(wtmp1, Title=' ', Value=str.yps, /Float,$
	XSize=fsize)

;  Calculation Parameters
wtmpb = Widget_Base(wBase, /Col, /Frame)
  wtmp = Widget_Label(wtmpb, Value='** Calculation Parameters  ',/Align_Left)
  wtmp1 = Widget_Base(wtmpb, /Row)
    IF str.mode EQ -6 THEN tmp=6 ELSE tmp=(str.mode)-1
    tmp=[StrCompress(tmp,/Rem),'1: ang/spat flux@ Emin',$
	'2: ang/spat flux@ XPC,YPC','3: on-axis brightness',$
	'4: Flux on an apertute','5: Integrated flux',$
	'6: Ang/Spatial power','-6: Ang/Spatial power']
    wtmp  = Widget_Label(wtmp1, Value=tts.mode, /Align_Left)
    wids.mode  = CW_DropList(wtmp1, Value=tmp, UValue='UPDATE')
    wids.icalc  = CW_Field(wtmp1, Title=tts.icalc, Value=str.icalc, /Int,$
	XSize=isize,/All_Events,UValue='UPDATE')
    wids.iharm  = CW_Field(wtmp1, Title=tts.iharm, Value=str.iharm, /Int,$
	XSize=isize)
    wtmp  = Widget_Button(wtmp1, Value='Advanced...', UValue='ADVANCED')
  wtmp1 = Widget_Base(wtmpb, /Row)
    wids.help1 = Widget_Text(wtmp1, Value='Help1:',YSize=6,XSize=90,/Scroll)
  IF N_Elements(job) EQ 0 THEN job=0
  IF job LT 0 THEN job=0
  IF SDep() EQ 'UNIX' THEN BEGIN
    wtmp1 = Widget_Base(wtmpb, /Row)
      wtmp = CW_Bgroup(wtmp1,['Foreground','Background'],/Exclusive,$
	Label_Left='Job in: ',/Return_Index,/Row,UValue='JOB',Set_Value=job,$
	/No_Release)
  ENDIF

ptrStr = Ptr_New(str)
action='CANCEL'
ptrAction = Ptr_New(action)
ptrJob = Ptr_New(job)
state = {wids:wids, ptrStr:ptrStr, ptrAction:ptrAction, ptrJob:ptrJob }

Widget_Control,Widget_Info(wBase,/Child),Set_UValue=state,/No_Copy

Widget_Control,wbase,/Realize
XUrgent_MapPanels,*ptrStr,wids

XManager,'xurgent_set',wBase,GROUP=group

IF *ptrAction EQ 'ACCEPT' THEN BEGIN
  action='ACCEPT'
  str = *ptrStr
  job = *ptrJob
ENDIF

IF Ptr_Valid(ptrAction) THEN Ptr_Free,ptrAction
IF Ptr_Valid(ptrStr) THEN Ptr_Free,ptrStr
IF Ptr_Valid(ptrJob) THEN Ptr_Free,ptrJob

END ; XUrgent_Set
