;+
;=============================   Xcrystal_bent   ===============================
;
;
;  Xcrystal_bent is a common widget based graphical interface to different
;  codes that perform curved crystal diffraction calculations.
;
;  The idea is to perform bent crystal calculations with different
;  modules (computer codes) using the same interface. The different 
;  modules use different theories. The initial considered theories are:
;
;  1) Lamellar theory.  
;  2) Penning Polder theory.  
;  3) Takagi-Taupin theory. 
;  In addition, and for comparison purposes, a module to calculate
;  flat perfect crystals, based on the Zachariasen's theory has been
;  included. For FLAT crystals calculations it is recommended to use
;  the xcrystal application in XOP>
;
;  Plase note that:
;    The Penning-Polder model is only available for LAUE crystals
;    The Takagi-Taupin model is under testing for BRAGG crystals, and
;	it may not produce correct results.
;
;  XCrystal_bent uses the codes crystal_za (Zachariasen), crystal_ml 
;  (Multi-lamellar) crystal_pp (Penning-Polder) and crystal_tt (Takagi-Taupin).
;
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  File:
;    xcrystal_bent input parameters: This option allows to save the current
;		parameters to a file for later loading. It also allows
;		to save the current parameters as defaults for being
;		used when the application is initialized. In the last
;		case, the file is named "application".xop (where 
;		"application " is the name of the current XOP
;		application) and is written in the directory pointed
;		by the XOP_DEFAULTS_DIR environment variable (which
;		must be set). The parameter file is ASCII and can be
;		read and edited with care.
;  Quit: to exit from the program
;
; Set_Parameters:
;  Set Parameters: to define the parameters for the calculation.
;		The same result is obtained pressing the "Set Parameters"
;		button in the main crystal_bent window. 
;               Please refer to the information under the HELP
;		button for a complete description of the parameters. After 
;		pressing the ACCEPT button, the corresponding code starts 
;		running.
;  Set Defaults: Sets the default parameters.
;  Takagi-Taupin specific parameters: two items (Set Parameters &
;		Set Defaults) allows to define the specific parameters
;		for Takagi-Taupin calculations. They are placed in different
;		windows to allow a too complicated main window.
;
;  Show: Plot, View or Print the results.
;    Diffraction Curves: display calculated diffraction curves.
;    Bent Crystal Parameters: shows numerical parameters of the 
;		calculations.
;    Crystallographic Parameters: shows numerical parameters used
;		for the calculation of the crystal structure factor.
;    Takagi-Taupin: Some specific outputs only available if using
;		the Takagi-Taupin theory.
;        Integration Network: Shows the integration network with the
;		electric field corresponding to y=0. 
;		This option is only available when the calculations is 
;		requested in the TAKAGI-TAUPIN/SET PARAMETERS option.
;        All Reflectivity Curves: Shows an array of diffraction
;		profiles corresponding, each one, to one knot in the 
;		incident surface.
;		This option is useful to check that the "window" parameter 
;		is large enough to avoid border effects in the main (central) 
;		diffraction profile.
;		This option is only available when the calculations is 
;		requested in the TAKAGI-TAUPIN/SET PARAMETERS option.
;
;  Help:   Shows the xcrystal_bent help (this text).
;
;
;
;  COPYRIGHT:
; 	XCRYSTAL_BENT belongs to XOP package and it is distributed within XOP.
; 	PLEASE REFER TO THE XOP COPYRIGHT NOTICE
; 
;  REFERENCE:
; 	Published calculations made with XOP should refer:
; 
; 	M. Sanchez del Rio and R. J. Dejus 
;         "Status of XOP: an x-ray optics software toolkit"
;         SPIE Proceedings Vol. 5536 (2004) pp.171-174
; 
;         http://dx.doi.org/10.1117/12.560903
; 
;	In addition, published calculations with the xcrystal_bent aplication 
;	should also cite:
;	  M. Sanchez del Rio, C. Ferrero and V. Mocella. 
;	  "Computer simulations of bent perfect crystal diffraction profiles" 
;	  SPIE proceedings vol. 3151, pp.312-323, 1997. 
;
;  LAST MODIFICATION: srio@esrf.eu 2008-02-01
; 
; 
;-
; ----------------------------------------------------------------------
;
;       Modification history:
;		97/01/03 srio@esrf.fr creates the initial version.
;			This version obsoletes xreflex and xpenpol.
;		97/01/17 srio@esrf.fr ports to Windows95.
;		97/05/15 srio@esrf.fr adds cryst_tt and related options.
;		97-09-30 srio@esrf.fr renames read_ascii by rascii
;		97-10-13 srio@esrf.fr v 1.1 prepared for xop 1.9
;		98-12-10 srio@esrf.fr v 1.2 prepared for xop 2.0
;		99-03-16 srio@esrf.fr updates doc.
;		2002-06-20 srio@esrf.fr passes title for the xplot window 
;			though the fortran code. This allows an automatic 
;			reload of the title when using xplot/reload file. 
;
;========================================================================
;
FUNCTION XCRYSTAL_bent_version
return,'1.2'
end
;		
;========================================================================
;
PRO xcrystal_bent_map,state, Group=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XCRYSTAL_BENT_MAP: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
;
; makes sensitive/unsensitice the Takagi-Taupin menus
;
index = state.str.parameters.theory(0)
theory = state.str.parameters.theory(1+index)
pos=strpos(strlowcase(theory),'takagi')

if pos NE -1 then begin
  widget_control,state.wids.tt,sensitive=1
endif else begin
  widget_control,state.wids.tt,sensitive=0
endelse

if strcompress(state.str.parameters.net(0),/rem) EQ '0' then $
	widget_control,state.wids.net,sensitive=0 else $
	widget_control,state.wids.net,sensitive=1
if strcompress(state.str.parameters.all(0),/rem) EQ '0' then $
	widget_control,state.wids.all,sensitive=0 else $
	widget_control,state.wids.all,sensitive=1
end
;		
;========================================================================
;
pro xcrystal_bent_net,group=group


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XCRYSTAL_BENT_NET: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

if checkfile('cryst_tt.net') ne 1 then begin
  tmp = widget_message(dialog_parent=group,/error,$
	['File cryst_tt.net not found.','Please run Takagi-Taupin model.'])
  return
endif
;a=rascii('cryst_tt.net')
if sdep() EQ 'WINDOWS' then begin
  openr,Unit,'cryst_tt.net',/get_lun
  ; this should work in PC
  itmp=0.0E0
  readf,unit,itmp
  itmp=long(itmp)
  a = fltarr(5,itmp)
  tmp = fltarr(5)
  for i=0L,itmp-1 do begin
    readf,unit,tmp
    a(*,i)=tmp
  endfor
endif else begin
  openr,Unit,'cryst_tt.net',/f77_unformatted,/get_lun
  ;this do not work on PC (much faster in Unix)
  tmp=0.0
  readu,Unit,tmp
  point_lun,-Unit,offset
  x=assoc(Unit,fltarr(6+1,tmp),offset+4)
  y=x(0)
  a=y(0:4,*)
endelse

free_lun,unit
imenu=wmenu2(['Visualize |Do|^2','Visualize |Dh|^2',$
	'Visualize |Do|^2+|Dh|^2','Visualize only knots'])

buffer=["a0=!p.position",$
 "!p.position=[.1,.3,.9,.9]",$
 "erase",$
 "imenu="+strcompress(imenu,/rem)+" ;imenu: 0=|Do|^2, 1=|Dh|^2, 2=|Do|^2+|Dh|^2,3=knots",$
 "toptitle=['|Do|^2','|Dh|^2','|Do|^2+|Dh|^2','Knots']",$
 "if imenu NE 3 then colorbar,position=[.1,.05,.9,.2],title='Intensity'",$
 "usersym,cos(findgen(16)*(!pi*2/16.)),sin(findgen(16)*(!pi*2/16.)),/fill",$
 "plot,data(0,*),-data(2,*),psym=3,xtitle='x',ytitle='depth [um]',/noerase,title=toptitle(imenu)",$
 "xyouts,data(0,0),-data(2,0),'1'",$
 "nelem=n_elements(data(0,*))",$
 "xyouts,data(0,nelem-1),-data(2,nelem-1),strcompress(nelem,/rem)",$
 "if imenu EQ 0 then dd = data(3,*)",$
 "if imenu EQ 1 then dd = data(4,*)",$
 "if imenu EQ 2 then dd = data(3,*)+data(4,*)",$
 "if imenu NE 3 then maxdd = max(dd)",$
 "if imenu NE 3 then for a1=0L,nelem-1 do oplot,[data(0,a1),data(0,a1)],"+$
	"-[data(2,a1),data(2,a1)],color=dd(a1)/maxdd*!d.n_colors,psym=8",$
 "!p.position=a0"]
xwindow,buffer=buffer,data=a,group=group,/edit,$
  wtitle='xcrystal_bent (TT): integration network'

;read,'plot node number? [0/1]',tmp
;if tmp eq '1' then begin
  ;plotfile,xz,psym=3,xtitle='x',ytitle='depth [um]'
  ;;for i=0,nn-1 do xyouts,xz(0,i),xz(1,i),strcompress(i+1,/rem)
;endif

; plots 3d graph
 
end
;		
;========================================================================
;
PRO XCrystal_bent_Inp_Write,state, Group=group


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=goup, $
     'XCRYSTAL_BENT_INP: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
;
; write the contents of the structure with parameters for running reflex
;
inp = state.str.parameters
name=state.str.codes(fix(state.str.parameters.theory(0)))+'.inp'

  fileroot = state.str.codes(fix(state.str.parameters.theory(0)))
  title='Crystal_Bent '+xcrystal_bent_version()+ $
    ' {'+fileroot+'} '+$
    state.str.parameters.Crystal_material( $
    fix(strcompress(state.str.parameters.Crystal_material(0),$
    /rem)) + 1)
  title = title + ' '+$
    STRCOMPRESS(state.str.parameters.Miller_index_h,/REM)+$
    STRCOMPRESS(state.str.parameters.Miller_index_k,/REM)+$
    STRCOMPRESS(state.str.parameters.Miller_index_l,/REM)+$
    ' E='+STRCOMPRESS(state.str.parameters.Energy,/REM)+$
    'eV, t='+$
    strmid(STRCOMPRESS(state.str.parameters.Thickness,$
    /REM),0,4)+'mm, R='+$
    strmid(STRCOMPRESS(state.str.parameters.Radius_min_m,$
    /REM),0,4)+'m, !4a!X='+$
    strmid(STRCOMPRESS(state.str.parameters.Asymmetry_angle,$
    /REM),0,4)+'deg'
;
Openw,unit,name,/GET_LUN
;
;
Printf,unit,state.str.bragg.parameters.outfil
Printf,unit,title
Printf,unit,strcompress(inp.Energy,/rem)
;
flag = StrCompress(inp.Geometry(0),/Remove_All)
If (flag eq '0') THEN Printf,unit,'1'
If (flag eq '1') THEN Printf,unit,'2'
;
Printf,unit,StrCompress(inp.Y_start,/Remove_All)
Printf,unit,StrCompress(inp.Y_end,/Remove_All)

y_step = Double(inp.Y_end-inp.Y_start)/Double(inp.npts-1)
Printf,unit,StrCompress(y_step,/Remove_All)
;
flag = StrCompress(inp.Polarization(0),/Remove_All)
CASE flag OF
  '0':  Printf,unit,'1'
  '1':  Printf,unit,'2'
  '2':  Printf,unit,'3'
  else:
ENDCASE
;
Printf,unit, STRCOMPRESS(inp.Radius_min_m,/REMOVE_ALL)
Printf,unit,StrCompress(inp.asymmetry_angle,/Remove_All)
Printf,unit,StrCompress(inp.Thickness,/Remove_All)
Printf,unit,StrCompress(inp.elastic,/Remove_All)
Free_Lun,unit
;
END
;=======================================================================
;
PRO Xcrystal_bent_EVENT,event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
     'XCRYSTAL_BENT_EVENT: error caught: '+!err_string)
   Catch, /Cancel
   If Type(stateid) EQ 3 THEN $
     If Widget_Info(stateid,/Valid_Id) AND N_Elements(state) NE 0 THEN $
     Widget_Control,stateid,Set_UValue=state,/No_Copy
   On_Error,2
   RETURN
ENDIF

;
; register the events
;
Widget_control, event.id, Get_uvalue=eventuval

stateid = Widget_Info(event.handler,/Child)
Widget_control, stateid,  Get_uvalue=state,/No_Copy

;inp = state.str

CASE eventuval OF
;	'FILELOAD': BEGIN
;		if sdep() eq 'UNIX' then filter='*.inp' else filter=0
;		ffile = pickfile(title='Select Xcrystal_bent input file...',$
;		/NOCONF,FILTER=filter)
;		if strcompress(ffile,/rem) EQ '' then GoTo,out
;		version = 0
;		restore,ffile,/VERBOSE
;		if version NE xcrystal_bent_version() then $
;		  itmp = widget_message(dialog_parent=event.top,$
;		  'Input file and current '+$
;		  'Xcrystal_bent have different versions.')
;		;state.str.parameters = str_par
;		;state.str.tt_pars = str_tt
;		tmp = state.str.parameters 
;		copy_structure,str_par,tmp
;		state.str.parameters = tmp
;		tmp = state.str.tt_pars
;		copy_structure,str_tt,tmp
;		state.str.tt_pars = tmp
;		xcrystal_bent_map,state, Group=event.top
;		END
;	'FILEWRITE': BEGIN
;		ffile = pickfile(/WRITE,file='xcrystal_bent.inp')
;		if strcompress(ffile,/rem) EQ '' then GoTo,out
;		version = xcrystal_bent_version()
;		str_par = state.str.parameters
;		str_tt = state.str.tt_pars
;		command = 'save,version,str_par,str_tt,'+$
;		'FILENAME='+"'"+strcompress(ffile,/rem)+"'"+',/VERBOSE'
;		tmp = execute(command)
;		;itmp = widget_message(dialog_parent=event.top,$
;		;	/INFO,'File '+ffile+' written to disk.')
;		END

        'FILEINPUT': BEGIN
                  action=''
                  Widget_Control,event.id, Get_Value=action
                  CASE action OF
                    'Load from file...': BEGIN
                      ;if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
		      filter='*.xop'
                      str_par = Xop_Input_Load(Title=$
                      'Select Xcrystal_bent input file...',$
                      /NoConf,Filter=filter,Group=event.top)
                      IF Type(str_par) EQ 8 THEN BEGIN
                        tmp = state.str.parameters
                        Copy_Structure,str_par, tmp, Group=event.top, $
			 /OnlyFirstField
                        state.str.parameters = tmp
			xcrystal_bent_map,state, Group=event.top
                      ENDIF
                    END
                    'Save to file...': BEGIN
                      str_par = state.str.parameters
                      Xop_Input_Save,str_par,File='xcrystal_bent.xop',$
                        /Write, Group=event.top, Comment= $
			'; xop/xcrystal_bent(v'+$
                      xcrystal_bent_version()+') input file on '+SysTime()
                    END
                    'Save as default': BEGIN
                      str_par = state.str.parameters
                      Xop_Input_Save,str_par,Group=event.top, $
                        Default='xcrystal_bent.xop',Comment= $
			'; xop/xcrystal_bent(v'+$
                      xcrystal_bent_version()+') input file on '+SysTime()
                    END
                  ENDCASE
                END
	'QUIT': BEGIN
		if sdep() EQ 'WINDOWS' then files = $
		  ['xcrystal.bra','cryst_??.dat','cryst_??.inf',$
		   'cryst_??.inp','cryst_??.win','cryst_??.net',$
		   'cryst_??.all','cryst_??.par']  else files = $
		  ['xcrystal.bragg','cryst_??.dat','cryst_??.inf',$
		   'cryst_??.inp','cryst_??.win','cryst_??.net',$
		   'cryst_??.all','cryst_??.par']
		;Message,/Info,'Executing: '+command
		;Spawn,command
		Delete_Files,files,Group=event.top
		Widget_control,event.top,/Destroy
		RETURN
		END
	'SETDEF': BEGIN
		itmp = widget_message(dialog_parent=event.top,$
		/Question,['This option initializes the',$
		'xcrystal_bent parameters to their default values.',$
		'Then you must click Set_parameters to run the program.',$
		'Do you really want that?'],title='xcrystal_bent')
		if itmp eq 'No' then goto,out

		tmp = xop_defaults('xcrystal_bent')
		tmp = tmp.parameters
		str_par = Create_SubStruct(tmp,IndGen(state.str.n_main))
		tmp1 = state.str.parameters
		copy_structure,str_par,tmp1
		state.str.parameters = tmp1
		END
	'TT_DEFAULTS': BEGIN
		itmp = widget_message(dialog_parent=event.top,$
		/Question,['This option initializes the',$
		'Takagi-Taupin specific parameters to their default values.',$
		'Then you must click Set_parameters/TT/Set Parameters to ',$
		'change them and then click Set_parameters to run the ',$
		'program.',$
		'Do you really want that?'],title='Takagi-Taupin Defaults')
		if itmp eq 'No' then goto,out
		tmp = xop_defaults('xcrystal_bent')
		tmp = tmp.parameters
		str_par = Create_SubStruct(tmp,state.str.n_main+$
			IndGen(state.str.n_tt))
		tmp1 = state.str.parameters
		copy_structure,str_par,tmp1
		state.str.parameters = tmp1
		END
	'SET_TT': BEGIN
		;str_par = state.str.tt_pars
		tmp = state.str.parameters
		str_par = Create_SubStruct(tmp,state.str.n_main+$
			IndGen(state.str.n_tt))
		sep = sdep(/ds)
                helpcmd = "xdisplayfile1,'"+Xop_GetEnv('XOP_HOME')+$
                  sep+"doc"+sep+'txt'+sep+ $
		  "xcrystal_bent_tt_par.txt'"
		Xscrmenu,str_par,Group=event.top,Action=action,$
		Titles=state.str.tt_titles, Flags=state.str.tt_flags, $
		/NoType,/Interp, Wtitle='TT Specific input parameters',$
		help=helpcmd

		IF (action EQ 'DONT') THEN Goto,out
		Widget_control,/Hourglass
		Copy_Structure,str_par,tmp
		;state.str.tt_pars = str_par
		state.str.parameters = tmp
		END
	'SETPAR': BEGIN
		;str_par = state.str.parameters
		tmp = state.str.parameters
		str_par = Create_SubStruct(tmp,IndGen(state.str.n_main))
		;str_par2 = Create_SubStruct(tmp,state.str.n_main+$
		;	IndGen(state.str.n_tt))
		sep = sdep(/ds)
                helpcmd = "xdisplayfile1,'"+Xop_GetEnv('XOP_HOME')+$
                  sep+"doc"+sep+'txt'+sep+"xcrystal_bent_par.txt'"
		Xscrmenu,str_par,Group=event.top,Ncol=3,Action=action,$
		Titles=state.str.titles, Flags=state.str.flags, /NoType,$
		/Interp, Wtitle='Xcrystal_bent input parameters',$
		help=helpcmd

		IF (action EQ 'DONT') THEN Goto,out
		Widget_control,/Hourglass

		;tmp2 = Create_Struct(str_par,str_par2)
		;Copy_Structure,tmp2,tmp
		Copy_Structure,str_par,tmp
		state.str.parameters = tmp

		xcrystal_bent_map,state, Group=event.top
		Xcrystal_bent_Inp_Write,state, Group=event.top
		; bragg
		strbragg = state.str.bragg
		strbragg.parameters.filef0 = str_par.filef0
		strbragg.parameters.filef1f2 = str_par.filef1f2
		strbragg.parameters.emin = str_par.energy - $
			state.str.energy_shift
		strbragg.parameters.emax = str_par.energy + $
			state.str.energy_shift
		strbragg.parameters.estep = state.str.energy_step
		strbragg.parameters.ilattice = str_par.Crystal_material
		strbragg.parameters.hmiller = str_par.Miller_index_h
		strbragg.parameters.kmiller = str_par.Miller_index_k
		strbragg.parameters.lmiller = str_par.Miller_index_l
		strbragg.parameters.i_absorp = str_par.i_absorp
		strbragg.parameters.temper = str_par.temper
		Message,/Info,'Running bragg_calc'
		tmp = bragg_calc(strbragg)
		Message,/Info,'Writing results (bragg_out)'
		bragg_out,tmp
		code = state.str.codes(fix(state.str.parameters.theory(0)))
		; writes cryst_tt.win
		if fix(state.str.parameters.theory(0)) GE 3 then begin
		openw,Unit,'cryst_tt.win',/get_lun
		printf,Unit,'# window in microns'
		printf,Unit,state.str.parameters.window
		printf,Unit,'# step in microns'
		printf,Unit,state.str.parameters.step
		printf,Unit,'# write network file? (0=no, 1=yes)'
		printf,Unit,state.str.parameters.net(0)
		printf,Unit,'# write all diffraction profiles? (0=no, 1=yes)'
		printf,Unit,state.str.parameters.all(0)
		free_lun,Unit
		endif

		command=code
		Xop_Spawn,command,CleanFiles=[code+'.dat',code+'.par']
		END
        'HELP': BEGIN
		if (sdep() EQ 'WINDOWS' and sdep(/vs) EQ '4') $
		  then tmp='xcryst~1' else tmp='xcrystal_bent'
		Xhelp,tmp,Group=event.top
		END
	'SHOW':	BEGIN
		WIDGET_CONTROL,event.id,GET_VALUE=eventval
		fileroot = state.str.codes(fix(state.str.parameters.theory(0)))
		ffile = findfile(fileroot+'.dat')
		size_inp = SIZE(state.str.parameters)
		IF (ffile(0) EQ '' OR  size_inp(1) EQ 0) THEN BEGIN
		  message,/info,'File not found. '
		  itmp = widget_message(dialog_parent=event.top,/ERROR,$
		        ['xcrystal_bent data file not found...',$ 
			'Set Parameters before...  '])
		  Goto,Out
		ENDIF 
		  CASE eventval OF
		  "Diffraction curve": XPLOT,spec=fileroot+'.dat',$
			wtitle='xcrystal_bent result ['+fileroot+'.dat]',$
			XTITLE='-1', TITLE='#UT0',GROUP=event.top,/No_Block
		  "Bent crystal Parameters":XDisplayFile1,fileroot+'.inf' ,$
		     Group=event.top
		  "Crystallographic Parameters":XdisplayFile1,$
		     state.str.bragg.parameters.outfil,Group=event.top
		  "Integration Network": begin
			widget_control,/hourglass
			xcrystal_bent_net,group=event.top
			end
		  "All reflectivity curves": begin
			if checkfile('cryst_tt.all') ne 1 then begin
			  tmp = widget_message(dialog_parent=event.top,$
				/error,['File cryst_tt.all not found.',$
			        'Please run Takagi-Taupin model.'])
			  goto,out
			endif
			widget_control,/hourglass
			message,/info,'Reading file cryst_tt.all ...'
			a=rascii('cryst_tt.all')
			print,'Done.'
			message,/info,'converting coordinates...'
			coor2matr,a,refl,jj,eta,/sort
			print,'Done.'
			tmp = !p.charsize
			!p.charsize = 2.0
			xsurface1,refl,jj,eta,xtitle='jj',ytitle='eta',$
				group=event.top
			!p.charsize = tmp
			end
		  else: message,/info,'case item not found'
		  ENDCASE
		  END  ;END SHOW
  ENDCASE
out:
Widget_Control, stateid, Set_Uvalue=state, /No_Copy
END
;
;==============================================================================
;
PRO Xcrystal_bent, GROUP=group, InputFile=inputFile, No_Block=no_block
;
Forward_Function xop_defaults

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XCRYSTAL_BENT: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

if xregistered('xcrystal_bent') gt 1 then return
; if not(keyword_set(group)) then xop_wd,/default
IF N_Elements(no_block) EQ 0  then no_block=0

;
; widget definition
;

base=WIDGET_BASE(/COLUMN,TITLE='Xcrystal_bent '+xcrystal_bent_version(),$
	MBAR=wMenuBar)

wButtons = widget_base(base,/Column) ; also to store state

wFile = widget_button(wMenuBar,VALUE='File',/MENU)

  wtmp0 = widget_button(wFile,VALUE='Xcrystal_bent input parameters', /Menu)
    wtmp = widget_button(wtmp0,VALUE='Load from file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save to file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save as default',UValue='FILEINPUT')
;  wtmp = widget_button(wFile,VALUE='Load Xcrystal_bent input file...', $
;		UVALUE='FILELOAD')
;  wtmp = widget_button(wFile,VALUE='Write Xcrystal_bent input file...', $
;		UVALUE='FILEWRITE')
  wtmp = widget_button(wFile,VALUE='Quit', UVALUE='QUIT',/SEPARATOR)

wSetParameters = widget_button(wMenuBar,VALUE='Set_Parameters', /MENU)
  wtmp = widget_button(wSetParameters,VALUE='Set Parameters', UVALUE='SETPAR')
  wtmp = widget_button(wSetParameters,VALUE='Set Defaults', UVALUE='SETDEF')
  wtmpbase = widget_button(wSetParameters,VALUE=$
	'Takagi-Taupin Specific Parameters', /MENU)
  wtmp = widget_button(wtmpbase,VALUE='Set Parameters',UVALUE='SET_TT')
  wtmp = widget_button(wtmpbase,VALUE='Set Defaults',UVALUE='TT_DEFAULTS')

wResults = widget_button(wMenuBar,VALUE='Show',/MENU)
  wtmp = widget_button(wResults,VALUE='Diffraction curve', UVALUE='SHOW')
  wtmp = widget_button(wResults,VALUE='Bent crystal Parameters', UVALUE='SHOW')
  wtmp = widget_button(wResults,VALUE='Crystallographic Parameters', $
	UVALUE='SHOW')
  wtt = widget_button(wResults,VALUE='Takagi-Taupin',/Menu)
  wtt_1 = widget_button(wtt,VALUE='Integration Network',UVALUE='SHOW')
  wtt_2 = widget_button(wtt,VALUE='All reflectivity curves',UVALUE='SHOW')

wHelp = widget_button(wMenuBar,VALUE='Help', /Help)
  wtmp = widget_button(wHelp,VALUE='xcrystal_bent', UVALUE='HELP')
;
wtmp = widget_button(BASE,VALUE='Set Parameters', UVALUE='SETPAR')


;if sdep() EQ 'WINDOWS' then font = 'VERDANA*BOLD*ITALIC*24' else  $
;  font='-b&h-lucida-bold-i-normal-sans-24-240-75-75-p-151-iso8859-1'

if sdep() EQ 'WINDOWS' then font = 'VERDANA*BOLD*ITALIC*24' else  $
  font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

wtmp = WIDGET_LABEL( BASE,  VALUE='Crystal_bent' , FONT=font)
wtmp = WIDGET_LABEL( BASE,  VALUE='(Bent Crystal Diffraction)' , FONT=font)

;
;state
;
str = xop_defaults('xcrystal_bent')


IF KeyWord_Set(inputFile) THEN BEGIN
  str_par = Xop_Input_Load(InputFile=inputFile)
  IF Type(str_par) EQ 8 THEN BEGIN
    tmp = str.parameters
    Copy_Structure,str_par, tmp, Group=group
    str.parameters = tmp
  ENDIF
ENDIF

wids = {tt:wtt,net:wtt_1, all:wtt_2}
state = { str:str, wids:wids}
xcrystal_bent_map,state, Group=group
;
;actions
;
Widget_control,Widget_Info(base,/Child),Set_uvalue=state,/No_Copy
Widget_control,base,/Realize
Xmanager,'xcrystal_bent',base,Group_leader=group,No_block=no_block
end
;
