      PROGRAM CRYSTAL_PP
      IMPLICIT REAL*8(A-H,O-Z)

C	 	  Created by C. Ferrero; last modified: may 1997
c     numerous modifications done by M. Sanchez del Rio
c					last modified oct 1997
c
c     negative curvature radii are allowed
c
c     to calculate reflectivity curves in Laue geometry in cylindri-
c     cally bent perfect crystals
c
c     Ref. for the Poisson ratio values: G. Simmons and H. Wang,
c     "Single Crystal Elastic Constants and Calculated Aggregate         
c     Properties: A HANDBOOK", 2nd ed. , 1971, The M.I.T. Press
c
      REAL*8 MU,LAMBDA,KSTAR
      COMPLEX*16      CHIH                                               

c     DIMENSION RC(1)                    
                                                                
      dimension Y(2000),TETA4(2000),E(2000,6)
	dimension iunits(3)
C      PARAMETER (R0=2.817938070D-15)
      PARAMETER (R0=2.817940289458D-15)


        DATA    TODEG   / 57.2957 79513 08232 08767 98155 D0 /
C        DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
        DATA    TWOPI   /  6.2831 85307 17958 64679 25287 D0 /
        DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /

        complex*16   struct

c new structure factors (with Bragg 2.1) 

        character*80    file_refl
        character*160    top_title
        complex*16      f_0,f_h,f_hbar
        complex*16      psi_0,psi_h,psi_hbar
        complex*16      refrac

      
c input/output
c      integer  GetString, GetInteger, GetLogical, GetDouble
c      external GetString, GetInteger, GetLogical, GetDouble


c	defines output units
	iunits(1) = 6
	iunits(2) = 10
	iunits(3) = 12

c opens output files

      open (10,file='cryst_pp.dat',status='unknown',err=101)
      open (12,file='cryst_pp.inf',status='unknown',err=101)


c default values
*case 1: Laue Si bent cristal

	      file_refl = 'xcrystal.bra'
	      PHOT = 33169.0          !photon energy [eV]
	      LAMBDA = 0.374004       !photon wavelength [A]
	      i_geometry = 2 ! always
	      Y0 = -15.                ! Ymin
	      YMAX = 25.               ! Ymax
	      DY0 = .1              ! Ystep
	      ipol = 1
	      alpha = 63.78           ! asymmetry angle
	      radius = 12.98              ! R min [m]
	      T = 0.700000            ! crystal thickness [mm]
	      KSTAR = 0.224D0	!Poisson Ratio  FOR SI


	      idebugger = 0

C                                                                       
C     USER'S INPUT SECTION                                              
C                                                                       
      do i=6,12,6
      write(i,*)' '
      write(i,*)' '
      write(i,*)' '
      write(i,*)'******************************************************'
      write(i,*)'*                   CRYSTAL_PP                       *'
      write(i,*)'* calculates the X-ray reflectivity curves of        *'
      write(i,*)'* elastically bent perfect crystals in transmission  *'
      write(i,*)'* geometry and is based on the approximated theory of*' 
      write(i,*)'*            P. Penning and D. Polder,               *'
      write(i,*)'*       Philips Res. Repts. 16, 419-440, 1961.       *'
      write(i,*)'*                                                    *'
      write(i,*)'* (c) European Synchrotron Radiation Facility        *'
      write(i,*)'*                                                    *'
      write(i,*)'******************************************************'
      write(i,*)' '
      enddo


      write(*,*)  ' '
C      write(*,*)  ' Run crystal_pp with the input parameters from: '
C      write(*,*)  '     [0] default values'
C      write(*,*)  '     [1] input from keyboard'
C      write(*,*)  '     [2] input from file crystal_pp.inp'
C	read(*,*) IRUN
	IRUN = 2

C	if (irun.eq.1) call crystal_inp(file_refl,PHOT,
C     $I_GEOMETRY,Y0,YMAX,DY0,IPOL,ALPHA,radius,T,KSTAR)

	if (irun.eq.2) then
	  write(*,*) 'Reading inputs from file crystal_pp.inp'
	  open (11,file='cryst_pp.inp',status='old')
	  read(11,'(a)') file_refl
	  read(11,'(a)') top_title
	  read(11,*) PHOT
	  read(11,*) I_GEOMETRY
	  read(11,*) Y0
	  read(11,*) YMAX
	  read(11,*) DY0
	  read(11,*) IPOL
	  read(11,*) radius
	  read(11,*) ALPHA
	  read(11,*) T
	  read(11,*) KSTAR
	  close(11)
	  write(*,*) 'Done.'
	endif

C
C Start writing in the output file
C
	write(10,'(a)') '#F crystal_pp.dat'
	write(10,'(a)') '#S 1 crystal_pp run'
	write(10,'(a)') '#C results of crystal_pp [Pennin Polder]  run'
	write(10,'(a)') '#UT0 '//top_title(1:iblank2(top_title))
csrio	write(10,'(a)') '#N 8'
	write(10,'(a)') '#N 8'
	write(10,'(a)') 
     1'#L theta_inc[mrad]  theta_ref[mrad]  theta_inc[deg]  
     1Y  c4  c3  c2  Reflectivity'
csrio     $'#L theta[mrad]  Y  theta_ref[mrad]  Y_ref  c4  c3  c2  c1'

C
C redefinition of zeros (connventional inputs)
C
        if (t.eq.0) t=1000.0
        if (radius.eq.0) radius=1000000.0

C
C WRITES INPUTS IN PARAMETERS FILE
C

      write(12,*) '**Input section:'
      write(12,*) 'crystal input file: ',file_refl
      write(12,*) 'photon energy [eV]: ',PHOT
      write(12,*) 'geometry [1: Bragg, 2: Laue]',I_GEOMETRY
      write(12,*) 'Y min: ',Y0
      write(12,*) 'Y max: ',YMAX
      write(12,*) 'Y step: ',DY0
      write(12,*) 'Polarization [1=s,2=p,3=unpolarized]: ',IPOL
      write(12,*) 'crystal curvarure radius [m]: ',radius
      write(12,*) 'asymmetry angle [deg]: ',ALPHA
      write(12,*) 'crystal thickness [mm]: ',T
      write(12,*) 'Poisson ratio   : ',kstar

C 
C END OF INPUT SECTION
C
8080 	continue
	    lambda = 12398.54/phot       ! Angstrom
C
C CHECK INPUT PARAMETERS
C

	     if (idebugger.EQ.1) then 
	     write (*,*) 'Starting Y value:    ',Y0
	     write (*,*) 'End Y value:         ',YMAX
	     write (*,*) 'Y value step:        ',DY0   
	     write (*,*) 'Wavelength [A]:      ',LAMBDA
	     write (*,*) 'Photon Energy [eV]:  ',PHOT
	     write (*,*) 'Asymmetry angle [deg]:  ',alpha
	     write (*,*) 'Asymmetry angle [rad]:  ',alpha/TODEG
	     write (*,*) 'Polarization flag:      ',IPOL
	     write (*,*) 'Curvature Radius[m]:    ',radius
	     write (*,*) 'Crystal Thickness [mm]: ',T
	     write (*,*) 'Poisson ratio   : ',kstar
	     endif

     	T = T /1e3
c     RC(1) = radius
       NTOT = INT((YMAX-Y0)/DY0+1.0D0)
       IF (NTOT.GT.1999) THEN
	  DO I=1,3
            write (iunits(i),*) 
     $      'cryst_pp ABORTED: Y0-INCREMENT TOO SMALL (NTOT<2000)'
	    if (iunits(i).NE.6) close(iunits(i))
	  ENDDO
	  stop
       END IF

      write(12,*) '**derived:'
      write(12,*) 'Wavelength [A]:      ',LAMBDA
      write(12,*) 'Asymmetry angle [rad]:  ',alpha/TODEG
      write(12,*) 'number of points: ',NTOT+1
      write(12,*) ' '
      write(12,*) ' '

C 
C  STRUCTURE FACTOR CALCULATION
C


C Call crystal_fh to read the BRAGG file
	    call crystal_fh(-1,file_refl,phot,theta,
     $f_h,f_hbar,f_0,psi_h,psi_hbar,psi_0,refrac,
     $rn,d_spacing)

	     theta = dasin(lambda/2.0E8/d_spacing)
	     if (idebugger.eq.1) then 
	     write(*,*)'d_spacing [cm]: ',d_spacing
      write(*,*)'Lambda [A]: ',Lambda
c     write(*,*)'Phot: ',Phot
	     write(*,*)'Theta [deg]: ',theta*todeg
	     write(*,*)'Theta [rad]: ',theta
	     endif

C
	     write(12,*)'##############################################'
	     write(12,*)'Starts data from Structure Factor calculation.'
	     call crystal_fh(12,file_refl,phot,theta,
     $f_h,f_hbar,f_0,psi_h,psi_hbar,psi_0,refrac,
     $rn,d_spacing)
	     write(12,*)'Ends data from Structure Factor calculation.'
	     write(12,*)'##############################################'
	     write(12,*)' '
	     write(12,*)' '

	     if (idebugger.EQ.1) then
	     write (*,*) '** RN         : ',RN
	     write (*,*) '** D_SPACING  : ',D_SPACING
	     write (*,*) '** F_H     : ',F_H
	     write (*,*) '** F_HBAR  : ',F_HBAR
	     write (*,*) '** F_0     : ',F_0
	     write (*,*) ' '
	     write (*,*) '** PSI_H   : ',PSI_H
	     write (*,*) '** PSI_HBAR: ',PSI_HBAR
	     write (*,*) '** PSI_0   : ',PSI_0
	     write (*,*) ' '
	     write (*,*) '** REFRAC  : ',REFRAC
	     endif

#if lahey
	     MU =  2.0d0 * TWOPI *(-AIMAG(REFRAC)) / (LAMBDA*1.0D-8)
#else
	     MU =  2.0d0 * TWOPI *(-DIMAG(REFRAC)) / (LAMBDA*1.0D-8)
#endif
C 
C END NEW STRUCTURE FACTOR CALCULATION
C
	     LAMBDA = LAMBDA * 1.0D-10    !m

	     MU = MU * 1.0D2              !m^-1

                                        
	     d = d_spacing*1d-2     ! d in meters
	     v = 2.817938070 D-13/rn   ! V in cm^3
	     v = v*1.00d-6             ! V in m^3
c	     if (idebugger.eq.1) write (*,*) '**** d = ',d
c	     if (idebugger.eq.1) write (*,*) '**** v = ',v

cfer   TETAB = DASIN(LAMBDA/(2.00D0*D))                               
       TETAB = theta                                                  
       TTT = TETAB*180.00D0/PI                                       

       if (idebugger.EQ.1)  WRITE (*,*) 'TETAB (DEG) =',TTT                              
       alpha = alpha*PI/180.00D0                                     
       CHI = alpha-PI/2.0D0                                             
       GAM0 = DCOS(TETAB-CHI)                                                   
       GAMH = DCOS(TETAB+CHI)                                                   
       B = GAM0/GAMH                                                            
csrio changed???
c      thetain = tetab + ALPHA
c      thetaout = tetab - ALPHA
c      gam0 = dsin(thetain)
c      gamh = dsin(thetaout)
c      B = - gam0/gamh

	write(*,*) '<<>>  bragg angle: ',TETAB
c	write(*,*) '<<>>  inc : ',(TETAB-CHI)*180.0/3.14
c	write(*,*) '<<>>  ref : ',(TETAB+CHI)*180.0/3.14
	write(*,*) '<<>>  gamma 0 : ',GAM0
	write(*,*) '<<>>  gamma H : ',GAMH
	write(*,*) '<<>>  B : ',B
	

      IF (B.LT.0.0D0) THEN                                                      
          DO I=1,3
            write (iunits(i),*)
     $      'cryst_pp ABORTED: ASYMMETRY FACTOR NOT CONSISTENT'
     $      //' WITH CHOSEN GEOMETRY'
            if (iunits(i).NE.6) close(iunits(i))
          ENDDO
          stop
      ENDIF                                                                     


      WRITE (12,*) ''
      WRITE (12,*) 'Asymmetric Factor B = ',B
      WRITE (12,*) 'Director Cosine  Gamma0 = ',GAM0
      WRITE (12,*) 'Director Cosine  GammaH = ',GAMH
      WRITE (12,*) ''
                                                                       
                                                                                           
                                                
      IF (IPOL.EQ.1) THEN
        CGROSS = 1.00D0
      ELSE IF (IPOL.EQ.2) THEN
        CGROSS = DABS(DCOS(2.00D0*TETAB))
      ELSE IF (IPOL.EQ.3) THEN
        CGROSS = (1.00D0+DABS(DCOS(2.00D0*TETAB)))/2.00D0
      ELSE
          DO I=1,3
            write (iunits(i),*)
     $      'cryst_pp ABORTED: WRONG POLARIZATION NUMBER. '
            if (iunits(i).NE.6) close(iunits(i))
          ENDDO
          stop
      END IF

#if lahey
	struct  = sqrt(f_h * f_hbar)
#else
	struct  = cdsqrt(f_h * f_hbar)
#endif
                                                    
C      CHI0 = CMPLX(CHI0R,CHI0I)                                                 
CFER******************************************************************          
C
C     DEFINITION OF ELECTRICAL SUSCEPTIBILITY
C

#if lahey
          FHR = - real(struct,8)
          FHI = - aimag(struct)
       	  F0   = real(f_0,8)
#else
          FHR = - dreal(struct)
          FHI = - dimag(struct)
       	  F0   = Dreal(f_0)
#endif
           
Clinux       	  F0   = real(f_0)
        if (idebugger.EQ.1) write (*,*) '>> F0 = ',F0
        if (idebugger.EQ.1) write (*,*) '>> FHR = ',FHR
        if (idebugger.EQ.1) write (*,*) '>> FHI = ',FHI
        if (idebugger.EQ.1) write (*,*) '>> str = ',struct


      FACT = R0/(PI*V)
      CHI0I = -MU*LAMBDA/(2.00D0*PI)
      CHI0R = -FACT*F0*LAMBDA**2
                                                
        CHIHR = -FACT*FHR*LAMBDA*LAMBDA 
        CHIHI = -FACT*FHI*LAMBDA*LAMBDA
        CHIH = -FACT*struct*LAMBDA*LAMBDA

c     write (*,*) 'test -- lambda = ',lambda
#if lahey
      pend_lena = lambda*sqrt(gam0*dabs(gamh))/(cgross*
     &sqrt(psi_h*psi_hbar)*pi)
#else
      pend_lena = lambda*dsqrt(gam0*dabs(gamh))/(cgross*
     &cdsqrt(psi_h*psi_hbar)*pi)
#endif
cf    pend_lena = lambda*dsqrt(gam0*dabs(gamh))/(cgross*
cf   &(cdsqrt(chih*) 
c     write (*,*) 'test -- abs(chi) = ',cdabs(chih)
c     write (*,*) 'test -- pendlena = ',pend_lena   

#if lahey
      rccmin = 2.0d0*dsin(tetab)*pend_lena/(cgross*abs(psi_h))
      pend_len = lambda*gam0/(cgross*abs(chih))
#else
      rccmin = 2.0d0*dsin(tetab)*pend_lena/(cgross*cdabs(psi_h))
      pend_len = lambda*gam0/(cgross*cdabs(chih))
#endif

      betac = pi/(2.0d0*pend_len)

      if (idebugger.EQ.1) 
     $write (*,*) '0*** min. radius of curvature [m] =',rccmin,' !!!'
      if (idebugger.EQ.1)  WRITE (*,*) 'CHI0I = ',CHI0I
      if (idebugger.EQ.1)  WRITE (*,*) 'CHI0R = ',CHI0R 
      if (idebugger.EQ.1)  WRITE (*,*) 'CHIHR = ',CHIHR 
      if (idebugger.EQ.1)  WRITE (*,*) 'CHIHI = ',CHIHI 
      if (idebugger.EQ.1)  WRITE (*,*) 'CHIH = ',CHIH                                              
      if (idebugger.EQ.1)  WRITE (*,*) 'pendelloes. length[m] =',
     &pend_len
      if (idebugger.EQ.1)  WRITE (*,*) 'crit. beta = ',betac        

C
C ----   loop on          Y AND TETA                                    
C                                                                       
#if lahey
      TFACT = CGROSS*ABS(CHIH)/(sqrt(b)*DSIN(2.0D0*TETAB))                   
#else
      TFACT = CGROSS*CDABS(CHIH)/(dsqrt(b)*DSIN(2.0D0*TETAB))                   
#endif
      EPS = chihi/chi0i
  
      T1 = (1.0D0-1.00D0/B)*CHI0R/(2.0D0*DSIN(2.0D0*TETAB))
c
c     write(6,*) 'before idebugger test'
      if (idebugger.eq.1) then
	write(6,*) 'in idebugger test'
	write(*,*) '1 y = ',1.0D6*TFACT,' microrad'
	write(12,*) '1 y = ',1.0D6*TFACT,' microrad'
	write(12,*) '1 y(symmetrical)=',1.0D6*TFACT*sqrt(b),'microrad'
	write(12,*) '1 y(on exit) = ',1.0D6*TFACT*b,' microrad'
	write(12,*) ' '
      endif
c
c--- penning polder original ----
c
c     TERM1 = (B-1.0D0)/(cgross*cdABS(CHIH)*radius)                           
c     write (*,*) '0*** abs(chih) = ',cdabs(chih)
c     TERM2 = DCOS(2.0D0*TETAB)+DCOS(2.0D0*CHI)                     
c     TERM3 = (1.0D0+KSTAR)/2.0D0                                               
c     BETA  = TERM1*(1.0D0+TERM2*TERM3)                                         
c     write (*,*) '0*** betapp  = ',beta 
c---------------------------------------------------
c --- malgrange modification ---------
 
#if lahey
      term1 =  2.0d0*dsin(chi)*dtan(tetab)/(cgross*ABS(CHIH)*radius)
#else
      term1 =  2.0d0*dsin(chi)*dtan(tetab)/(cgross*cdABS(CHIH)*radius)
#endif
      TERM2 = DCOS(2.0D0*TETAB)+DCOS(2.0D0*CHI)
      TERM3 = (1.0D0+KSTAR)/2.0D0
      BETA  = TERM1*(1.0D0+TERM2*TERM3)
c----------------------------------------------------------
       
      if (beta.ne.0.0d0) then
      eloss = dexp(-2.0d0*pi*betac/dabs(beta))
      else
      eloss = 0.0
      endif
       
	if (idebugger.EQ.1) then
	  write (*,*) '0*** beta  = ',beta 
	  write (*,*) '0*** fract. of new wavefields = ',eloss
	endif
       
      do 151 ini = 1,ntot+1
       do 152 jni = 1,4
        e(ini,jni) = 0.0d0
152    continue
151   continue
      DO 61 IC = 1,NTOT+1                                                       
c
      Y(ic) = Y0 + (ic-1)*dy0                                          
      T2 = TFACT*Y(ic)                                        
c                                           
c      teta4(ic)= tetab-t1-t2
c      teta4(ic)= 1.0d3*(teta4(ic)-tetab)
      teta4(ic)= -1.0D3*(t1+t2)
         
                                                                               
      CSIE1 = Y(ic) + SQRT(Y(ic)*Y(ic)+B)                                             
      CSIE2 = Y(ic) - SQRT(Y(ic)*Y(ic)+B)                                             
      CSII1 = Y(ic)-BETA*T+SQRT((BETA*T-Y(ic))**2+B)                                
      CSII2 = Y(ic)-BETA*T-SQRT((BETA*T-Y(ic))**2+B)                                
c	if (idebugger.eq.1) then 
c	  write (*,*) '<><> CSIE1: ',CSIE1
c	  write (*,*) '<><> CSIE2: ',CSIE2
c	  write (*,*) '<><> CSII1: ',CSII1
c	  write (*,*) '<><> CSII2: ',CSII2
c	endif
       
      AI1= B/(CSII1*CSII1+B)
      AE1 = B/(CSIE1*CSIE1+B)
      AI2 = B/(CSII2*CSII2+B)
      AE2 = B/(CSIE2*CSIE2+B)
       
c     if ((csie2*csii1).gt.0.0) then
c     B21 = (B-1.0D0)*(CSIE2-CSII1)/(2.0D0*BETA*T)
c     D21 = B*EPS*DLOG(CSIE2/CSII1)/(BETA*T)
c     ARG = MU*T*(1.0D0+B21+D21)/GAM0
c     TRANS =  AI1*AE2*DEXP(-ARG) 
c     E(ic,2)  = (CSIE2*CSIE2/B)*TRANS/B
c     endif
       

c     if ((csie1*csii2).gt.0.0) then
c     B12 = (B-1.0D0)*(CSIE1-CSII2)/(2.0D0*BETA*T)
c     D12 = B*EPS*DLOG(CSIE1/CSII2)/(BETA*T)
c     ARG = MU*T*(1.0D0+B12+D12)/GAM0
c     TRANS =  AI2*AE1*DEXP(-ARG) 
c     E(ic,3)  = (CSIE1*CSIE1/B)*TRANS/B
c     endif
       
      if ((csie2*csii2).gt.0.0) then
      if (beta.gt.0.0d0) then
      B22 = (B-1.0D0)*(CSIE2-CSII2)/(2.0D0*BETA*T)
      D22 = B*EPS*DLOG(CSIE2/CSII2)/(BETA*T)
      else
      b22 = 0
      d22 = 0
      endif
      ARG = MU*T*(1.0D0+B22+D22)/GAM0
      TRANS =  AI2*AE2*DEXP(-ARG)
      eic1     = (CSIE2*CSIE2/B)*TRANS/B
      E(ic,1)  = eic1*(1.0d0-eloss)                                           
      E(ic,2)  = TRANS/b                                            
      E(ic,3) = eic1*eloss*ae2
c     stick1  = e(ic,2)*eloss*ae2
      endif

      if ((csie1*csii1).gt.0.0) then
      if (beta.gt.0.0d0) then
      B11 = (B-1.0D0)*(CSIE1-CSII1)/(2.0D0*BETA*T)
      D11 = B*EPS*DLOG(CSIE1/CSII1)/(BETA*T)
      else
      b11 = 0
      d11 = 0
      endif
      ARG = MU*T*(1.0D0+B11+D11)/GAM0
      TRANS =  AI1*AE1*DEXP(-ARG) 
      eic3  = (CSIE1*CSIE1/B)*TRANS/B
      E(ic,4)  = eic3*(1.0d0-eloss)*ae1
      E(ic,5)  = TRANS/b                                          
      E(ic,6) = eic3*eloss
c     stick2 = E(ic,5)*eloss
      endif

C          (10,1020) TETA4(IC),Y(ic),TETA4(IC)*b,Y(ic)*b,E(IC,1),E(ic,4)
C			E(ic,2),E(ic,3)    
c      WRITE(10,1020) TETA4(IC),Y(ic),TETA4(IC)*b,Y(ic)*b,
c     $E(IC,1),E(ic,2),E(ic,3),E(ic,4) 
cC			E(ic,2),E(ic,3)    
cfer
csrio      WRITE(10,1020) TETA4(IC),Y(ic),TETA4(IC)*b,Y(ic)*b,
      WRITE(10,1020) TETA4(IC),TETA4(IC)*b,TETA4(IC)*180.0D-3/PI,
     1 Y(ic),E(IC,4),E(ic,6),E(ic,3),E(ic,1) 

61    CONTINUE                                                                  
1020  format (1x,8(1pe13.6,1x))       
c1020  format (1x,1pe13.6,1x,1pe13.6,1x,1pe13.6,1x,1pe13.6)
                                                                    

C Write Information file
        write (12,*) 'The angle values are referred to the crystal srf'
        write (12,*) '+++ incidence angle (deg) = ',             
     & (tetab+alpha)*180.0d0/PI
        write (12,*) '+++ exit angle (deg) = ',              
     & (pi-tetab+alpha)*180.0d0/PI
        write (12,*) ' '
        WRITE (12,*) ''
        write (12,*) 'radius of curvature [m]: ',radius
        write (12,*) 'min. radius of curvature [m]: ',rccmin
	if (radius.lt.rccmin) then
          write (*,*) 'radius of curvature [m]: ',radius
          write (*,*) 'min. radius of curvature [m]: ',rccmin
	  do i=6,12,6
	    write(i,*) ' '
	    write(i,*) '**** WARNING ****'
	    write(i,*) 
     $'> radius of curvature smaller than minimum'
     $  //' allowed by the theory <'
	    write(i,*) '**** WARNING ****'
	    write(i,*) ' '
	  enddo
	endif
        write (12,*) 'beta [deformation parameter]: ',beta
        write (12,*) 'fraction of new wavefields: ',eloss
        write (12,*) ' '
C        write (12,*) '>> F0 = ',F0
C        write (12,*) '>> FHR = ',FHR
C        write (12,*) '>> FHI = ',FHI  
C        WRITE (12,*) '>> CHI0I = ',CHI0I 
C        WRITE (12,*) '>> CHI0R = ',CHI0R

	       close(10)
	       close(12)
	       write (*,*) 
     $'Files cryst_pp.out and cryst_pp.inf written to disk.'

101   continue
      END

