PRO Xop_Spawn,command,Group=group,OnlyGetCommand=onlyGetCommand, $
  PreCommand=preCommand,SetWindowsHome=setWindowsHome, $
  CleanFiles=cleanFiles,noPath=noPath
 
;+
; NAME:
;       XOP_SPAWNS
;
; PURPOSE:
;       Spawns a XOP program.
;       The program adds the directory defined in the environment
;       variable XOP_BINARIES to the command string.
;       If the environment variable XOP_BINARIES_DEBUG is set,
;       information windows are presented for debugging purposes.
;
; CATEGORY:
;       XOP
;
; CALLING SEQUENCE:
;       XOP_SPAWN,command
;
; INPUTS:
;       command = a string (or array of strins) with the command(s) to be run.
;
;
; KEYWORD PARAMETERS:
;       GROUP:  The widget ID of the group leader of the widget.  If this
;               keyword is specified, the death of the group leader results i n
;               the death of widgets created by XOP_WD.
;	OnlyGetCommand: set this keyword to a named variable to get the
;		command to be run. When this keyword is used, XOP_SPAWN
;		does not spawn the process.
;	PreCommand: A command to be executed previously to the main 
;		block (command). The directory path is not added to 
;		this preCommand. Useful to define envoronment variables.
;	SetWindowsHome: if set, the XOP_HOME environment variable
;		(i.e., set XOP_HOME=c:\...) is added before execution.
;		This keyword is only used in Windows systems.
;	cleanFiles: a list of files to be deleted. This is the first 
;		process that is performed.
;	noPath: Set this kwyword to avoid adding binary path
;
; OUTPUTS:
;       None
;
; SIDE EFFECTS:
;
; PROCEDURE:
;       Straightforward.
;
; USE:
;       This procedure is to be used by XOP to spawn a command 
;	or array of command. It first adds the standard XOP
;	path to the application name and then starts it.
;
; EXAMPLES:
;       xop_spawn,'epath < epath.inp'
;
; MODIFICATION HISTORY:
;       Written by:     Manuel Sanchez del Rio (srio@esrf.fr) 98/11/05
;	99-01-12 srio@esrf.fr adds preCommand keyword. Allows command 
;		to be an array.
;	00-06-13 srio@esrf.fr adds cleanFiles keyword
;	00-06-16 srio@esrf.fr adds Mac support. By now the applescript
;		xop_run.mac and its xop_run.inp file must be on the current
;		directory.
;	2006-04-14 srio@esrf.fr adds noPath keyword.
;	2011-03-18 dejus@aps.anl.gov, added double quotes for commands on WINDOWS
;	2011-04-05 srio@esrf.eu mv double quotes to directory path only
;-
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'XOP_SPAWN: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return
ENDIF

osFamily = SDep()

;
; Clean files
;
IF Keyword_Set(cleanFiles) THEN Delete_Files,cleanFiles,Group=group

;
; For MacOS, remove the "<" sign, if exists
;
IF osFamily EQ 'MACOS' THEN BEGIN
  FOR i=0L,N_Elements(command)-1 DO BEGIN
    line = command[i]
    itmp = StrPos(line,'<')
    IF itmp[0] NE -1 THEN BEGIN
      line_new = StrSubstitute(line,'<','')
      command[i]=line_new
    ENDIF
  ENDFOR
ENDIF


;
; finds the directory where binaries are
;
IF osFamily NE 'MACOS' THEN BEGIN
  bindir = Xop_GetEnv('XOP_BINARIES')
  IF StrCompress(bindir,/Remove_All) EQ '' THEN BEGIN
    itmp = Dialog_Message(/Error,/Cancel,Dialog_Parent=group,$
      ['When running: '+command+':', $
       'Directory with XOP binaries not found.',$
       'It should be defined in the XOP_BINARIES environment variable.',$
       'Do you want to define it now for the current XOP session?'] )
    IF itmp EQ 'Cancel' THEN Return
    bindir = Dialog_Pickfile(group=group,Title=$
     'Select dir with XOP binaries',/Dir)
    IF bindir EQ '' THEN RETURN
    Xop_SetEnv,'XOP_BINARIES='+bindir
  ENDIF
;  ;
;  ; In windows, replace "Program Files" by "progra~1" to avoid problems...
;  ;
;  IF osFamily EQ 'WINDOWS' THEN BEGIN 
;     ;bindir=StrSubstitute(bindir,'Program Files','progra~1')
;     delim = '\'
;     n = StrParse(bindir,delim,list)
;     bindir2 = ''
;     FOR i=0,n DO BEGIN
;       IF StrEgex(list[i],' ') NE -1 THEN list[i]= $
;         StrMid(StrCompress(list[i],/Rem),0,6)+'~1'
;       bindir2 = bindir2+list[i]+delim
;     ENDFOR
;     bindir=bindir2
;  ENDIF
  ;
  ; adds directory separator
  ;
  IF StrCompress(bindir,/Remove_All) NE '' THEN BEGIN
    bindir=bindir+SDep(/DS)
    IF osFamily EQ 'WINDOWS' THEN BEGIN
	binDir = '"' +binDir +'"' ; add double quotes to command for WINDOWS
    ENDIF
  ENDIF
ENDIF ELSE bindir=''

IF Keyword_Set(nopath) THEN bindir=''

;
; gets first word in command (for displaying purposes).
;
ccc = StrMid(command[0],0,StrPos(command[0],' '))

;
; adds path to command
; 
IF osFamily NE 'MACOS' THEN command=bindir+command

;
; if SetWindowsHome kw is defined, add it.
; 
IF osFamily EQ 'WINDOWS' THEN $
  IF Keyword_Set(setWindowsHome) THEN command = $
  ['set XOP_HOME='+Xop_GetEnv('XOP_HOME'),command]
;
; if preCommand kw is defined, add it.
; 
IF Keyword_Set(preCommand) THEN command = [preCommand,command]

;
; if debug flag is set, show command
;
idebug=0
IF StrCompress(Xop_GetEnv('XOP_BINARIES_DEBUG'),/Remove_All) NE '' THEN BEGIN
  idebug = 1
  itmp = Dialog_Message(/Info,Dialog_Parent=group,/Cancel,$
    ['Debugging message: Start to run: ','',command])
  IF itmp EQ 'Cancel' THEN Return
ENDIF

;
; Spawns message
;
IF N_Elements(OnlyGetCommand) NE 0 THEN  BEGIN
  onlyGetCommand=command
  IF idebug EQ 1 THEN itmp = Dialog_Message(/Info,Dialog_Parent=group,$
    'Debugging message: Process completed (not run).')
  RETURN
ENDIF 


Print,'############# start running '+ccc+' ####################'

CASE osFamily OF
  'WINDOWS': BEGIN
        IF idebug EQ 1 THEN command=[command,'pause'] ELSE command=[command,'rem pause']
	;IF N_Elements(command) EQ 1 THEN BEGIN
	;  message,/info,'Executing: '+command
	;  spawn,command 
	;ENDIF ELSE BEGIN
	  OpenW,unit,'xop_spawn.bat',/Get_Lun
	  FOR i=0L, N_Elements(command)-1 DO PrintF,unit,command[i]
	  Free_Lun,unit
	  message,/info,'Executing: xop_spawn.bat'
	  Spawn,'xop_spawn.bat'
	  Wait,0.2
	  IF idebug NE 1 THEN BEGIN ; delete xop_spawn.bat
	    message,/info,'Deleting: xop_spawn.bat'
	    OpenW,unit,'xop_spawn.bat',/Get_Lun,/Delete
	    Free_Lun,unit
	  ENDIF
	  ;
	;ENDELSE
	END
  'MACOS' : BEGIN
	pwd=''
	CD,Current=pwd
	Delete_Files,['xop_run.inp']
	OpenW,unit,'xop_run.inp',/Get_Lun
	FOR i=0L, N_Elements(command)-1 DO PrintF,unit,command[i]
	Free_Lun,unit
	message,/info,'Executing AppleScript xop_run.mac that calls xop_ini.inp'
	Spawn,pwd+'xop_run.mac'
	;Wait,0.2
	;IF idebug NE 1 THEN BEGIN ; delete xop_run.inp
	;  message,/info,'Deleting: xop_run.inp'
	;  OpenW,unit,'xop_run.inp',/Get_Lun,/Delete
	;  Free_Lun,unit
	;ENDIF
	;
	END
  else : BEGIN ; UNIX
	FOR i=0L,N_Elements(command)-1 DO BEGIN
	  message,/info,'Executing: '+command[i]
	  spawn,command[i]
	ENDFOR
	END
ENDCASE
Print,'############# end running '+ccc+' ####################'

IF idebug EQ 1 THEN itmp = Dialog_Message(/Info,Dialog_Parent=group,$
    'Debugging message: Process run completed.')
 
END

