PRO Xop_SetEnv, command

;+
; NAME:
;       XOP_SETENV
;
; PURPOSE:
;       Simulates SetEnv for MacOS. The same as SetEnv on other platforms.
;
; CATEGORY:
;       XOP
;
; CALLING SEQUENCE:
;       Xop_SetEnv, 'VARIABLE=value'
;
; INPUTS:
;       command = variable name and its value (STRING)
;
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;       None
;
; SIDE EFFECTS:
;       Calls SetEnv except for MacOS where the data is stored in a "silo" buffer.
;
; PROCEDURE:
;       Uses a common block to store the object reference.
;       The "silo" buffer uses keys (variable names) that are case insensitive.
;       The stored data (values) are case sensitive.
;
; COMMON BLOCKS
;       COMMON xop_env, silo
;
; EXAMPLES:
;       Xop_SetEnv, 'XOP_HOME=c:\xop'
;
; MODIFICATION HISTORY:
;       Written  by: Manuel Sanchez del Rio (srio@esrf.fr) 99/01/04
;       Modified by: Roger J. Dejus (dejus@aps.anl.gov) 01/29/99.
;       Uses a "silo" buffer: An object data storage mechanism written by
;       Robert.Mallozzi@msfc.nasa.gov
;       02-03-13 srio@esrf.fr substitutes Str_Sep by StrSplit(/Extract)
;-

COMMON xop_env, silo

IF SDep() NE 'MACOS' THEN BEGIN
  SetEnv, command
  RETURN
ENDIF

IF N_Params() EQ 0 THEN BEGIN
  Message, /Continue, 'Incorrect number of arguments.'
  RETURN
ENDIF

IF Size(command,/TName) NE 'STRING' THEN BEGIN
  Message, /Continue, 'Argument needs to be of type STRING.'
  RETURN
END

; Get environmental variable and data from command
;comm = Str_Sep(command,'=')
comm = StrSplit(command,'=',/Extract)
IF N_Elements(comm) NE 2 THEN BEGIN
  Message, /Continue, "Invalid syntax, use Xop_SetEnv, 'variable=value'."
  RETURN
END
key  = comm[0]
data = comm[1]

IF not Obj_Valid(silo) THEN silo = Obj_New('silo')
silo->Set, key, data
  
RETURN
END
