FUNCTION zoom_manager,event,stateId,return_structure=return_structure
;+
;
; FUNCTION zoom_manager,event,stateId,return_structure=return_structure
;
; Implements a common tool for creating zoom
;
; Used in xsh_histo1, xsh_plotxy
;
; 2008-09-09 srio@esrf.eu
;
;-


out = 0

IF keyword_Set(return_structure) THEN BEGIN
  ; 
  ; This is for implementing the interactive zoom
  ;  Requires defining widget_draw as:
  ; WDraw = widget_draw(wbase, $
  ;	/MOTION_EVENTS,UVALUE='CURSOR',RETAIN=2, BUTTON_EVENTS=1)
  ;
  Window,/Free,XSize=10, YSize=10, /PixMap
  pixIndex=!D.Window
  
  out = {$
        flag:1, $
;        wZoom:0L, $  
;        wDraw:wDraw, $
        pixIndex:pixIndex, $ ; (needed for zoom)
        xs:0, $	; X static corner of the zoom box (needed for zoom) 
        ys:0, $	; Y static corner of the zoom box (needed for zoom) 
        xd:0, $	; X dynamic corner of the zoom box (needed for zoom) 
        yd:0, $ 	; Y dynamic corner of the zoom box (needed for zoom) 
        mousePressed:0, $
        zoomIn:0, $
        BoxColor:2 }
  RETURN,out
ENDIF


IF N_Elements(stateId) EQ 0 THEN stateid = event.handler
;stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state ; , /No_Copy

windownum = !d.window

; This part ONLY responds to button down events from the
; draw widget. If it gets a DOWN event, it does three things: (1) sets
; the static and dynamic corners of the zoom box, (2) changes the
; event handler for the draw widget to ZPLOT_DRAWBOX and turns on MOTION
; events, and (3) update the user's color table vectors.


IF event.press EQ 1 THEN state.zoom.mousePressed=1
IF event.release EQ 1 THEN state.zoom.mousePressed=0

possibleEventTypes = [ 'DOWN', 'UP', 'MOTION', 'SCROLL' ]
thisEvent = possibleEventTypes(event.type)

CASE thisEvent OF
  'DOWN': BEGIN
     ;
     ; Must be DOWN event to get here, so get state structure.
     ;
     ; Set the static corners of the box to current
     ; cursor location.
     ;
     coords = convert_coord(event.x,event.y,/device,/to_data)
     state.zoom.xs = event.x
     state.zoom.ys = event.y
     state.zoom.xd = event.x
     state.zoom.yd = event.y
     state.zoom.zoomin=0
     
     ; copy bitmap 
     wSize=[!d.x_size,!d.y_size]
     wset,state.zoom.pixIndex
     IF wSize[0] NE !d.x_size OR wSize[1] NE !d.y_size THEN BEGIN
        wdelete,state.zoom.pixIndex
        Window,/Free,XSize=wSize[0], YSize=wSize[1], /PixMap
        state.zoom.pixIndex=!d.window
     ENDIF
     Device, Copy = [0, 0, !d.x_size, !d.y_size, 0, 0, $
        windowNum]
     wset,windownum
     ;
     END
  'MOTION': BEGIN
     IF state.zoom.mousePressed EQ 1 THEN BEGIN

       ; Most of the action in this event handler occurs here while we 
       ; are waiting
       ; for an UP event to occur. As long as we don't get it, 
       ; keep erasing the
       ; old zoom box and drawing a new one.
       ; Erase the old zoom box.
       
        Device, Copy = [0, 0, !d.x_Size, !d.y_Size, 0, 0, $
          state.zoom.pixIndex]
       
       ; Update the dynamic corner of the zoom box to the current cursor location.
       
        state.zoom.xd = event.x
        state.zoom.yd = event.y
       
        ; Draw the zoom box.
       
        PlotS, [state.zoom.xs, state.zoom.xs, state.zoom.xd, state.zoom.xd, state.zoom.xs], $
              [state.zoom.ys, state.zoom.yd, state.zoom.yd, state.zoom.ys, state.zoom.ys], $
              /Device, Color=state.zoom.boxColor
       
              
     ENDIF
     END
  'UP': BEGIN
;        print,'xs: ',state.zoom.xs
;        print,'ys: ',state.zoom.ys
;        print,'xd: ',state.zoom.xd
;        print,'yd: ',state.zoom.yd
;        print,'FROM: ',convert_coord(state.zoom.xs,state.zoom.ys,/device,/to_data)
;        print,'TO: ',convert_coord(state.zoom.xd,state.zoom.yd,/device,/to_data)


;        ; zero selected area
;        IF (state.zoom.xs) EQ (state.zoom.xd) AND $
;           (state.zoom.ys) EQ (state.zoom.yd) THEN BEGIN
;print,'<><> zero region'
;          state.zoom.zoomin=0
;        ENDIF ELSE BEGIN
          state.zoom.zoomin=1
;        ENDELSE
     END
     else:
ENDCASE

IF state.zoom.zoomin EQ 1 THEN BEGIN
  cFrom=convert_coord(state.zoom.xs,state.zoom.ys,/device,/to_data)
  cTo=convert_coord(state.zoom.xd,state.zoom.yd,/device,/to_data)
  xrange=[min([cFrom[0],cTo[0]],max=tmp),tmp]
  yrange=[min([cFrom[1],cTo[1]],max=tmp),tmp]
  out = [xrange,yrange]
ENDIF

Widget_Control, stateid, set_UValue=state ; , /No_Copy

RETURN,out

END
