FUNCTION tags2struct,txt,file=file,path=path,group=group

;+
; NAME:
;	TAGS2STRUCT
; PURPOSE:
;	reads a text (or a file) containing tagged information and stores
;	it in an IDL structure. 
; CATEGORY:
;	String Processing
; CALLING SEQUENCE:
;	Result = TAGS2STRUCT( txt )
; INPUTS:
;    txt
;	Character string with input
; KEYWORD PARAMETERS:
;    FILE: file name with input
;    GROUP:  The widget ID of the group leader of the widget.  
;               the death of widgets created by XOP_WD.
; OUTPUTS:
;	Returns an IDL structure
; PROCEDURE:
;	Uses the make_str() function 
; EXAMPLE: 
;       a=tags2struct(['<starttext>kk','sjytdfgsd ','<endtext>kk'])
;       help,/str,a
;     ** Structure <8499bfc>, 1 tags, length=12, data length=12, refs=1:
;        KK              STRING    Array[1]
;
; MODIFICATION HISTORY:
;	Created March 2007 by Manuel Sanchez del Rio
;
;       2007-05-16 srio@esrf.eu added PATH keyword
;
;-


;file = 'xpowder.xop'
IF N_Elements(txt) EQ 0 THEN BEGIN
  IF N_Elements(file) EQ 0 THEN BEGIN
        file = Dialog_Pickfile(FILTER='*.xop',Title= $
          'Select an input file ',PATH=path,Group=group)
          IF file EQ '' THEN RETURN,0
  ENDIF
  ffile = read_textfile(file)
ENDIF ELSE BEGIN
  ffile = txt
ENDELSE
;
; remove comments
;
igood =  Where(StrMid(ffile,0,1) NE ';')
IF igood[0] NE -1 THEN ffile=ffile[igood]

;str = Create_Struct('info','File created by xopin on: '+SysTime())

istart = Where(StrMid(ffile,0,StrLen('<start')) EQ '<start')

;
; files without tags (ancient XOP input files: 
;
IF istart[0] EQ -1 THEN BEGIN
  str = Make_Str(ffile) 
  RETURN,str
ENDIF

;
; New files with tags
;
FOR i=0,N_Elements(istart)-1 DO BEGIN
   a=istart[i]
   b=Where(StrCompress(ffile,/Rem) EQ $
           StrCompress(StrSubstitute(ffile[a],'start','end'),/Rem) )
   tag = StrMid(ffile[a],0,StrPos(ffile[a],'>')+1)
   name = StrMid(ffile[a],strPos(ffile[a],'>')+1)
   if a[0] eq -1 or b[0] eq -1 then begin
      Message,/info,'End keyword not found :',ffile[a]
   endif else begin
      tmp = ffile[a+1:b-1]
   endelse
   CASE tag OF
      '<startstr>': var = Make_Str(tmp)
      '<starttext>': BEGIN
		var = tmp
		IF N_Elements(var) EQ 1 THEN var=var[0]
		END
     else:  Message, 'Tag not defined: '+tag
   ENDCASE
   IF N_Elements(str) EQ 0 THEN $
	str = Create_Struct(name,var) ELSE $
	str = Create_Struct(str,name,var)
ENDFOR
RETURN,str

END
