FUNCTION getfwhm,set,plot=plot,reverse_plot=reverse_plot,group=group, $
zerobase=zerobase,xxl=xxl,xxr=xxr
;+
; NAME:
;	GETFWHM
;
; PURPOSE:
;	This function calculates the FWHM of a curve
;
; CATEGORY:
;	X-ray optics utilities.
;
; CALLING SEQUENCE:
;
;	fwhm_value = getfwhm(rc)
;
; INPUTS:
;	rc: a fltarr(2,npts) with the curve
;
; OUTPUTS:
;	The fwhm value
;
; KEYWORD PARAMETERS:
;	PLOT:	when set to 1, put marks on the graphic y vs x
;	REVERSE_PLOT:	when set to 1, put marks on the graphic x vs y
;	GROUP = The widget ID of the widget that calls GETFWHM.
;		When this ID is specified, and GETFWHM fails to calculate
;		a result, them a widget message appears.
;	ZEROBASE: when set to 1, considers zero as minumum of the dataset
;
; OUTPUT KEYWORD PARAMETERS:
;	XXL = A name variable to retrieve the left abscisa for the FWHM
;	XXR = A name variable to retrieve the right abscisa for the FWHM
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		a = getfwhm(rc,/plot)
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio.
;	April, 1993	
;	93-10-21 MSR Small changes
;	96-07-10 MSR Makes a linear interpolation between the two 
;		closest points to the half-max value in order to account 
;		for a more precise value of the fwhm.
;	97-04-19 MSR takes the minimum value of the array (not zero)
;		for the calculation.
;
;       07-06-12 srio@esrf.eu fixes a bug when the FWHM lies at the histo
;		edges. 
;       09-03-03 srio@esrf.eu ads xxl and xxr output keywords
;-
on_error,2
;
; get the fwhm
;
z1=set(1,*)
x = set(0,*)
;
IF Keyword_Set(zeroBase) THEN BEGIN
  hm = (abs( max(z1) )/2.)
ENDIF ELSE BEGIN
  tmp=0
  hm = (abs( max(z1,min=tmp)-tmp )/2.)+tmp
ENDELSE
npts = n_elements(z1)
;for j=1,npts-1 do begin
;  if (z1(j-1) lt hm) and (z1(j) ge hm) then xleft = j
;endfor
;
;
xleft = 0L
j = 1L & i_found_left = 0
while (i_found_left eq 0) and (j le npts-1) do begin
  if (z1(j-1) lt hm) and (z1(j) ge hm) then begin
    xleft = j
    i_found_left = 1
  endif
  j = j+1
end
;help,i_found_left,xleft
;
xright = n_elements(z1) - 1
j = npts-1 & i_found_right = 0
while (i_found_right eq 0) and (j ge 1) do begin
  if (z1(j-1) gt hm) and (z1(j) le hm) then begin
    xright = j
    i_found_right = 1
  endif
  j = j-1
end
;help,i_found_right,xright
;if ( xleft  eq 0 or xright eq n_elements(z1) - 1 ) then begin
if ( i_found_left  eq 0 or i_found_right eq 0 ) then begin
  txt = 'Value not found. Returning 0.' 
  message,/info,txt
  if keyword_set(group) then itmp = Dialog_Message(Dialog_Parent=group,$
	'GETFWHM: '+txt)
  xxl=0 & xxr=0
  return,0
endif

; linear interpolation  left
m = (z1(xleft-1) - z1(xleft)) / (x(xleft-1) - x(xleft))
n = z1(xleft) - m*x(xleft)
xxl = (hm - n)/m
; linear interpolation  right
m = (z1(xright-1) - z1(xright)) / (x(xright-1) - x(xright))
n = z1(xright) - m*x(xright)
xxr = (hm - n)/m

;fwhm = abs(x(xleft)-x(xright))
fwhm = abs(xxl-xxr)
if keyword_set(plot) then $
  ;oplot,[0.5*(x(xleft)+x(xleft-1)),0.5*(x(xright)+x(xright-1))],[hm,hm],psym=1
  oplot,[xxl,xxr],[hm,hm],psym=1
if keyword_set(reverse_plot) then $
  ;oplot,[hm,hm],[0.5*(x(xleft)+x(xleft-1)),0.5*(x(xright)+x(xright-1))],psym=1
  oplot,[hm,hm],[xxl,xxr],psym=1

;
return,fwhm
end
