;
;=====================================================================
;
PRO edf_analyzer,file,str,LIST=list,ERROR=error,LOG=log, $
   sizeShit=sizeShit, $ ; for fit2d/edf files without size kw.
   verbose=verbose
;+
;
; Procedure edf_analyzer,file,str,list=list
;	
; this procedure analyzes a ESRF data formatted file and
; extracts its parameters (size, block's memory positions, header's
; memory positions, etc) in a structure str. 
; Keywords:
;    LIST: if set, then list the results
;    ERROR: set to a non zero  number if an error is found
;    LOG=LOG : strarr where to write the list of blocks. If log does
;             not exist creates it. If exist then appends the list to 
;             the already existent list. Columns are:
;             0 General counter, 1 file name, 2 local counter
;	      3 header size , 4 block size
; M. Sanchez del Rio 93/06/16
;		     94/03/31 MSR adds ERROR and LOG keywords
;		     99/11/16 renamed from analyzer_esrf to edf_analyzer
;		     99/11/17 modified the reading of the header. Now it
;			is done character by character instaed line by line. 
;			Needed for porting to windows. 
;		     2002/07/18 bug foxed in finding size kw.
;		     2008/06/23 srio@esrf.eu modified to accept fit2d/edf/klora 
;                       or strange files without the mandatory "Size" kw.
;                       (added sizeShit kw)
;		     2008/07/31 srio@esrf.eu adapted for compressed files
;
;-
;
on_error,2
;
; open the file
;

IF N_Elements(verbose) EQ 0 THEN verbose=0

IF StrLowCase(StrMid(file,StrLen(file)-3,3))  EQ '.gz' THEN  $
        compress=1 ELSE compress=0

openr,Unit,file,/get_lun,error=error,compress=compress
if (error NE 0) then begin
  print,'EDF_ANALYZER: Error opening file, Return.'
  return
endif
;
; open array for results
;
headers_block = lonarr(2,100)
headercounter = -1L
;
; dump file and get info
;
status = fstat(Unit)
;dumpfile = assoc(Unit,bytarr(status.size))
;
; start a loop to find all the headers
;
tmp = 0B
memory_pointer=0L
while (not(EOF(Unit)) AND (memory_pointer LT status.size)) do begin
  ;
  ; find the opening header position
  ;
  size = 0L
  char = -1
  while (char lt 0) AND (not EOF(Unit))  do begin
    point_lun,Unit*(-1),memory_pointer
    readu,Unit,tmp
    char = strpos(String(tmp),'{')
  end
  open0 = memory_pointer
  IF verbose THEN print,'EDF_ANALYZER: open header found at position ',open0
  ;
  ; find the closing header position and extract the 'size'
  ;
  char = strpos(String(tmp),'}')
  point_lun,Unit,memory_pointer
  while ( (char lt 0) and not(EOF(Unit)) ) do begin
    point_lun,Unit*(-1),memory_pointer
    readu,Unit,tmp
    char = strpos(String(tmp),'}')
  end
  close0 = memory_pointer
  IF verbose THEN print,'EDF_ANALYZER: close header found at position ',close0
  ;
  ; memorize the results
  ; 
  headercounter = headercounter + 1
  headers_block(0,headercounter) = open0
  headers_block(1,headercounter) = close0

  IF close0 GT open0 THEN BEGIN
  ; 
  ; extracts the header
  ;
  headerb = BytArr(close0-open0)
  point_lun,Unit,open0
  readu,Unit,headerb
  header = bytetotext(headerb)
  ;IF verbose THEN BEGIN
  ;   print,'HEADER********************************'
  ;   FOR ii=0,N_Elements(header)-1 DO Print,ii,'**',header[ii]
  ;   print,'END HEADER********************************'
  ;ENDIF
  ; 
  ; Find the size
  ;
  size = -1L
  FOR ii=0,N_Elements(header)-1 DO BEGIN
    result = StrPos(header[ii],'Size')
    if  result[0] NE -1 then  begin
      itmp = Execute(header[ii])
    endif
  ENDFOR
  IF size EQ -1 THEN BEGIN
    Message,/Info,'Error: keyword Size not found.'
    Message,/Info,'Trying corrupt edf from fit2d...'
    float = 44332211L
    FOR ii=0,N_Elements(header)-1 DO BEGIN
      result = StrPos(header[ii],'Dim_1')
      if  result[0] NE -1 then  itmp = Execute(header[ii])
      result = StrPos(header[ii],'Dim_2')
      if  result[0] NE -1 then  itmp = Execute(header[ii])
      result = StrPos(header[ii],'DataType')
      if  result[0] NE -1 then  itmp = Execute(header[ii])
    ENDFOR
    sizeShit=0L
    IF DataType EQ 44332211 THEN sizeShit=Long(Dim_1)*Long(Dim_2)*4L
    size=sizeShit
  ENDIF
    
  IF size EQ -1 THEN BEGIN
    Message,/Info,'Error: keyword Size not found.'
    str = 0
    RETURN
  ENDIF
  OUT:
  ;
  ; advance 'size' places in memory 
  ;
    if ( (close0+size+2) le status.size) then begin
       point_lun,Unit,close0+size+2
       point_lun,Unit*(-1),memory_pointer
       IF verbose THEN print,'EDF_ANALYZER: reset memory pointer at: ',close0+size+1
    endif else begin 
       point_lun,Unit,status.size
       point_lun,Unit*(-1),memory_pointer
       IF verbose THEN print,'EDF_ANALYZER: reset memory pointer at EOF: ',status.size
    endelse
  ENDIF
  ;
end                  ; end while loop
  ;
  ; create an array with the data block positions
  headers_block = headers_block(*,0:headercounter)
  data_block = lonarr(2,headercounter+1)
  data_block (0,*) = headers_block(1,*) + 2     ; I suppose a NL after the }
  for i=0,headercounter-1 do begin
    data_block (1,i) = headers_block(0,i+1) - 1
  endfor
  data_block(1,headercounter) = status.size -1
  for i=0,headercounter do begin
    if ( data_block (1,i) le data_block (0,i) ) then data_block(*,i) = 0
  endfor
  if (status.size -2 gt headers_block(1,headercounter)) then $
    data_block (1,headercounter)= status.size - 1 else $
    data_block (1,headercounter)= 0
free_lun,Unit
headersizes = lonarr(headercounter+1)
blocksizes  = lonarr(headercounter+1)
;
for i=0,headercounter do begin
  headersizes(i) = headers_block(1,i) - headers_block(0,i) + 1
  if ( data_block(1,i) gt data_block(0,i) ) then blksize= $
    data_block(1,i) - data_block(0,i) + 1 else blksize = 0
    blocksizes(i) =  blksize
endfor

if keyword_set(list) then begin
  print,'*************************************************************'
  print,'File analyzed is: ',status.name
  print,'         size is: ',status.size,' bytes'
  print,'The file has ',headercounter+1,' headers'
  print,' '
  print,'The positions for the headers are: '
  print,'   number   starting      ending        size     '
  for i=0,headercounter do $
    print,i,headers_block(0,i), headers_block(1,i), headersizes(i)
  print,'--------'
  print,'The positions for the data blocks are: '
  print,'   number   starting      ending        size     '
     
  for i=0,headercounter do $
    print,i,data_block(0,i), data_block(1,i), blocksizes(i)
  print,'*************************************************************'
endif
;
; write or append the log strarr
;
newlog = strarr(headercounter+1,6)
for i=0,headercounter do begin
  newlog(i,0) = strcompress((i),/rem)             ; global counter
  newlog(i,1) = file                              ; file name
  newlog(i,2) = strcompress((i),/rem)             ; local counter
  newlog(i,3) = strcompress(headersizes(i),/rem)  ; header size
  newlog(i,4) = strcompress(blocksizes(i),/rem)   ; block size
  newlog(i,5) = '0'                               ; file accumulation order
endfor
if keyword_set(log) then begin
  newlog(*,0) = strcompress( 1 + fix(newlog(*,0)) + $
     fix(log(n_elements(log(*,0))-1,0)), /rem)
  newlog(*,5) = strcompress( 1 + fix(newlog(*,5)), /rem)
  newlog = [log,newlog]
endif 
log=newlog
;
; write or update the structure
;
str = { name:file, type:'ESRF', size:status.size, $
   compress:compress, $
   nheaders:headercounter+1, $
   headerpos:headers_block, blockpos:data_block }
;
end
