FUNCTION moddist_trial, distx,disty,counter, xydirections=xydirections
;+
;
; FUNCTION moddist_trial, distx,disty,counter, xydirections=xydirections
;
; calculates distances from a patch "distance" (inputs: its x and y 
; coefficients in distx and disty) to the Lu and Lv axes, respectively. 
;
; The purpose is to project the coefficients onto two given directions 
;  in order to define a smaller patch that contains the intersection point.
; 
; Inputs: 
;        distx: matrix with x coefficients
;        disty: matrix with y coefficients
;        counter: 0 for returning direction to Lu, 1 for Lv
;        xydirection: flag to select the Lu and Lv directions: 
;                    0: Lu is the x axis, Lv is the y axis
;                    1: computes Lu and Lv following the formula 4.17
;			Pag 43 in "Efficirnet Ray Tracing of Trimmed
;			NURBS Surfaces" Master Thesis by A. Efremov, 
;			Max Planck Institute fur Informatik, 2004
;
;-

IF Not(Keyword_Set(xydirection)) THEN BEGIN
  CASE counter mod 2 OF
    0: BEGIN
      dist = disty
       END
    1: BEGIN
      dist = -distx
       END
  ENDCASE
ENDIF ELSE BEGIN
  L=l_vec2(distx,disty)
  ;a=containsorigin(distx,disty)
    CASE counter mod 2 OF
      0: BEGIN
         ;dist = (-L.lu[1]*distx + L.lu[0]*disty)/sqrt(1+(L.lu[1]/L.lu[0])^2)
         dist = (-L.lu[1]*distx + L.lu[0]*disty)/norm(L.lu)
         END
      1: BEGIN
         ;distance to y plane
         ;dist = (-L.lv[1]*distx + L.lv[0]*disty)/sqrt(1+(L.lv[1]/L.lv[0])^2) 
         dist = (-L.lv[1]*distx + L.lv[0]*disty)/norm(L.lv)
         END
    ENDCASE
ENDELSE

return, dist

END
