;
;+
;
;   ===========================  XSh_transmit   =========================
;
;   XSh_transmit is a widget based graphical interface to calculate 
;   the transmission in terms of energy vs flux or power of an x-ray
;   beamline. Source is generated by XSh_SRComp, XSh_Wiggler_Spectrum or
;   eneterd from external files [called XSH_SRCOMPE (eV,#Phot/sec/0.1%bw)
;   and SRCPMPW (eV, Watts/eV)].
;   The reflectivity and transmission coefficients are obtained from
;   the Fresnel equations.
;   XSh_transmit is an interface for the program transmit, available
;   in the SHADOW ray-tracing package.
;
;   The main window contains four buttons:
;
;	QUIT: to exit from the program
;
;	SET PARAMETERS: to define the parameters for the calculation
;	   these parameters are the following
;		NUMBER OF OPTICAL ELEMENTS to be used for the calculation.
;		min=1, max=5
;		RESULTS IN: Select Flux or Power for the presentation 
;		of results.
;		
;		Then 5 lines, one for each optica element [mirror or 
;		filter]. Lines are hidden when not used. Each line has
;			KIND OF ELEMENT: Filter or Mirror
;			SYMBOL OF ELEMENT: Capitalized, 2 letters.
;			FILTER THICKNESS in microns [if filter is selected].
;			INCIDENCE ANGLE in degrees [if mirror is selected].
;
;	SHOW:	Produces a graphic with the selected option
;		These options are:
;		SOURCE a graph of the source spectrum.
;		DATA show a list of important parameters of the 
;		optical elements in use.
;		LOCAL PROPERTIES [Reflectivity for mirrors and 
;		Transmission for filters] of each defined element.
;		The selection of each oe. is done inside the Xplot
;		graphical window.
;		CUMULATIVE PROPERTIES or the flux or power of the source
;		after being reduced by the optical elements to the actual
;		one.
;		The selection of each oe. is done inside the Xplot
;		graphical window.
;		Is therefore possible to use XPLOT's overplotting capacities 
;		to generate graphics containing all the curves. 
;
;	HELP:	Shows this text
;
; -----------------------------------------------------------------------
;	Author: M. Sanchez del Rio (srio@esrf.fr) , ESRF, Jan 1994
;	Modification history:
;		94/03/02 MSR removes the DENSITY entry. Uses the 
;		tabulated values in p_table. Also removes the limitation
;		in the chemical element symbols that had to duplicate
;		the letter in the symbols with only one character.
;		94/10/27 MSR removes common blocks, call xop_defaults
;		95/11/07 MSR adds file in/out. Adapts to xop 1.3b
;        Date     | Name  | Description
; ----------------+-------+-----------------------------------------------------
; 07-AUG-1995     | RJD   | Modified the help text.
; ----------------+-------+-----------------------------------------------------
; 17-JAN-1996     | MSR   | Modified the help text.
; ----------------+-------+-----------------------------------------------------
; 19-JAN-1996     | MSR   | Makes the oe. selection inside xplot.
;                 |       | Changes the help text.
; ----------------+-------+-----------------------------------------------------
;	97/01/16 srio@esrf.fr adapts for Windows95.
;	97/10/01 srio@esrf.fr renames read_ascii by rascii. Uses
;		shadow_defaults instead of xop_defaults. Uses SDEP().
;	97/10/02 srio@esrf.fr makes use of xop_wd,/default
;	97/12/05 srio@esrf.fr adapts for SHADOW-GUI. version 1.1
;
;-
;		
;========================================================================
;
FUNCTION XSh_TRANSMIT_VERSION
return,'1.1'
end
;
;========================================================================
;
PRO xtrans_inp_write,trans_str
;
openw,Unit,'xsh_transmit_tmp.inp',/GET_LUN
;
printf,Unit,'lo'
printf,Unit,'ro'
printf,Unit,'0'	; conversion to Watts/cm^2 to be fix with trans_str.Results
printf,Unit,'1'	; eV
;
;
;
nelem = fix(trans_str.nelements(0)) + 1
;print,'>>>> Nelements = ',nelem
;
printf,Unit,'1'
printf,Unit,'0'
printf,Unit,p_table(trans_str.el1_sym,/SHADOW)
printf,Unit,p_table(trans_str.el1_sym,/DENS)
printf,Unit,strcompress(trans_str.el1_des(0),/REM)
if (strcompress(trans_str.el1_des(0),/REM) eq '0') then $
	printf,Unit,strcompress(trans_str.el1_thi,/REM)		 else $
	printf,Unit,strcompress(trans_str.el1_inc,/REM)
printf,Unit,'Comment 1'
;
if nelem ge 2 then begin
  printf,Unit,'2'
  printf,Unit,'0'
  printf,Unit,p_table(trans_str.el2_sym,/SHADOW)
  printf,Unit,p_table(trans_str.el2_sym,/DENS)
  printf,Unit,strcompress(trans_str.el2_des(0),/REM)
  if (strcompress(trans_str.el2_des(0),/REM) eq '0') then $
	  printf,Unit,strcompress(trans_str.el2_thi,/REM)		 else $
	  printf,Unit,strcompress(trans_str.el2_inc,/REM)
  printf,Unit,'Comment 2'
endif 
;
if nelem ge 3 then begin
  printf,Unit,'3'
  printf,Unit,'0'
  printf,Unit,p_table(trans_str.el3_sym,/SHADOW)
  printf,Unit,p_table(trans_str.el3_sym,/DENS) 
  printf,Unit,strcompress(trans_str.el3_des(0),/REM)
  if (strcompress(trans_str.el3_des(0),/REM) eq '0') then $
	  printf,Unit,strcompress(trans_str.el3_thi,/REM)		 else $
	  printf,Unit,strcompress(trans_str.el3_inc,/REM)
  printf,Unit,'Comment 3'
endif 
;
if nelem ge 4 then begin
  printf,Unit,'4'
  printf,Unit,'0'
  printf,Unit,p_table(trans_str.el4_sym,/SHADOW)
  printf,Unit,p_table(trans_str.el4_sym,/DENS)
  printf,Unit,strcompress(trans_str.el4_des(0),/REM)
  if (strcompress(trans_str.el4_des(0),/REM) eq '0') then $
	  printf,Unit,strcompress(trans_str.el4_thi,/REM)		 else $
	  printf,Unit,strcompress(trans_str.el4_inc,/REM)
  printf,Unit,'Comment 4'
endif 
;
if nelem ge 5 then begin
  printf,Unit,'5'
  printf,Unit,'0'
  printf,Unit,p_table(trans_str.el5_sym,/SHADOW)
  printf,Unit,p_table(trans_str.el5_sym,/DENS)
  printf,Unit,strcompress(trans_str.el5_des(0),/REM)
  if (strcompress(trans_str.el5_des(0),/REM) eq '0') then $
	  printf,Unit,strcompress(trans_str.el5_thi,/REM)		 else $
	  printf,Unit,strcompress(trans_str.el5_inc,/REM)
  printf,Unit,'Comment 5'
endif 
printf,Unit,'-1'
;
free_lun,Unit
end
;
;========================================================================
;
PRO xSh_transmit_event,event,GROUP=group
;
WIDGET_CONTROL, event.id, GET_UVALUE=eventuval
widget_control, event.top, get_uvalue = trans_str

CASE eventuval OF
	'FILELOAD': BEGIN
		ffile = Dialog_Pickfile(title=$
		'Select XSh_transmit input file...',/NOCONF)
		if strcompress(ffile,/rem) EQ '' then return
		version = 0
		restore,ffile,/VERBOSE
		if version NE xSh_transmit_version() then itmp = $
		   Dialog_Message(Dialog_Parent=event.top, $
		  'Input file and current XSh_transmit have different versions.')
		widget_control,event.top,set_uvalue=trans_str
		END
	'FILEWRITE': BEGIN
		ffile = Dialog_Pickfile(/WRITE,file='xsh_transmit.inp')
		if strcompress(ffile,/rem) EQ '' then return
		version = xSh_transmit_version()
		command = 'save,version,trans_str,'+$
		'FILENAME='+"'"+strcompress(ffile,/rem)+"'"+',/VERBOSE'
		tmp = execute(command)
		itmp = Dialog_Message(Dialog_Parent=event.top,/INFO,$
			'File '+ffile+' written to disk.')
		END
        'QUIT': BEGIN
		  case sdep() of
		    'WINDOWS': command = ['del ro00*','del lo00*',$
			'del xsh_transmit_tmp.inp',$
		        'del SRCOMP','del TRANSMIT']
		    'UNIX': command = '/bin/rm -f ro00* lo00*'+$
			' xsh_transmit_tmp.inp SRCOMP TRANSMIT'
		    else: command = ''
		  endcase
		  xsh_run,command
                  WIDGET_CONTROL,event.top,/DESTROY
		END
	'SETPAR': BEGIN
		titles=[ ' ',' ','Number of oe ', 'Result in:', $
		'1st oe', 'Symbol:', 'Thick [microns]', $
			'Inc. angle [deg]', $
		'2nd oe', 'Symbol:', 'Thick [microns]', $
			'Inc. angle [deg]', $
		'3rd oe', 'Symbol:', 'Thick [microns]', $
			'Inc. angle [deg]', $
		'4th oe', 'Symbol:', 'Thick [microns]', $
			'Inc. angle [deg]', $
		'5th oe', 'Symbol:', 'Thick [microns]', $
			'Inc. angle [deg]' ]

		flags=['0','0','1','1', $
	 		'1','1','w(4) eq 0','w(4) eq 1', $

 			'w(2) ge 1','w(2) ge 1','w(2) ge 1 and w(8) eq 0',$
			'w(2) ge 1 and w(8) eq 1', $

 			'w(2) ge 2','w(2) ge 2','w(2) ge 2 and w(12) eq 0',$
			'w(2) ge 2 and w(12) eq 1',$

 			'w(2) ge 3','w(2) ge 3','w(2) ge 3 and w(16) eq 0',$
			'w(2) ge 3 and w(16) eq 1',$

 			'w(2) ge 4','w(2) ge 4','w(2) ge 4 and w(20) eq 0',$
			'w(2) ge 4 and w(20) eq 1']
		XscrMenu,trans_str,/NOTYPE,/INTERP,NROW=6, TITLES=titles, $
		FLAGS=flags, WTITLE='XSh_transmit input data',ACTION=action
		if action eq 'DO' then begin
		  xtrans_inp_write,trans_str
		  widget_control,event.top,set_uvalue=trans_str
		  print,'################ start running transmit ##############'
		  if ( strcompress(trans_str.Result(0),/REM) eq '0') then begin
		    if checkfile('XSH_SRCOMPE') NE 1 then begin
			itmp = Dialog_Message(Dialog_Parent=event.top, /ERROR,[$
			'File with source (XSH_SRCOMPE) not found.', $
			'Calculate source spectrum and use ', $
			"'Write files for transmit'",'option first.'])
			return
		    endif
		    case sdep() of
		      'UNIX': command = '/bin/cp XSH_SRCOMPE SRCOMP'
		      'WINDOWS': command = 'copy XSH_SRCOMPE SRCOMP'
		      else: command = ''
		    endcase
		    ;message,/info,'Executing: '+command
		    ;spawn,command
		  endif else begin
		    if checkfile('XSH_SRCOMPW') NE 1 then begin
			itmp = Dialog_Message(Dialog_Parent=event.top,/ERROR,[$
			'File with source (XSH_SRCOMPW) not found.', $
			'Calculate source spectrum and use ', $
			"'Write files for transmit'",'option first.'])
			return
		    endif
		    case sdep() of
		      'UNIX': command = '/bin/cp XSH_SRCOMPW SRCOMP'
		      'WINDOWS': command = 'copy XSH_SRCOMPW SRCOMP'
		      else: command = ''
		    endcase
		    ;message,/info,'Executing: '+command
		    ;spawn,command
		  endelse
		  ;
		  case sdep() of
		    'UNIX': command=[command,'/bin/rm -f lo000000* ro000000*']
		    'WINDOWS': command=[command,'del lo000000*','del ro000000*']
		    else: 
		  endcase
		  command = [command,'transmit < xsh_transmit_tmp.inp ']
		  xsh_run,command
		  print,' '
		  print,'################ end  running transmit  ##############'
		endif
		END
	'SOURCE':	BEGIN
		if ( strcompress(trans_str.Result(0),/REM) eq '0') then begin
		  tmp = rascii('XSH_SRCOMPE') 
		  ytitle='#Photons/sec/0.1%bw'
		endif else begin
		  tmp = rascii('XSH_SRCOMPW')
		  ytitle='Watts/eV'
		endelse
		if not(keyword_set(tmp)) then begin
		  itmp = Dialog_Message(Dialog_Parent=event.top,/ERROR,$
			['Source file not found.', $
			'Run XSh_SRComp or XSh_Wiggler_Spectrum ', $
			'with a correct option.'])
		endif else $
		  XPLOT,tmp,GROUP=event.top,xtitle= $
			'Photon Energy [eV]',ytitle=ytitle
		END
	'DATA':		Xdisplayfile1,'TRANSMIT',GROUP=event.top
	'LOCAL':	BEGIN
		widget_control,event.id,GET_VALUE=eventval
		IF ( strcompress(trans_str.Result(0),/REM) eq '0') then BEGIN
		  ytitle='#Photons/sec/0.1%bw' 
		  file = 'XSH_SRCOMPE'
		ENDIF ELSE BEGIN
		  ytitle='Watts/eV'
		  file = 'XSH_SRCOMPW'
		ENDELSE
		nelem = fix(trans_str.nelements(0)) + 1
		ielem = nelem
		;file = 'SRCOMP'
                if checkfile(file) NE 1 then begin
                  itmp = Dialog_Message(Dialog_Parent=event.top,/ERROR,[$
                        'file '+file+' not found.', $
                        'Calculate source spectrum and use ', $
                        "'Write files for transmit'",'option first.'])
                        return
		endif
		tmp = rascii(file)

		data1 = fltarr(nelem+2,n_elements(tmp(0,*)))
		data1(0:1,*) = tmp(0:1,*)
		for i=1,nelem do begin
		  file = 'lo000000'+strcompress(i,/REM)
                  if checkfile(file) NE 1 then begin
                    itmp = Dialog_Message(Dialog_Parent=event.top,/ERROR,[$
                        'file '+file+' not found.', $
                        'Calculate source spectrum and use ', $
                        "'Write files for XSh_transmit'",'option first.'])
                        return
                  endif
		  tmp = rascii(file)
		  data1(i+1,*) = tmp(1,*)
		endfor
		Elementstext = 'Element '+  $
			strcompress((sindgen(nelem+1))(1:nelem) )
		if ( strcompress(trans_str.Result(0),/REM) eq '0') then $
		  srctxt='Source: #Ph/sec/0.1%bw' else srctxt='Source: W/eV'
		Xplot,data1,GROUP=event.top,YCOL=ielem+2, $
			title='TRANSMIT: LOCAL properties.', $
			xtitle='-1', ytitle='-1', $
			coltitles=['Photon Energy [eV]',srctxt,$
			  Elementstext]
		END
	'CUMUL':	BEGIN
		widget_control,event.id,GET_VALUE=eventval
		nelem = fix(trans_str.nelements(0)) + 1
		;ielem = fix(eventval)
		ielem = nelem
		file = 'SRCOMP'
                if checkfile(file) NE 1 then begin
                  itmp = Dialog_Message(Dialog_Parent=event.top,/ERROR,[$
                      'file '+file+' not found.', $
                      'Calculate source spectrum and use ', $
                      "'Write files for XSh_transmit'",'option first.'])
                      return
                endif
		tmp = rascii(file)
		data1 = fltarr(nelem+2,n_elements(tmp(0,*)))
		data1(0:1,*) = tmp(0:1,*)
		for i=1,nelem do begin
		  file = 'ro000000'+strcompress(i,/REM)
                  if checkfile(file) NE 1 then begin
                    itmp = Dialog_Message(Dialog_Parent=event.top,/ERROR,[$
                        'file '+file+' not found.', $
                        'Calculate source spectrum and use ', $
                        "'Write files for XSh_transmit'",'option first.'])
                        return
                  endif
		  tmp = rascii(file)
		  data1(i+1,*) = tmp(1,*)
		endfor
                Elementstext = 'Up to oe.'+  $
                        strcompress((sindgen(nelem+1))(1:nelem) )
		if ( strcompress(trans_str.Result(0),/REM) eq '0') then $
		  unitstxt=' [#Ph/sec/0.1%bw]' else unitstxt=' [Watts/eV]'
		Xplot,data1,GROUP=event.top,YCOL=ielem+2, $
			xtitle='-1', ytitle='-1', $
			title='TRANSMIT: Cumulative properties', $
			coltitles=['Photon Energy [eV]','Source'+unitstxt,$
			  Elementstext+unitstxt]
		END
	'HELP':	xhelp,'xsh_transmit',GROUP=event.top
	else:
endcase
;
end
;
;========================================================================
;
PRO xsh_transmit,GROUP=group
;

if xregistered('xsh_transmit') then begin
  Message,/info,'Only a single XSh_Transmit window is allowed.'
  return
endif

;
; create widgets
;
xtbase=WIDGET_BASE(/COLUMN,TITLE='Xsh_transmit '+xsh_transmit_version())
XPdMenu, ['"File" {',$
			'"Load XSh_transmit input file..."  FILELOAD',$
			'"Write XSh_transmit input file..." FILEWRITE',$
			'"Quit"		QUIT',$
                        '}',$
        '"Set Parameters"	SETPAR', $
        '"Show" {',$
                        '"Source"         		SOURCE',$
                        '"Data"         		DATA',$
        		'"Local properties." 		LOCAL', $
        		'"Cumulative properties."	CUMUL',$
                        '}',$
        '"Help" 		HELP' ], xtbase



if sdep() EQ 'WINDOWS' then begin
  font1 = 'VERDANA*BOLD*ITALIC*36'
  font2 = 'VERDANA*BOLD*ITALIC*24'
endif else begin
  font1='-b&h-lucida-bold-i-normal-sans-24-240-75-75-p-151-iso8859-1'
  font2 = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'
endelse

wtmp = WIDGET_LABEL( xtBASE, FONT=font1, VALUE=' TRANSMIT')
wtmp = WIDGET_LABEL( xtBASE, FONT=font2, VALUE=' Mirror/Filter transmission')
wtmp = WIDGET_LABEL( xtBASE, FONT=font2, VALUE=' effect on source')
wtmp = WIDGET_LABEL( xtBASE, FONT=font2, VALUE=' (SHADOW utilities) ')


widget_control,xtbase,set_uvalue=xsh_defaults_utils('XSh_Transmit'),/NO_COPY
WIDGET_CONTROL,/REALIZE,xtbase
XMANAGER,'xsh_transmit',xtbase,GROUP_LEADER=group,/No_Block
;
end

