FUNCTION nrb2bzr, nrbsurf

;+ 
; 
; FUNCTION nrb2bzr, nrbsurf
; 
; Converts a NURBS surface into a BEZIER surface
;
; Method: the multiplicity of each knot in BEZIER must be 
;         p+1, being p the degree of the corresponding 
;         polynomial, or p=order-1
;	  It uses the internal function: 
;         __nrbrefineknotsvectsurface()
;
; It does not work for curves. 
;-

p=nrbsurf.p
q=nrbsurf.q
nu=n_elements(nrbsurf.uknots)
nv=n_elements(nrbsurf.vknots)

IF nu GT 2*(p+1) THEN BEGIN ; to avoid {0,0,0,0,1,1,1,1} IF p=3
    iku=nrbsurf.uknots(p+1: nu-p-2)
    temp1=iku[uniq(iku,sort(iku))]
    temp2=dblarr((p+1)*n_elements(temp1)-n_elements(iku))

    hh=0
    FOR ii=0,n_elements(temp1)-1 DO BEGIN
       a=where(temp1[ii] EQ iku)
       b = p+1 - n_elements(a)
       IF b NE 0 THEN BEGIN
         FOR  jj=0,b-1 DO BEGIN
          temp2[hh]=temp1[ii]
          hh++
         ENDFOR
       ENDIF
    ENDFOR

    iku=temp2

    bzr=__nrbrefineknotsvectsurface(nrbsurf,iknotsU=ikU)

ENDIF ELSE BEGIN

    bzr=nrbsurf

ENDELSE

;
; the same for the v direction
;
hh=0
ii=0
jj=0

IF nv GT 2*(q+1) THEN BEGIN

    ikv=nrbsurf.vknots(q+1: nv-q-2)
    temp1=ikv[uniq(ikv,sort(ikv))]
    temp2=dblarr((q+1)*n_elements(temp1)-n_elements(ikv))
    hh=0
    FOR ii=0,n_elements(temp1)-1 DO BEGIN
       a=where(temp1[ii] EQ ikv)
       b = q+1 - n_elements(a)
       IF b NE 0 THEN BEGIN
         FOR  jj=0,b-1 DO BEGIN
          temp2[hh]=temp1[ii]
          hh++
         ENDFOR
       ENDIF
    ENDFOR
    ikv=temp2
    bzr = __nrbrefineknotsvectsurface(bzr,iknotsV=ikV)
ENDIF ELSE BEGIN
    bzr=bzr
ENDELSE

return,bzr

END
