; 
;===============================================================================
;
Pro xshoe_f_refrac,oestr,GROUP=group,ACTION=action

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHOE_F_REFRAC: Error caught: '+$
	!err_string,/error)
   return
endif

if n_elements(oestr) EQ 0 then oestr=read_gfile('exafin.exa')

titles=[ $
         'optical constants/refraction index ',$
         'refractive index in object medium',$
         'attenuation in object medium [cm^-1]', $
         'file (prerefl) for OBJECT medium',$
         'Fresnel Zone Plate',$
         'refractive index in image medium',$
         'attenuation in image medium [cm^-1]',$
         'file (prerefl) for IMAGE medium']

flags = replicate('1',n_elements(titles))
flags[1:2]='w(0) EQ 0 OR w(0) EQ 2'
flags[5:6]='w(0) EQ 0 OR w(0) EQ 1'
;flags[[1,2,5,6]]='w(0) EQ 0'
flags[3]='w(0) EQ 1 OR w(0) EQ 3'
flags[7]='w(0) EQ 2 OR w(0) EQ 3'
 
tmp =    { $
   F_R_IND:[strcompress(oestr.F_R_IND,/rem),$
        'constant (in both OBJECT and IMAGE media)', $
        'from preprocessor (prerefl) in OBJECT medium', $
        'from preprocessor (prerefl) in IMAGE medium', $
        'from preprocessor (prerefl) in both media'], $
   R_IND_OBJ:oestr.R_IND_OBJ, $
   R_ATTENUATION_OBJ:oestr.R_ATTENUATION_OBJ, $
   FILE_R_IND_OBJ:oestr.FILE_R_IND_OBJ, $
   ;
   FZP:[strcompress(oestr.FZP,/rem),'No','Yes'], $
   R_IND_IMA:oestr.R_IND_IMA, $
   R_ATTENUATION_IMA:oestr.R_ATTENUATION_IMA, $
   FILE_R_IND_IMA:oestr.FILE_R_IND_IMA } 

action=0
XScrMenu,tmp,/NOTYPE,/INTERPRET,wtitle='Optical constants - Refractive Index',$
  FLAGS=flags,TITLES=titles,ACTION=action,GROUP=group,NCOL=2

if action eq 'DONT' then return

oestr.R_IND_OBJ = tmp.R_IND_OBJ
oestr.R_IND_IMA = tmp.R_IND_IMA

oestr.R_ATTENUATION_OBJ = tmp.R_ATTENUATION_OBJ
oestr.R_ATTENUATION_IMA = tmp.R_ATTENUATION_IMA

oestr.FILE_R_IND_OBJ = tmp.FILE_R_IND_OBJ
oestr.FILE_R_IND_IMA = tmp.FILE_R_IND_IMA

oestr.FZP = fix(tmp.FZP[0])
oestr.F_R_IND = fix(tmp.F_R_IND[0])

;help,oestr.FZP
;print,oestr.FZP

return
end

