;		
;========================================================================
;
PRO Shadow_RunSource, input, index, Only_Run=only_run,  Group=group

;+
; NAME:
;	SHADOW_RUNSOURCE
; PURPOSE:
;	Interface for source definition and system call to Shadow3
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	shadow_runsource
; INPUTS:
; OPTIONAL INPUTS:
;	input: the macro parent widget ID or structure (usually from COMMON)
;	index: 0 (Geometric), 1 (BM), 2 (Wiggler), 3 (Undulator)
; KEYWORD PARAMETERS:
;       ONLY_RUN: Does not open the parameter windows, only runs shadow3
;       GROUP The parent id for the caller widget (used to positioning
;               error and information windows).
; OUTPUTS:
; COMMON BLOCKS:
;       COMMON shadow_ifc,parent1
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
; MODOFICATION HISTORY:
;	srio@esrf.eu 20140627, added doc, separated from shadow.pro
;
;-
COMMON shadow_ifc,parent1

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /Cancel
   Message,/Info,'Error caught: '+!err_string
   itmp = Dialog_Message('SHADOW_RUNSOURCE: Error caught: '+$
	!err_string,/Error,Dialog_Parent=group)
   RETURN
ENDIF


CASE type(input) OF
  0: wid=parent1 ; undefined
  3: wid=input   ; widget_parent
  8: BEGIN ; state (structure)
     wid=0L
     state=input
     END
  else: Message,'Bad input'
ENDCASE
IF Widget_Info(wid,/Valid_Id) THEN Widget_Control,wid,Get_UValue=state

IF N_Elements(index) EQ 0 THEN BEGIN
  index=-1
  Widget_Control,state.wids.src,Get_Value=index
ENDIF

IF N_Elements(only_Run) EQ 0 THEN only_Run=0

CASE index OF
	  0: BEGIN
		if not(Ptr_Valid(state.PtrSrc(0))) then begin
		  PtrTmp = Ptr_New(xsh_defaults('XSH_SOURCE_G'))
		  state.PtrSrc(0) = PtrTmp
                  IF Widget_Info(wid,/Valid_Id) THEN $
                     Widget_Control,wid,Set_UValue=state
		endif
		XSh_Source,state.PtrSrc(0),Group=group, $
			Only_Run=only_Run
		END
	  1: BEGIN
		if not(Ptr_Valid(state.PtrSrc(1))) then begin
		  PtrTmp = Ptr_New(xsh_defaults('XSH_SOURCE_BM'))
		  state.PtrSrc(1) = PtrTmp
                  IF Widget_Info(wid,/Valid_Id) THEN $
                     Widget_Control,wid,Set_UValue=state
		endif
		XSh_Source,state.PtrSrc(1),Group=group, $
			Only_Run=only_Run,/BM
		END
	  2: BEGIN
		if not(Ptr_Valid(state.PtrSrc(2))) then begin
		  PtrTmp = Ptr_New(xsh_defaults('XSHWIG'))
		  state.PtrSrc(2) = PtrTmp
                  IF Widget_Info(wid,/Valid_Id) THEN $
                     Widget_Control,wid,Set_UValue=state
		endif
		XShWig,state.PtrSrc(2),Group=group, $
			Only_Run=only_Run
		END
	  3: BEGIN
		if not(Ptr_Valid(state.PtrSrc(3))) then begin
		  PtrTmp = Ptr_New(xsh_defaults('XSHUNDUL'))
		  state.PtrSrc(3) = PtrTmp
                  IF Widget_Info(wid,/Valid_Id) THEN $
                     Widget_Control,wid,Set_UValue=state
		endif
		XShUndul,state.PtrSrc(3),Group=group, $
			Only_Run=only_Run
		END
	  else:
ENDCASE




END ; Shadow_RunSource
