FUNCTION vecroty,angle, deg=deg

;+
;
; FUNCTION vecroty,angle, deg=deg
;
; Written by D. Bianchi, ESRF, 2006
;
;//
;// Function Name:
;//
;//   vecroty - Transformation matrix for a rotation around the y axis.
;//
;// Calling Sequence:
;//
;//   ry = vecroty(angle);
;//
;// Parameters:
;//
;//   angle     : rotation angle defined in radians
;//
;//   ry       : (4x4) Transformation matrix.
;//
;//
;// Description:
;//
;//   Return the (4x4) Transformation matrix for a rotation about the y axis
;//   by the defined angle.
;//
;//   The matrix is:
;//
;//         [  cos(angle)       0        sin(angle)       0]
;//         [      0            1            0            0]
;//         [ -sin(angle)       0        cos(angle)       0]
;//         [      0            0            0            1]
;//
;-

IF keyword_set(deg) THEN angle=angle*!dpi/180D

sn = sin(angle)
cn = cos(angle)

ry = double([[cn, 0, sn, 0],[0, 1, 0, 0],[ -sn, 0, cn, 0], [0, 0, 0, 1]])

ind=where(abs(ry) LT 1e-6)
ry[ind]=0

return, ry

END
