;***************mirror ellip definition************
function blv_mirror_ellip, baseX, baseY, nb_cotte=nb_cotte, prof=hauteur, $
	Color=color


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_mirror_ellip: error caught: '+!error_state.msg)
   RETURN,0
ENDIF



if n_elements(hauteur) eq 0 then hauteur=0.03
if n_elements(color) eq 0 then color=[100,100,255]
if n_elements(nb_cotte) eq 0 then nb_cotte=16
da=(2*!dpi/nb_cotte)
point=fltarr(nb_cotte*2,3)
a=0
for p=0, nb_cotte-1 do begin
	point[p*2,*]=[baseX*cos(a),baseY*sin(a),-hauteur]
	point[p*2+1,*]=[baseX*cos(a),baseY*sin(a),0]
	a=a+da
endfor
t=size(point)
mirror=obj_new('idlgrmodel')
; le tour
connex=intarr(5,nb_cotte)
for p=0, nb_cotte-2 do begin
	connex[*,p]=[4,(p*2),(p*2)+1,(p*2)+3,(p*2)+2]
end
connex[*,nb_cotte-1]=[4,((nb_cotte-2)*2)+2,((nb_cotte-2)*2)+3,1,0]
connexH=[nb_cotte]
connexB=[nb_cotte]

for p=0, nb_cotte-1 do begin
	connexH=[connexH, p*2]
	connexB=[connexB, p*2+1]
endfor
;print, connex
;print, size(connex)
mirror->add, obj_new('idlgrpolygon', Point[*,0],Point[*,1],Point[*,2], $
						POLYGONS =connex, Color=color, /SHADING)
mirror->add, obj_new('idlgrpolygon', Point[*,0],Point[*,1],Point[*,2], $
						POLYGONS =connexB, Color=color, /SHADING)
mirror->add, obj_new('idlgrpolygon', Point[*,0],Point[*,1],Point[*,2], $
						POLYGONS =connexH, Color=color, /SHADING)



;for s=0, nb_cotte-1 do begin
	; les bouts
;	mirror->add, blv_surface(pPoint,(s*2),(s*2)+2,t[2]-2,Color=color)
;	mirror->add, blv_surface(pPoint,(s*2)+1,(s*2)+3,t[2]-1,Color=color)
;endfor
;ptr_free, pPoint
return, mirror
end
;**********************************************
