;+
; NAME:
;       blv_change_view.
;
; PURPOSE:
;       This procedure change the view orientation, function to predefine 
;		angle
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;       blv_change_view, pInfo, button
;
; INPUTS:
;       pInfo:    A pointer on the blviewer uValue.
;		button: an integer 0->Perspective
;							1->x/y
;							2->y/z
;							3->x/z
;							4->customize perspective
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, 2001
;-

pro blv_change_view, pInfo, button


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_change_view: error caught: '+!error_state.msg)
   RETURN
ENDIF



case button of
	'0': begin
			(*pInfo).wid.model->reset
			(*pInfo).wid.model->rotate, [1,0,0], ((*pInfo).data.PerspectiveAngle)[0]
			(*pInfo).wid.model->rotate, [0,1,0], ((*pInfo).data.PerspectiveAngle)[1]
			(*pInfo).wid.model->rotate, [0,0,1], ((*pInfo).data.PerspectiveAngle)[2]
		end
	'1': begin
		(*pInfo).wid.model->reset
		(*pInfo).wid.model->rotate, [0,0,1],-90

		end
	'2':begin
		(*pInfo).wid.model->reset
		(*pInfo).wid.model->rotate, [0,0,1], -90
		(*pInfo).wid.model->rotate, [1,0,0], -90
		end
	'3':begin
		(*pInfo).wid.model->reset
		(*pInfo).wid.model->rotate, [1,0,0], -90
		end
	'4':begin
		blv_set_angle, pInfo
		end
	endcase
end
