;		
;========================================================================
;
;
PRO Shadow_Run, input, Source=source, Trace=trace, Macros=macros, $
  All=all, Group=group, oneMacro=oneMacro


;+
; NAME:
;	SHADOW_RUN
; PURPOSE:
;	Interface for system call to Shadow3
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	shadow_run
; INPUTS:
; OPTIONAL INPUTS:
;	input: the macro parent widget ID or structure (usually from COMMON)
; KEYWORD PARAMETERS:
;       ALL: If set, runs the source+trace+macros
;       SOURCE: If set, runs the source
;       TRACE: If set, runs trace
;       MACROS: If set, runs all macros
;       ONEMACRO: Runs a single macro: set this to the macro index. 
;       GROUP The parent id for the caller widget (used to positioning
;               error and information windows).
; OUTPUTS:
; COMMON BLOCKS:
;       COMMON shadow_ifc,parent1
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	calls shadow_runsource, shadow_runtrace,shadow_runmacros
; MODOFICATION HISTORY:
;	srio@esrf.eu 20140627, added doc, separated from shadow.pro
;
;-
COMMON shadow_ifc,parent1

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /Cancel
   Message,/Info,'Error caught: '+!err_string
   itmp = Dialog_Message('SHADOW_RUN: Error caught: '+$
	!err_string,/Error,Dialog_Parent=group)
   RETURN
ENDIF

CASE type(input) OF
  0: BEGIN ; undefined
     wid = parent1
     END
  3: BEGIN ; widget_parent
     wid=input
     END
  8: BEGIN ; state (structure)
     wid = input.wids.main
     END
  else: Message,'Bad input'
ENDCASE


IF Keyword_Set(all) THEN BEGIN
  source = 1
  trace = 1
  macros = 1
ENDIF

IF Keyword_Set(source) THEN BEGIN
  Widget_Control,wid,Get_UValue=state
  src_index=-1
  Widget_Control,state.wids.src,Get_Value=src_index
  Shadow_RunSource,input,src_index,/Only_Run,Group=group
ENDIF

IF Keyword_Set(trace) THEN Shadow_RunTrace,input,Group=group

IF Keyword_Set(macros) THEN Shadow_RunMacro,input,Group=group

IF N_Elements(oneMacro) GT 0 THEN Shadow_RunMacro,input,oneMacro,Group=group

END ; Shadow_Run

