;+
;
; FUNCTION distgrid, plane,bzr
;
; ARGUMENTS
;   PLANE = 2 planes intersection (see RAY2PLANE.PRO)
;   BZR =  bezier patch
; OUTPUT
;   DIST = bezier patch of distances
;
; See Nishita's paper
;
;-

FUNCTION distgrid, plane,bzr

; spline formed by the intersection of the surface with first plane
; a Xij + b Yij +c Zij +D
distX = ((plane.nx[0]*bzr.xgrid + plane.nx[1]*bzr.ygrid + plane.nx[2]*bzr.zgrid) + plane.dx*bzr.wgrid)

; spline formed by the intersection of the surface with second plane
; a Xij + b Yij +c Zij +D
distY = ((plane.ny[0]*bzr.xgrid + plane.ny[1]*bzr.ygrid + plane.ny[2]*bzr.zgrid) + plane.dy*bzr.wgrid)

; zeroes
distZ = intarr(bzr.dim[1],bzr.dim[0])


;conversion to 3d grid
grid=nrbconvsurf(xx=distx,yy=disty,zz=distz,weights=bzr.wgrid)

;bezier patch of distances
dist=nrbstruct(grid,bzr.uknots,bzr.vknots)

return,dist

END
