FUNCTION u_par_trial, dist,u, verbose=verbose

;
; interpolates linearly 
;
nx=n_elements(dist[0,*])
ny=n_elements(dist[*,0])


uu=nrblinear(0d,1d,nx, grid=ny)
temp1=[[dist[0,0],dist[ny-1,0]],[dist[0,nx-1],dist[ny-1,nx-1]]]

m=(dist[*,0:nx-2]-dist[*,1:nx-1])/(uu[*,0:nx-2]-uu[*,1:nx-1])

q=-m*uu[*,1:nx-1]+dist[*,1:nx-1]
x=-q/m
temp2=dist[*,0:nx-2]*dist[*,1:nx-1]
counter=where(temp2 LE 0)
nc=n_elements(counter)

IF counter[0] NE -1 THEN BEGIN
  x=x[counter]
  m=m[counter]
	IF nc GE 2 THEN BEGIN
          IF Keyword_Set(verbose) THEN message,/continue,'OK'
	  temp=[min(x,max=umax),umax]
	ENDIF ELSE BEGIN
	  cond=temp1[0]*temp1[1]
	  IF cond EQ 0 THEN BEGIN
                IF Keyword_Set(verbose) THEN message,/continue,'cond EQ 0'
		IF m GT 0 THEN temp=[x,1d]
		IF m LT 0 THEN temp=[0d,x]
		IF m EQ 0 THEN temp=[0d,1d]
	  ENDIF
	  IF cond LT 0 THEN BEGIN
             IF Keyword_Set(verbose) THEN message,/continue,'cond LT 0'
	     ;temp=[0d,x]
	     temp=[0d,1]
	  ENDIF 
	  IF cond GT 0 THEN BEGIN
             IF Keyword_Set(verbose) THEN message,/continue,'cond GT 0'
             ;temp=[x,1d]
             temp=[0d,1d]
	  ENDIF
	ENDELSE
ENDIF ELSE BEGIN
  IF Keyword_Set(verbose) THEN message,/continue,'not found'
  return,u
  ;temp=[0d,1d]
ENDELSE

u=u[0] + (u[1]-u[0])*temp

;print,'--------------'
;print,dist
;print,'temp: ',temp
;print,'u: ',u
return,u

END
